/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResolverXPointer
extends ResourceResolverSpi {
    private static Log log = LogFactory.getLog(ResolverXPointer.class);
    private static final String XP = "#xpointer(id(";
    private static final int XP_LENGTH = "#xpointer(id(".length();

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolveURI(ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        Object object;
        Node node = null;
        Document document = resourceResolverContext.attr.getOwnerElement().getOwnerDocument();
        if (ResolverXPointer.isXPointerSlash(resourceResolverContext.uriToResolve)) {
            node = document;
        } else if (ResolverXPointer.isXPointerId(resourceResolverContext.uriToResolve)) {
            Object[] objectArray;
            object = ResolverXPointer.getXPointerId(resourceResolverContext.uriToResolve);
            node = document.getElementById((String)object);
            if (resourceResolverContext.secureValidation && !XMLUtils.protectAgainstWrappingAttack((Node)(objectArray = resourceResolverContext.attr.getOwnerDocument().getDocumentElement()), (String)object)) {
                Object[] objectArray2 = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MultipleIDs", objectArray2, resourceResolverContext.attr, resourceResolverContext.baseUri);
            }
            if (node == null) {
                objectArray = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MissingID", objectArray, resourceResolverContext.attr, resourceResolverContext.baseUri);
            }
        }
        object = new XMLSignatureInput(node);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        if (resourceResolverContext.baseUri != null && resourceResolverContext.baseUri.length() > 0) {
            ((XMLSignatureInput)object).setSourceURI(resourceResolverContext.baseUri.concat(resourceResolverContext.uriToResolve));
        } else {
            ((XMLSignatureInput)object).setSourceURI(resourceResolverContext.uriToResolve);
        }
        return object;
    }

    public boolean engineCanResolveURI(ResourceResolverContext resourceResolverContext) {
        if (resourceResolverContext.uriToResolve == null) {
            return false;
        }
        return ResolverXPointer.isXPointerSlash(resourceResolverContext.uriToResolve) || ResolverXPointer.isXPointerId(resourceResolverContext.uriToResolve);
    }

    private static boolean isXPointerSlash(String string) {
        return string.equals("#xpointer(/)");
    }

    private static boolean isXPointerId(String string) {
        if (string.startsWith(XP) && string.endsWith("))")) {
            String string2 = string.substring(XP_LENGTH, string.length() - 2);
            int n = string2.length() - 1;
            if (string2.charAt(0) == '\"' && string2.charAt(n) == '\"' || string2.charAt(0) == '\'' && string2.charAt(n) == '\'') {
                if (log.isDebugEnabled()) {
                    log.debug("Id = " + string2.substring(1, n));
                }
                return true;
            }
        }
        return false;
    }

    private static String getXPointerId(String string) {
        if (string.startsWith(XP) && string.endsWith("))")) {
            String string2 = string.substring(XP_LENGTH, string.length() - 2);
            int n = string2.length() - 1;
            if (string2.charAt(0) == '\"' && string2.charAt(n) == '\"' || string2.charAt(0) == '\'' && string2.charAt(n) == '\'') {
                return string2.substring(1, n);
            }
        }
        return null;
    }
}

