/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import java.io.FileInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;

public class ResolverLocalFilesystem
extends ResourceResolverSpi {
    private static final int FILE_URI_LENGTH = "file:/".length();
    private static Log log = LogFactory.getLog(ResolverLocalFilesystem.class);

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolveURI(ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        try {
            URI uRI = ResolverLocalFilesystem.getNewURI(resourceResolverContext.uriToResolve, resourceResolverContext.baseUri);
            String string = ResolverLocalFilesystem.translateUriToFilename(uRI.toString());
            FileInputStream fileInputStream = new FileInputStream(string);
            XMLSignatureInput xMLSignatureInput = new XMLSignatureInput(fileInputStream);
            xMLSignatureInput.setSourceURI(uRI.toString());
            return xMLSignatureInput;
        }
        catch (Exception exception) {
            throw new ResourceResolverException("generic.EmptyMessage", exception, resourceResolverContext.attr, resourceResolverContext.baseUri);
        }
    }

    private static String translateUriToFilename(String string) {
        String string2 = string.substring(FILE_URI_LENGTH);
        if (string2.indexOf("%20") > -1) {
            int n = 0;
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder(string2.length());
            do {
                if ((n2 = string2.indexOf("%20", n)) == -1) {
                    stringBuilder.append(string2.substring(n));
                    continue;
                }
                stringBuilder.append(string2.substring(n, n2));
                stringBuilder.append(' ');
                n = n2 + 3;
            } while (n2 != -1);
            string2 = stringBuilder.toString();
        }
        if (string2.charAt(1) == ':') {
            return string2;
        }
        return "/" + string2;
    }

    public boolean engineCanResolveURI(ResourceResolverContext resourceResolverContext) {
        block8: {
            if (resourceResolverContext.uriToResolve == null) {
                return false;
            }
            if (resourceResolverContext.uriToResolve.equals("") || resourceResolverContext.uriToResolve.charAt(0) == '#' || resourceResolverContext.uriToResolve.startsWith("http:")) {
                return false;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("I was asked whether I can resolve " + resourceResolverContext.uriToResolve);
                }
                if (resourceResolverContext.uriToResolve.startsWith("file:") || resourceResolverContext.baseUri.startsWith("file:")) {
                    if (log.isDebugEnabled()) {
                        log.debug("I state that I can resolve " + resourceResolverContext.uriToResolve);
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block8;
                log.debug(exception);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("But I can't");
        }
        return false;
    }

    private static URI getNewURI(String string, String string2) throws URISyntaxException {
        URI uRI = null;
        uRI = string2 == null || "".equals(string2) ? new URI(string) : new URI(string2).resolve(string);
        if (uRI.getFragment() != null) {
            URI uRI2 = new URI(uRI.getScheme(), uRI.getSchemeSpecificPart(), null);
            return uRI2;
        }
        return uRI;
    }
}

