/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResolverFragment
extends ResourceResolverSpi {
    private static Log log = LogFactory.getLog(ResolverFragment.class);

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolveURI(ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        Object object;
        Document document = resourceResolverContext.attr.getOwnerElement().getOwnerDocument();
        Node node = null;
        if (resourceResolverContext.uriToResolve.equals("")) {
            if (log.isDebugEnabled()) {
                log.debug("ResolverFragment with empty URI (means complete document)");
            }
            node = document;
        } else {
            Element element;
            object = resourceResolverContext.uriToResolve.substring(1);
            node = document.getElementById((String)object);
            if (node == null) {
                Object[] objectArray = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MissingID", objectArray, resourceResolverContext.attr, resourceResolverContext.baseUri);
            }
            if (resourceResolverContext.secureValidation && !XMLUtils.protectAgainstWrappingAttack(element = resourceResolverContext.attr.getOwnerDocument().getDocumentElement(), (String)object)) {
                Object[] objectArray = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MultipleIDs", objectArray, resourceResolverContext.attr, resourceResolverContext.baseUri);
            }
            if (log.isDebugEnabled()) {
                log.debug("Try to catch an Element with ID " + (String)object + " and Element was " + node);
            }
        }
        object = new XMLSignatureInput(node);
        ((XMLSignatureInput)object).setExcludeComments(true);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        if (resourceResolverContext.baseUri != null && resourceResolverContext.baseUri.length() > 0) {
            ((XMLSignatureInput)object).setSourceURI(resourceResolverContext.baseUri.concat(resourceResolverContext.uriToResolve));
        } else {
            ((XMLSignatureInput)object).setSourceURI(resourceResolverContext.uriToResolve);
        }
        return object;
    }

    public boolean engineCanResolveURI(ResourceResolverContext resourceResolverContext) {
        if (resourceResolverContext.uriToResolve == null) {
            if (log.isDebugEnabled()) {
                log.debug("Quick fail for null uri");
            }
            return false;
        }
        if (resourceResolverContext.uriToResolve.equals("") || resourceResolverContext.uriToResolve.charAt(0) == '#' && !resourceResolverContext.uriToResolve.startsWith("#xpointer(")) {
            if (log.isDebugEnabled()) {
                log.debug("State I can resolve reference: \"" + resourceResolverContext.uriToResolve + "\"");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Do not seem to be able to resolve reference: \"" + resourceResolverContext.uriToResolve + "\"");
        }
        return false;
    }
}

