/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;

public class ResolverDirectHTTP
extends ResourceResolverSpi {
    private static Log log = LogFactory.getLog(ResolverDirectHTTP.class);
    private static final String[] properties = new String[]{"http.proxy.host", "http.proxy.port", "http.proxy.username", "http.proxy.password", "http.basic.username", "http.basic.password"};
    private static final int HttpProxyHost = 0;
    private static final int HttpProxyPort = 1;
    private static final int HttpProxyUser = 2;
    private static final int HttpProxyPass = 3;
    private static final int HttpBasicUser = 4;
    private static final int HttpBasicPass = 5;

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolveURI(ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        try {
            Object object;
            Object object2;
            Object object3;
            String string;
            URI uRI = ResolverDirectHTTP.getNewURI(resourceResolverContext.uriToResolve, resourceResolverContext.baseUri);
            URL uRL = uRI.toURL();
            URLConnection uRLConnection = this.openConnection(uRL);
            String string2 = uRLConnection.getHeaderField("WWW-Authenticate");
            if (string2 != null && string2.startsWith("Basic")) {
                string = this.engineGetProperty(properties[4]);
                object3 = this.engineGetProperty(properties[5]);
                if (string != null && object3 != null) {
                    uRLConnection = this.openConnection(uRL);
                    object2 = string + ":" + (String)object3;
                    object = Base64.encode(((String)object2).getBytes("ISO-8859-1"));
                    uRLConnection.setRequestProperty("Authorization", "Basic " + (String)object);
                }
            }
            string = uRLConnection.getHeaderField("Content-Type");
            object3 = uRLConnection.getInputStream();
            object2 = new ByteArrayOutputStream();
            object = new byte[4096];
            int n = 0;
            int n2 = 0;
            while ((n = ((InputStream)object3).read((byte[])object)) >= 0) {
                ((ByteArrayOutputStream)object2).write((byte[])object, 0, n);
                n2 += n;
            }
            if (log.isDebugEnabled()) {
                log.debug("Fetched " + n2 + " bytes from URI " + uRI.toString());
            }
            XMLSignatureInput xMLSignatureInput = new XMLSignatureInput(((ByteArrayOutputStream)object2).toByteArray());
            xMLSignatureInput.setSourceURI(uRI.toString());
            xMLSignatureInput.setMIMEType(string);
            return xMLSignatureInput;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ResourceResolverException("generic.EmptyMessage", uRISyntaxException, resourceResolverContext.attr, resourceResolverContext.baseUri);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ResourceResolverException("generic.EmptyMessage", malformedURLException, resourceResolverContext.attr, resourceResolverContext.baseUri);
        }
        catch (IOException iOException) {
            throw new ResourceResolverException("generic.EmptyMessage", iOException, resourceResolverContext.attr, resourceResolverContext.baseUri);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ResourceResolverException("generic.EmptyMessage", illegalArgumentException, resourceResolverContext.attr, resourceResolverContext.baseUri);
        }
    }

    private URLConnection openConnection(URL uRL) throws IOException {
        URLConnection uRLConnection;
        String string = this.engineGetProperty(properties[0]);
        String string2 = this.engineGetProperty(properties[1]);
        String string3 = this.engineGetProperty(properties[2]);
        String string4 = this.engineGetProperty(properties[3]);
        Proxy proxy = null;
        if (string != null && string2 != null) {
            int n = Integer.parseInt(string2);
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
        }
        if (proxy != null) {
            uRLConnection = uRL.openConnection(proxy);
            if (string3 != null && string4 != null) {
                String string5 = string3 + ":" + string4;
                String string6 = "Basic " + Base64.encode(string5.getBytes("ISO-8859-1"));
                uRLConnection.setRequestProperty("Proxy-Authorization", string6);
            }
        } else {
            uRLConnection = uRL.openConnection();
        }
        return uRLConnection;
    }

    public boolean engineCanResolveURI(ResourceResolverContext resourceResolverContext) {
        if (resourceResolverContext.uriToResolve == null) {
            if (log.isDebugEnabled()) {
                log.debug("quick fail, uri == null");
            }
            return false;
        }
        if (resourceResolverContext.uriToResolve.equals("") || resourceResolverContext.uriToResolve.charAt(0) == '#') {
            if (log.isDebugEnabled()) {
                log.debug("quick fail for empty URIs and local ones");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("I was asked whether I can resolve " + resourceResolverContext.uriToResolve);
        }
        if (resourceResolverContext.uriToResolve.startsWith("http:") || resourceResolverContext.baseUri != null && resourceResolverContext.baseUri.startsWith("http:")) {
            if (log.isDebugEnabled()) {
                log.debug("I state that I can resolve " + resourceResolverContext.uriToResolve);
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("I state that I can't resolve " + resourceResolverContext.uriToResolve);
        }
        return false;
    }

    public String[] engineGetPropertyKeys() {
        return (String[])properties.clone();
    }

    private static URI getNewURI(String string, String string2) throws URISyntaxException {
        URI uRI = null;
        uRI = string2 == null || "".equals(string2) ? new URI(string) : new URI(string2).resolve(string);
        if (uRI.getFragment() != null) {
            URI uRI2 = new URI(uRI.getScheme(), uRI.getSchemeSpecificPart(), null);
            return uRI2;
        }
        return uRI;
    }
}

