/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.w3c.dom.Attr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceResolverSpi {
    private static Log log = LogFactory.getLog(ResourceResolverSpi.class);
    protected Map<String, String> properties = null;
    protected final boolean secureValidation = true;

    public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
        throw new UnsupportedOperationException();
    }

    public XMLSignatureInput engineResolveURI(ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        return this.engineResolve(resourceResolverContext.attr, resourceResolverContext.baseUri);
    }

    public void engineSetProperty(String string, String string2) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(string, string2);
    }

    public String engineGetProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public void engineAddProperies(Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            this.properties.putAll(map);
        }
    }

    public boolean engineIsThreadSafe() {
        return false;
    }

    public boolean engineCanResolve(Attr attr, String string) {
        throw new UnsupportedOperationException();
    }

    public boolean engineCanResolveURI(ResourceResolverContext resourceResolverContext) {
        return this.engineCanResolve(resourceResolverContext.attr, resourceResolverContext.baseUri);
    }

    public String[] engineGetPropertyKeys() {
        return new String[0];
    }

    public boolean understandsProperty(String string) {
        String[] stringArray = this.engineGetPropertyKeys();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static String fixURI(String string) {
        char c;
        char c2;
        if ((string = string.replace(File.separatorChar, '/')).length() >= 4) {
            boolean bl;
            c2 = Character.toUpperCase(string.charAt(0));
            c = string.charAt(1);
            char c3 = string.charAt(2);
            char c4 = string.charAt(3);
            boolean bl2 = bl = 'A' <= c2 && c2 <= 'Z' && c == ':' && c3 == '/' && c4 != '/';
            if (bl && log.isDebugEnabled()) {
                log.debug("Found DOS filename: " + string);
            }
        }
        if (string.length() >= 2 && (c2 = string.charAt(1)) == ':' && 'A' <= (c = Character.toUpperCase(string.charAt(0))) && c <= 'Z') {
            string = "/" + string;
        }
        return string;
    }
}

