/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverDirectHTTP;
import org.apache.xml.security.utils.resolver.implementations.ResolverFragment;
import org.apache.xml.security.utils.resolver.implementations.ResolverLocalFilesystem;
import org.apache.xml.security.utils.resolver.implementations.ResolverXPointer;
import org.w3c.dom.Attr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceResolver {
    private static Log log = LogFactory.getLog(ResourceResolver.class);
    private static List<ResourceResolver> resolverList = new ArrayList<ResourceResolver>();
    private final ResourceResolverSpi resolverSpi;

    public ResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        this.resolverSpi = resourceResolverSpi;
    }

    public static final ResourceResolver getInstance(Attr attr, String string) throws ResourceResolverException {
        return ResourceResolver.getInstance(attr, string, false);
    }

    public static final ResourceResolver getInstance(Attr attr, String string, boolean bl) throws ResourceResolverException {
        ResourceResolverContext resourceResolverContext = new ResourceResolverContext(attr, string, bl);
        return ResourceResolver.internalGetInstance(resourceResolverContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <N> ResourceResolver internalGetInstance(ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        Object[] objectArray = resolverList;
        synchronized (resolverList) {
            Iterator<ResourceResolver> iterator = resolverList.iterator();
            while (iterator.hasNext()) {
                ResourceResolver resourceResolver;
                ResourceResolver resourceResolver2 = resourceResolver = iterator.next();
                if (!resourceResolver.resolverSpi.engineIsThreadSafe()) {
                    try {
                        resourceResolver2 = new ResourceResolver((ResourceResolverSpi)resourceResolver.resolverSpi.getClass().newInstance());
                    }
                    catch (InstantiationException instantiationException) {
                        throw new ResourceResolverException("", instantiationException, resourceResolverContext.attr, resourceResolverContext.baseUri);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new ResourceResolverException("", illegalAccessException, resourceResolverContext.attr, resourceResolverContext.baseUri);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("check resolvability by class " + resourceResolver2.getClass().getName());
                }
                if (resourceResolver2 == null || !resourceResolver2.canResolve(resourceResolverContext)) continue;
                if (resourceResolverContext.secureValidation && (resourceResolver2.resolverSpi instanceof ResolverLocalFilesystem || resourceResolver2.resolverSpi instanceof ResolverDirectHTTP)) {
                    Object[] objectArray2 = new Object[]{resourceResolver2.resolverSpi.getClass().getName()};
                    throw new ResourceResolverException("signature.Reference.ForbiddenResolver", objectArray2, resourceResolverContext.attr, resourceResolverContext.baseUri);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return resourceResolver2;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            objectArray = new Object[]{resourceResolverContext.uriToResolve != null ? resourceResolverContext.uriToResolve : "null", resourceResolverContext.baseUri};
            throw new ResourceResolverException("utils.resolver.noClass", objectArray, resourceResolverContext.attr, resourceResolverContext.baseUri);
        }
    }

    public static ResourceResolver getInstance(Attr attr, String string, List<ResourceResolver> list) throws ResourceResolverException {
        return ResourceResolver.getInstance(attr, string, list, false);
    }

    public static ResourceResolver getInstance(Attr attr, String string, List<ResourceResolver> list, boolean bl) throws ResourceResolverException {
        if (log.isDebugEnabled()) {
            log.debug("I was asked to create a ResourceResolver and got " + (list == null ? 0 : list.size()));
        }
        ResourceResolverContext resourceResolverContext = new ResourceResolverContext(attr, string, bl);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ResourceResolver resourceResolver = list.get(i);
                if (resourceResolver == null) continue;
                if (log.isDebugEnabled()) {
                    String string2 = resourceResolver.resolverSpi.getClass().getName();
                    log.debug("check resolvability by class " + string2);
                }
                if (!resourceResolver.canResolve(resourceResolverContext)) continue;
                return resourceResolver;
            }
        }
        return ResourceResolver.internalGetInstance(resourceResolverContext);
    }

    public static void register(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            ResourceResolver.register(clazz, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.warn("Error loading resolver " + string + " disabling it");
        }
    }

    public static void registerAtStart(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            ResourceResolver.register(clazz, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.warn("Error loading resolver " + string + " disabling it");
        }
    }

    public static void register(Class<? extends ResourceResolverSpi> clazz, boolean bl) {
        try {
            ResourceResolverSpi resourceResolverSpi = clazz.newInstance();
            ResourceResolver.register(resourceResolverSpi, bl);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn("Error loading resolver " + clazz + " disabling it");
        }
        catch (InstantiationException instantiationException) {
            log.warn("Error loading resolver " + clazz + " disabling it");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ResourceResolverSpi resourceResolverSpi, boolean bl) {
        List<ResourceResolver> list = resolverList;
        synchronized (list) {
            if (bl) {
                resolverList.add(0, new ResourceResolver(resourceResolverSpi));
            } else {
                resolverList.add(new ResourceResolver(resourceResolverSpi));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Registered resolver: " + resourceResolverSpi.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDefaultResolvers() {
        List<ResourceResolver> list = resolverList;
        synchronized (list) {
            resolverList.add(new ResourceResolver(new ResolverFragment()));
            resolverList.add(new ResourceResolver(new ResolverLocalFilesystem()));
            resolverList.add(new ResourceResolver(new ResolverXPointer()));
            resolverList.add(new ResourceResolver(new ResolverDirectHTTP()));
        }
    }

    public XMLSignatureInput resolve(Attr attr, String string) throws ResourceResolverException {
        return this.resolve(attr, string, true);
    }

    public XMLSignatureInput resolve(Attr attr, String string, boolean bl) throws ResourceResolverException {
        ResourceResolverContext resourceResolverContext = new ResourceResolverContext(attr, string, bl);
        return this.resolverSpi.engineResolveURI(resourceResolverContext);
    }

    public void setProperty(String string, String string2) {
        this.resolverSpi.engineSetProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.resolverSpi.engineGetProperty(string);
    }

    public void addProperties(Map<String, String> map) {
        this.resolverSpi.engineAddProperies(map);
    }

    public String[] getPropertyKeys() {
        return this.resolverSpi.engineGetPropertyKeys();
    }

    public boolean understandsProperty(String string) {
        return this.resolverSpi.understandsProperty(string);
    }

    private boolean canResolve(ResourceResolverContext resourceResolverContext) {
        return this.resolverSpi.engineCanResolveURI(resourceResolverContext);
    }
}

