/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.transforms.implementations.FuncHere;
import org.apache.xml.security.utils.XPathAPI;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XalanXPathAPI
implements XPathAPI {
    private static Log log = LogFactory.getLog(XalanXPathAPI.class);
    private String xpathStr = null;
    private XPath xpath = null;
    private static FunctionTable funcTable = null;
    private static boolean installed;
    private XPathContext context;

    public NodeList selectNodeList(Node node, Node node2, String string, Node node3) throws TransformerException {
        XObject xObject = this.eval(node, node2, string, node3);
        return xObject.nodelist();
    }

    public boolean evaluate(Node node, Node node2, String string, Node node3) throws TransformerException {
        XObject xObject = this.eval(node, node2, string, node3);
        return xObject.bool();
    }

    public void clear() {
        this.xpathStr = null;
        this.xpath = null;
        this.context = null;
    }

    public static synchronized boolean isInstalled() {
        return installed;
    }

    private XObject eval(Node node, Node node2, String string, Node node3) throws TransformerException {
        if (this.context == null) {
            this.context = new XPathContext((Object)node2);
            this.context.setSecureProcessing(true);
        }
        Node node4 = node3.getNodeType() == 9 ? ((Document)node3).getDocumentElement() : node3;
        PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault(node4);
        if (!string.equals(this.xpathStr)) {
            if (string.indexOf("here()") > 0) {
                this.context.reset();
            }
            this.xpath = this.createXPath(string, (PrefixResolver)prefixResolverDefault);
            this.xpathStr = string;
        }
        int n = this.context.getDTMHandleFromNode(node);
        return this.xpath.execute(this.context, n, (PrefixResolver)prefixResolverDefault);
    }

    private XPath createXPath(String string, PrefixResolver prefixResolver) throws TransformerException {
        XPath xPath;
        block3: {
            xPath = null;
            Class[] classArray = new Class[]{String.class, SourceLocator.class, PrefixResolver.class, Integer.TYPE, ErrorListener.class, FunctionTable.class};
            Object[] objectArray = new Object[]{string, null, prefixResolver, 0, null, funcTable};
            try {
                Constructor constructor = XPath.class.getConstructor(classArray);
                xPath = (XPath)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block3;
                log.debug(exception);
            }
        }
        if (xPath == null) {
            xPath = new XPath(string, null, prefixResolver, 0, null);
        }
        return xPath;
    }

    private static synchronized void fixupFunctionTable() {
        Object[] objectArray;
        Method method;
        Class[] classArray;
        installed = false;
        if (log.isDebugEnabled()) {
            log.debug("Registering Here function");
        }
        try {
            classArray = new Class[]{String.class, Expression.class};
            method = FunctionTable.class.getMethod("installFunction", classArray);
            if ((method.getModifiers() & 8) != 0) {
                objectArray = new Object[]{"here", new FuncHere()};
                method.invoke(null, objectArray);
                installed = true;
            }
        }
        catch (Exception exception) {
            log.debug("Error installing function using the static installFunction method", exception);
        }
        if (!installed) {
            try {
                funcTable = new FunctionTable();
                classArray = new Class[]{String.class, Class.class};
                method = FunctionTable.class.getMethod("installFunction", classArray);
                objectArray = new Object[]{"here", FuncHere.class};
                method.invoke((Object)funcTable, objectArray);
                installed = true;
            }
            catch (Exception exception) {
                log.debug("Error installing function using the static installFunction method", exception);
            }
        }
        if (log.isDebugEnabled()) {
            if (installed) {
                log.debug("Registered class " + FuncHere.class.getName() + " for XPath function 'here()' function in internal table");
            } else {
                log.debug("Unable to register class " + FuncHere.class.getName() + " for XPath function 'here()' function in internal table");
            }
        }
    }

    static {
        XalanXPathAPI.fixupFunctionTable();
    }
}

