/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.signature.XMLSignatureException;

public class SignerOutputStream
extends ByteArrayOutputStream {
    private static Log log = LogFactory.getLog(SignerOutputStream.class);
    final SignatureAlgorithm sa;

    public SignerOutputStream(SignatureAlgorithm signatureAlgorithm) {
        this.sa = signatureAlgorithm;
    }

    public void write(byte[] byArray) {
        try {
            this.sa.update(byArray);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }

    public void write(int n) {
        try {
            this.sa.update((byte)n);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        if (log.isDebugEnabled()) {
            log.debug("Canonicalized SignedInfo:");
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i = n; i < n + n2; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
            log.debug(stringBuilder.toString());
        }
        try {
            this.sa.update(byArray, n, n2);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }
}

