/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;

public class DigesterOutputStream
extends ByteArrayOutputStream {
    private static final Log log = LogFactory.getLog(DigesterOutputStream.class);
    final MessageDigestAlgorithm mda;

    public DigesterOutputStream(MessageDigestAlgorithm messageDigestAlgorithm) {
        this.mda = messageDigestAlgorithm;
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n) {
        this.mda.update((byte)n);
    }

    public void write(byte[] byArray, int n, int n2) {
        if (log.isDebugEnabled()) {
            log.debug("Pre-digested input:");
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i = n; i < n + n2; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
            log.debug(stringBuilder.toString());
        }
        this.mda.update(byArray, n, n2);
    }

    public byte[] getDigestValue() {
        return this.mda.digest();
    }
}

