/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassLoaderUtils {
    private static final Log log = LogFactory.getLog(ClassLoaderUtils.class);

    private ClassLoaderUtils() {
    }

    public static URL getResource(String string, Class<?> clazz) {
        ClassLoader classLoader;
        ClassLoader classLoader2;
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL == null && string.startsWith("/")) {
            uRL = Thread.currentThread().getContextClassLoader().getResource(string.substring(1));
        }
        if ((classLoader2 = ClassLoaderUtils.class.getClassLoader()) == null) {
            classLoader2 = ClassLoader.getSystemClassLoader();
        }
        if (uRL == null) {
            uRL = classLoader2.getResource(string);
        }
        if (uRL == null && string.startsWith("/")) {
            uRL = classLoader2.getResource(string.substring(1));
        }
        if (uRL == null && (classLoader = clazz.getClassLoader()) != null) {
            uRL = classLoader.getResource(string);
        }
        if (uRL == null) {
            uRL = clazz.getResource(string);
        }
        if (uRL == null && string != null && string.charAt(0) != '/') {
            return ClassLoaderUtils.getResource('/' + string, clazz);
        }
        return uRL;
    }

    public static List<URL> getResources(String string, Class<?> clazz) {
        Object object;
        Enumeration<URL> enumeration;
        ArrayList<URL> arrayList;
        block22: {
            block21: {
                ClassLoader classLoader;
                block20: {
                    block19: {
                        block18: {
                            arrayList = new ArrayList<URL>();
                            enumeration = new Enumeration<URL>(){

                                @Override
                                public boolean hasMoreElements() {
                                    return false;
                                }

                                @Override
                                public URL nextElement() {
                                    return null;
                                }
                            };
                            try {
                                enumeration = Thread.currentThread().getContextClassLoader().getResources(string);
                            }
                            catch (IOException iOException) {
                                if (!log.isDebugEnabled()) break block18;
                                log.debug(iOException);
                            }
                        }
                        if (!enumeration.hasMoreElements() && string.startsWith("/")) {
                            try {
                                enumeration = Thread.currentThread().getContextClassLoader().getResources(string.substring(1));
                            }
                            catch (IOException iOException) {
                                if (!log.isDebugEnabled()) break block19;
                                log.debug(iOException);
                            }
                        }
                    }
                    if ((classLoader = ClassLoaderUtils.class.getClassLoader()) == null) {
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                    if (!enumeration.hasMoreElements()) {
                        try {
                            enumeration = classLoader.getResources(string);
                        }
                        catch (IOException iOException) {
                            if (!log.isDebugEnabled()) break block20;
                            log.debug(iOException);
                        }
                    }
                }
                if (!enumeration.hasMoreElements() && string.startsWith("/")) {
                    try {
                        enumeration = classLoader.getResources(string.substring(1));
                    }
                    catch (IOException iOException) {
                        if (!log.isDebugEnabled()) break block21;
                        log.debug(iOException);
                    }
                }
            }
            if (!enumeration.hasMoreElements() && (object = clazz.getClassLoader()) != null) {
                try {
                    enumeration = ((ClassLoader)object).getResources(string);
                }
                catch (IOException iOException) {
                    if (!log.isDebugEnabled()) break block22;
                    log.debug(iOException);
                }
            }
        }
        if (!enumeration.hasMoreElements() && (object = clazz.getResource(string)) != null) {
            arrayList.add((URL)object);
        }
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        if (arrayList.isEmpty() && string != null && string.charAt(0) != '/') {
            return ClassLoaderUtils.getResources('/' + string, clazz);
        }
        return arrayList;
    }

    public static InputStream getResourceAsStream(String string, Class<?> clazz) {
        URL uRL = ClassLoaderUtils.getResource(string, clazz);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            if (log.isDebugEnabled()) {
                log.debug(iOException);
            }
            return null;
        }
    }

    public static Class<?> loadClass(String string, Class<?> clazz) throws ClassNotFoundException {
        block3: {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    return classLoader.loadClass(string);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!log.isDebugEnabled()) break block3;
                log.debug(classNotFoundException);
            }
        }
        return ClassLoaderUtils.loadClass2(string, clazz);
    }

    private static Class<?> loadClass2(String string, Class<?> clazz) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            block6: {
                try {
                    if (ClassLoaderUtils.class.getClassLoader() != null) {
                        return ClassLoaderUtils.class.getClassLoader().loadClass(string);
                    }
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    if (clazz == null || clazz.getClassLoader() == null) break block6;
                    return clazz.getClassLoader().loadClass(string);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug(classNotFoundException);
            }
            throw classNotFoundException;
        }
    }
}

