/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XPath2NodeFilter
implements NodeFilter {
    boolean hasUnionFilter;
    boolean hasSubtractFilter;
    boolean hasIntersectFilter;
    Set<Node> unionNodes;
    Set<Node> subtractNodes;
    Set<Node> intersectNodes;
    int inSubtract = -1;
    int inIntersect = -1;
    int inUnion = -1;

    XPath2NodeFilter(List<NodeList> list, List<NodeList> list2, List<NodeList> list3) {
        this.hasUnionFilter = !list.isEmpty();
        this.unionNodes = XPath2NodeFilter.convertNodeListToSet(list);
        this.hasSubtractFilter = !list2.isEmpty();
        this.subtractNodes = XPath2NodeFilter.convertNodeListToSet(list2);
        this.hasIntersectFilter = !list3.isEmpty();
        this.intersectNodes = XPath2NodeFilter.convertNodeListToSet(list3);
    }

    @Override
    public int isNodeInclude(Node node) {
        int n = 1;
        if (this.hasSubtractFilter && XPath2NodeFilter.rooted(node, this.subtractNodes)) {
            n = -1;
        } else if (this.hasIntersectFilter && !XPath2NodeFilter.rooted(node, this.intersectNodes)) {
            n = 0;
        }
        if (n == 1) {
            return 1;
        }
        if (this.hasUnionFilter) {
            if (XPath2NodeFilter.rooted(node, this.unionNodes)) {
                return 1;
            }
            n = 0;
        }
        return n;
    }

    @Override
    public int isNodeIncludeDO(Node node, int n) {
        int n2 = 1;
        if (this.hasSubtractFilter) {
            if (this.inSubtract == -1 || n <= this.inSubtract) {
                this.inSubtract = XPath2NodeFilter.inList(node, this.subtractNodes) ? n : -1;
            }
            if (this.inSubtract != -1) {
                n2 = -1;
            }
        }
        if (n2 != -1 && this.hasIntersectFilter && (this.inIntersect == -1 || n <= this.inIntersect)) {
            if (!XPath2NodeFilter.inList(node, this.intersectNodes)) {
                this.inIntersect = -1;
                n2 = 0;
            } else {
                this.inIntersect = n;
            }
        }
        if (n <= this.inUnion) {
            this.inUnion = -1;
        }
        if (n2 == 1) {
            return 1;
        }
        if (this.hasUnionFilter) {
            if (this.inUnion == -1 && XPath2NodeFilter.inList(node, this.unionNodes)) {
                this.inUnion = n;
            }
            if (this.inUnion != -1) {
                return 1;
            }
            n2 = 0;
        }
        return n2;
    }

    static boolean rooted(Node node, Set<Node> set) {
        if (set.isEmpty()) {
            return false;
        }
        if (set.contains(node)) {
            return true;
        }
        for (Node node2 : set) {
            if (!XMLUtils.isDescendantOrSelf(node2, node)) continue;
            return true;
        }
        return false;
    }

    static boolean inList(Node node, Set<Node> set) {
        return set.contains(node);
    }

    private static Set<Node> convertNodeListToSet(List<NodeList> list) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (NodeList nodeList : list) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                hashSet.add(node);
            }
        }
        return hashSet;
    }
}

