/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.SignatureProperties;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.SignerOutputStream;
import org.apache.xml.security.utils.UnsyncBufferedOutputStream;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class XMLSignature
extends SignatureElementProxy {
    public static final String ALGO_ID_MAC_HMAC_SHA1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String ALGO_ID_SIGNATURE_DSA = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_NOT_RECOMMENDED_RSA_MD5 = "http://www.w3.org/2001/04/xmldsig-more#rsa-md5";
    public static final String ALGO_ID_SIGNATURE_RSA_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    public static final String ALGO_ID_MAC_HMAC_NOT_RECOMMENDED_MD5 = "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
    public static final String ALGO_ID_MAC_HMAC_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
    public static final String ALGO_ID_MAC_HMAC_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
    public static final String ALGO_ID_MAC_HMAC_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
    public static final String ALGO_ID_MAC_HMAC_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
    public static final String ALGO_ID_SIGNATURE_ECDSA_SHA1 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
    public static final String ALGO_ID_SIGNATURE_ECDSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
    public static final String ALGO_ID_SIGNATURE_ECDSA_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384";
    public static final String ALGO_ID_SIGNATURE_ECDSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512";
    private static Log log = LogFactory.getLog(XMLSignature.class);
    private SignedInfo signedInfo;
    private KeyInfo keyInfo;
    private boolean followManifestsDuringValidation = false;
    private Element signatureValueElement;
    private static final int MODE_SIGN = 0;
    private static final int MODE_VERIFY = 1;
    private int state = 0;

    public XMLSignature(Document document, String string, String string2) throws XMLSecurityException {
        this(document, string, string2, 0, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public XMLSignature(Document document, String string, String string2, int n) throws XMLSecurityException {
        this(document, string, string2, n, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public XMLSignature(Document document, String string, String string2, String string3) throws XMLSecurityException {
        this(document, string, string2, 0, string3);
    }

    public XMLSignature(Document document, String string, String string2, int n, String string3) throws XMLSecurityException {
        super(document);
        String string4 = XMLSignature.getDefaultPrefix("http://www.w3.org/2000/09/xmldsig#");
        if (string4 == null || string4.length() == 0) {
            this.constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this.constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string4, "http://www.w3.org/2000/09/xmldsig#");
        }
        XMLUtils.addReturnToElement(this.constructionElement);
        this.baseURI = string;
        this.signedInfo = new SignedInfo(this.doc, string2, n, string3);
        this.constructionElement.appendChild(this.signedInfo.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
        this.signatureValueElement = XMLUtils.createElementInSignatureSpace(this.doc, "SignatureValue");
        this.constructionElement.appendChild(this.signatureValueElement);
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public XMLSignature(Document document, String string, Element element, Element element2) throws XMLSecurityException {
        super(document);
        String string2 = XMLSignature.getDefaultPrefix("http://www.w3.org/2000/09/xmldsig#");
        if (string2 == null || string2.length() == 0) {
            this.constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this.constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2000/09/xmldsig#");
        }
        XMLUtils.addReturnToElement(this.constructionElement);
        this.baseURI = string;
        this.signedInfo = new SignedInfo(this.doc, element, element2);
        this.constructionElement.appendChild(this.signedInfo.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
        this.signatureValueElement = XMLUtils.createElementInSignatureSpace(this.doc, "SignatureValue");
        this.constructionElement.appendChild(this.signatureValueElement);
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public XMLSignature(Element element, String string) throws XMLSignatureException, XMLSecurityException {
        this(element, string, false);
    }

    public XMLSignature(Element element, String string, boolean bl) throws XMLSignatureException, XMLSecurityException {
        super(element, string);
        Element element2;
        Element element3 = XMLUtils.getNextElement(element.getFirstChild());
        if (element3 == null) {
            Object[] objectArray = new Object[]{"SignedInfo", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", objectArray);
        }
        this.signedInfo = new SignedInfo(element3, string, bl);
        element3 = XMLUtils.getNextElement(element.getFirstChild());
        this.signatureValueElement = XMLUtils.getNextElement(element3.getNextSibling());
        if (this.signatureValueElement == null) {
            Object[] objectArray = new Object[]{"SignatureValue", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", objectArray);
        }
        Attr attr = this.signatureValueElement.getAttributeNodeNS(null, "Id");
        if (attr != null) {
            this.signatureValueElement.setIdAttributeNode(attr, true);
        }
        if ((element2 = XMLUtils.getNextElement(this.signatureValueElement.getNextSibling())) != null && element2.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && element2.getLocalName().equals("KeyInfo")) {
            this.keyInfo = new KeyInfo(element2, string);
            this.keyInfo.setSecureValidation(bl);
        }
        Element element4 = XMLUtils.getNextElement(this.signatureValueElement.getNextSibling());
        while (element4 != null) {
            Attr attr2 = element4.getAttributeNodeNS(null, "Id");
            if (attr2 != null) {
                element4.setIdAttributeNode(attr2, true);
            }
            NodeList nodeList = element4.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element5 = (Element)node;
                String string2 = element5.getLocalName();
                if (string2.equals("Manifest")) {
                    new Manifest(element5, string);
                    continue;
                }
                if (!string2.equals("SignatureProperties")) continue;
                new SignatureProperties(element5, string);
            }
            element4 = XMLUtils.getNextElement(element4.getNextSibling());
        }
        this.state = 1;
    }

    public void setId(String string) {
        if (string != null) {
            this.constructionElement.setAttributeNS(null, "Id", string);
            this.constructionElement.setIdAttributeNS(null, "Id", true);
        }
    }

    public String getId() {
        return this.constructionElement.getAttributeNS(null, "Id");
    }

    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }

    public byte[] getSignatureValue() throws XMLSignatureException {
        try {
            return Base64.decode(this.signatureValueElement);
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new XMLSignatureException("empty", base64DecodingException);
        }
    }

    private void setSignatureValueElement(byte[] byArray) {
        while (this.signatureValueElement.hasChildNodes()) {
            this.signatureValueElement.removeChild(this.signatureValueElement.getFirstChild());
        }
        String string = Base64.encode(byArray);
        if (string.length() > 76 && !XMLUtils.ignoreLineBreaks()) {
            string = "\n" + string + "\n";
        }
        Text text = this.doc.createTextNode(string);
        this.signatureValueElement.appendChild(text);
    }

    public KeyInfo getKeyInfo() {
        if (this.state == 0 && this.keyInfo == null) {
            this.keyInfo = new KeyInfo(this.doc);
            Element element = this.keyInfo.getElement();
            Element element2 = XMLUtils.selectDsNode(this.constructionElement.getFirstChild(), "Object", 0);
            if (element2 != null) {
                this.constructionElement.insertBefore(element, element2);
                XMLUtils.addReturnBeforeChild(this.constructionElement, element2);
            } else {
                this.constructionElement.appendChild(element);
                XMLUtils.addReturnToElement(this.constructionElement);
            }
        }
        return this.keyInfo;
    }

    public void appendObject(ObjectContainer objectContainer) throws XMLSignatureException {
        this.constructionElement.appendChild(objectContainer.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public ObjectContainer getObjectItem(int n) {
        Element element = XMLUtils.selectDsNode(this.constructionElement.getFirstChild(), "Object", n);
        try {
            return new ObjectContainer(element, this.baseURI);
        }
        catch (XMLSecurityException xMLSecurityException) {
            return null;
        }
    }

    public int getObjectLength() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "Object");
    }

    public void sign(Key key) throws XMLSignatureException {
        if (key instanceof PublicKey) {
            throw new IllegalArgumentException(I18n.translate("algorithms.operationOnlyVerification"));
        }
        try {
            SignedInfo signedInfo = this.getSignedInfo();
            SignatureAlgorithm signatureAlgorithm = signedInfo.getSignatureAlgorithm();
            OutputStream outputStream = null;
            try {
                signatureAlgorithm.initSign(key);
                signedInfo.generateDigestValues();
                outputStream = new UnsyncBufferedOutputStream(new SignerOutputStream(signatureAlgorithm));
                signedInfo.signInOctetStream(outputStream);
            }
            catch (XMLSecurityException xMLSecurityException) {
                throw xMLSecurityException;
            }
            finally {
                block17: {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            if (!log.isDebugEnabled()) break block17;
                            log.debug(iOException);
                        }
                    }
                }
            }
            this.setSignatureValueElement(signatureAlgorithm.sign());
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw xMLSignatureException;
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public void addResourceResolver(ResourceResolver resourceResolver) {
        this.getSignedInfo().addResourceResolver(resourceResolver);
    }

    public void addResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        this.getSignedInfo().addResourceResolver(resourceResolverSpi);
    }

    public boolean checkSignatureValue(X509Certificate x509Certificate) throws XMLSignatureException {
        if (x509Certificate != null) {
            return this.checkSignatureValue(x509Certificate.getPublicKey());
        }
        Object[] objectArray = new Object[]{"Didn't get a certificate"};
        throw new XMLSignatureException("empty", objectArray);
    }

    public boolean checkSignatureValue(Key key) throws XMLSignatureException {
        if (key == null) {
            Object[] objectArray = new Object[]{"Didn't get a key"};
            throw new XMLSignatureException("empty", objectArray);
        }
        try {
            SignedInfo signedInfo = this.getSignedInfo();
            SignatureAlgorithm signatureAlgorithm = signedInfo.getSignatureAlgorithm();
            if (log.isDebugEnabled()) {
                log.debug("signatureMethodURI = " + signatureAlgorithm.getAlgorithmURI());
                log.debug("jceSigAlgorithm    = " + signatureAlgorithm.getJCEAlgorithmString());
                log.debug("jceSigProvider     = " + signatureAlgorithm.getJCEProviderName());
                log.debug("PublicKey = " + key);
            }
            byte[] byArray = null;
            try {
                signatureAlgorithm.initVerify(key);
                SignerOutputStream signerOutputStream = new SignerOutputStream(signatureAlgorithm);
                UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(signerOutputStream);
                signedInfo.signInOctetStream(unsyncBufferedOutputStream);
                ((OutputStream)unsyncBufferedOutputStream).close();
                byArray = this.getSignatureValue();
            }
            catch (IOException iOException) {
                if (log.isDebugEnabled()) {
                    log.debug(iOException);
                }
            }
            catch (XMLSecurityException xMLSecurityException) {
                throw xMLSecurityException;
            }
            if (!signatureAlgorithm.verify(byArray)) {
                log.warn("Signature verification failed.");
                return false;
            }
            return signedInfo.verify(this.followManifestsDuringValidation);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw xMLSignatureException;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public void addDocument(String string, Transforms transforms, String string2, String string3, String string4) throws XMLSignatureException {
        this.signedInfo.addDocument(this.baseURI, string, transforms, string2, string3, string4);
    }

    public void addDocument(String string, Transforms transforms, String string2) throws XMLSignatureException {
        this.signedInfo.addDocument(this.baseURI, string, transforms, string2, null, null);
    }

    public void addDocument(String string, Transforms transforms) throws XMLSignatureException {
        this.signedInfo.addDocument(this.baseURI, string, transforms, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addDocument(String string) throws XMLSignatureException {
        this.signedInfo.addDocument(this.baseURI, string, null, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addKeyInfo(X509Certificate x509Certificate) throws XMLSecurityException {
        X509Data x509Data = new X509Data(this.doc);
        x509Data.addCertificate(x509Certificate);
        this.getKeyInfo().add(x509Data);
    }

    public void addKeyInfo(PublicKey publicKey) {
        this.getKeyInfo().add(publicKey);
    }

    public SecretKey createSecretKey(byte[] byArray) {
        return this.getSignedInfo().createSecretKey(byArray);
    }

    public void setFollowNestedManifests(boolean bl) {
        this.followManifestsDuringValidation = bl;
    }

    public String getBaseLocalName() {
        return "Signature";
    }
}

