/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.MissingResourceFailureException;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SignedInfo
extends Manifest {
    private SignatureAlgorithm signatureAlgorithm = null;
    private byte[] c14nizedBytes = null;
    private Element c14nMethod;
    private Element signatureMethod;

    public SignedInfo(Document document) throws XMLSecurityException {
        this(document, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public SignedInfo(Document document, String string, String string2) throws XMLSecurityException {
        this(document, string, 0, string2);
    }

    public SignedInfo(Document document, String string, int n, String string2) throws XMLSecurityException {
        super(document);
        this.c14nMethod = XMLUtils.createElementInSignatureSpace(this.doc, "CanonicalizationMethod");
        this.c14nMethod.setAttributeNS(null, "Algorithm", string2);
        this.constructionElement.appendChild(this.c14nMethod);
        XMLUtils.addReturnToElement(this.constructionElement);
        this.signatureAlgorithm = n > 0 ? new SignatureAlgorithm(this.doc, string, n) : new SignatureAlgorithm(this.doc, string);
        this.signatureMethod = this.signatureAlgorithm.getElement();
        this.constructionElement.appendChild(this.signatureMethod);
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public SignedInfo(Document document, Element element, Element element2) throws XMLSecurityException {
        super(document);
        this.c14nMethod = element2;
        this.constructionElement.appendChild(this.c14nMethod);
        XMLUtils.addReturnToElement(this.constructionElement);
        this.signatureAlgorithm = new SignatureAlgorithm(element, null);
        this.signatureMethod = this.signatureAlgorithm.getElement();
        this.constructionElement.appendChild(this.signatureMethod);
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public SignedInfo(Element element, String string) throws XMLSecurityException {
        this(element, string, false);
    }

    public SignedInfo(Element element, String string, boolean bl) throws XMLSecurityException {
        super(SignedInfo.reparseSignedInfoElem(element), string, bl);
        this.c14nMethod = XMLUtils.getNextElement(element.getFirstChild());
        this.signatureMethod = XMLUtils.getNextElement(this.c14nMethod.getNextSibling());
        this.signatureAlgorithm = new SignatureAlgorithm(this.signatureMethod, this.getBaseURI(), bl);
    }

    private static Element reparseSignedInfoElem(Element element) throws XMLSecurityException {
        Element element2 = XMLUtils.getNextElement(element.getFirstChild());
        String string = element2.getAttributeNS(null, "Algorithm");
        if (!(string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") || string.equals("http://www.w3.org/2006/12/xml-c14n11") || string.equals("http://www.w3.org/2006/12/xml-c14n11#WithComments"))) {
            try {
                Canonicalizer canonicalizer = Canonicalizer.getInstance(string);
                byte[] byArray = canonicalizer.canonicalizeSubtree(element);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
                Node node = element.getOwnerDocument().importNode(document.getDocumentElement(), true);
                element.getParentNode().replaceChild(node, element);
                return (Element)node;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new XMLSecurityException("empty", parserConfigurationException);
            }
            catch (IOException iOException) {
                throw new XMLSecurityException("empty", iOException);
            }
            catch (SAXException sAXException) {
                throw new XMLSecurityException("empty", sAXException);
            }
        }
        return element;
    }

    public boolean verify() throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(false);
    }

    public boolean verify(boolean bl) throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(bl);
    }

    public byte[] getCanonicalizedOctetStream() throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        if (this.c14nizedBytes == null) {
            Canonicalizer canonicalizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            this.c14nizedBytes = canonicalizer.canonicalizeSubtree(this.constructionElement);
        }
        return (byte[])this.c14nizedBytes.clone();
    }

    public void signInOctetStream(OutputStream outputStream) throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        if (this.c14nizedBytes == null) {
            Canonicalizer canonicalizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            canonicalizer.setWriter(outputStream);
            String string = this.getInclusiveNamespaces();
            if (string == null) {
                canonicalizer.canonicalizeSubtree(this.constructionElement);
            } else {
                canonicalizer.canonicalizeSubtree(this.constructionElement, string);
            }
        } else {
            try {
                outputStream.write(this.c14nizedBytes);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public String getCanonicalizationMethodURI() {
        return this.c14nMethod.getAttributeNS(null, "Algorithm");
    }

    public String getSignatureMethodURI() {
        Element element = this.getSignatureMethodElement();
        if (element != null) {
            return element.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public Element getSignatureMethodElement() {
        return this.signatureMethod;
    }

    public SecretKey createSecretKey(byte[] byArray) {
        return new SecretKeySpec(byArray, this.signatureAlgorithm.getJCEAlgorithmString());
    }

    protected SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String getBaseLocalName() {
        return "SignedInfo";
    }

    public String getInclusiveNamespaces() {
        String string = this.c14nMethod.getAttributeNS(null, "Algorithm");
        if (!string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") && !string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) {
            return null;
        }
        Element element = XMLUtils.getNextElement(this.c14nMethod.getFirstChild());
        if (element != null) {
            try {
                String string2 = new InclusiveNamespaces(element, "http://www.w3.org/2001/10/xml-exc-c14n#").getInclusiveNamespaces();
                return string2;
            }
            catch (XMLSecurityException xMLSecurityException) {
                return null;
            }
        }
        return null;
    }
}

