/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.SignatureProperty;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureProperties
extends SignatureElementProxy {
    public SignatureProperties(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public SignatureProperties(Element element, String string) throws XMLSecurityException {
        super(element, string);
        Attr attr = element.getAttributeNodeNS(null, "Id");
        if (attr != null) {
            element.setIdAttributeNode(attr, true);
        }
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = XMLUtils.selectDsNode(this.constructionElement, "SignatureProperty", i);
            Attr attr2 = element2.getAttributeNodeNS(null, "Id");
            if (attr2 == null) continue;
            element2.setIdAttributeNode(attr2, true);
        }
    }

    public int getLength() {
        Element[] elementArray = XMLUtils.selectDsNodes(this.constructionElement, "SignatureProperty");
        return elementArray.length;
    }

    public SignatureProperty item(int n) throws XMLSignatureException {
        try {
            Element element = XMLUtils.selectDsNode(this.constructionElement, "SignatureProperty", n);
            if (element == null) {
                return null;
            }
            return new SignatureProperty(element, this.baseURI);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public void setId(String string) {
        if (string != null) {
            this.constructionElement.setAttributeNS(null, "Id", string);
            this.constructionElement.setIdAttributeNS(null, "Id", true);
        }
    }

    public String getId() {
        return this.constructionElement.getAttributeNS(null, "Id");
    }

    public void addSignatureProperty(SignatureProperty signatureProperty) {
        this.constructionElement.appendChild(signatureProperty.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public String getBaseLocalName() {
        return "SignatureProperties";
    }
}

