/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.signature.reference.ReferenceData;
import org.apache.xml.security.signature.reference.ReferenceNodeSetData;
import org.apache.xml.security.signature.reference.ReferenceOctetStreamData;
import org.apache.xml.security.signature.reference.ReferenceSubTreeData;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.DigesterOutputStream;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.UnsyncBufferedOutputStream;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Reference
extends SignatureElementProxy {
    public static final String OBJECT_URI = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String MANIFEST_URI = "http://www.w3.org/2000/09/xmldsig#Manifest";
    public static final int MAXIMUM_TRANSFORM_COUNT = 5;
    private boolean secureValidation;
    private static boolean useC14N11 = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("org.apache.xml.security.useC14N11");
        }
    });
    private static final Log log = LogFactory.getLog(Reference.class);
    private Manifest manifest;
    private XMLSignatureInput transformsOutput;
    private Transforms transforms;
    private Element digestMethodElem;
    private Element digestValueElement;
    private ReferenceData referenceData;

    protected Reference(Document document, String string, String string2, Manifest manifest, Transforms transforms, String string3) throws XMLSignatureException {
        super(document);
        XMLUtils.addReturnToElement(this.constructionElement);
        this.baseURI = string;
        this.manifest = manifest;
        this.setURI(string2);
        if (transforms != null) {
            this.transforms = transforms;
            this.constructionElement.appendChild(transforms.getElement());
            XMLUtils.addReturnToElement(this.constructionElement);
        }
        MessageDigestAlgorithm messageDigestAlgorithm = MessageDigestAlgorithm.getInstance(this.doc, string3);
        this.digestMethodElem = messageDigestAlgorithm.getElement();
        this.constructionElement.appendChild(this.digestMethodElem);
        XMLUtils.addReturnToElement(this.constructionElement);
        this.digestValueElement = XMLUtils.createElementInSignatureSpace(this.doc, "DigestValue");
        this.constructionElement.appendChild(this.digestValueElement);
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    protected Reference(Element element, String string, Manifest manifest) throws XMLSecurityException {
        this(element, string, manifest, false);
    }

    protected Reference(Element element, String string, Manifest manifest, boolean bl) throws XMLSecurityException {
        super(element, string);
        this.secureValidation = bl;
        this.baseURI = string;
        Element element2 = XMLUtils.getNextElement(element.getFirstChild());
        if ("Transforms".equals(element2.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(element2.getNamespaceURI())) {
            this.transforms = new Transforms(element2, this.baseURI);
            this.transforms.setSecureValidation(bl);
            if (bl && this.transforms.getLength() > 5) {
                Object[] objectArray = new Object[]{this.transforms.getLength(), 5};
                throw new XMLSecurityException("signature.tooManyTransforms", objectArray);
            }
            element2 = XMLUtils.getNextElement(element2.getNextSibling());
        }
        this.digestMethodElem = element2;
        this.digestValueElement = XMLUtils.getNextElement(this.digestMethodElem.getNextSibling());
        this.manifest = manifest;
    }

    public MessageDigestAlgorithm getMessageDigestAlgorithm() throws XMLSignatureException {
        if (this.digestMethodElem == null) {
            return null;
        }
        String string = this.digestMethodElem.getAttributeNS(null, "Algorithm");
        if (string == null) {
            return null;
        }
        if (this.secureValidation && "http://www.w3.org/2001/04/xmldsig-more#md5".equals(string)) {
            Object[] objectArray = new Object[]{string};
            throw new XMLSignatureException("signature.signatureAlgorithm", objectArray);
        }
        return MessageDigestAlgorithm.getInstance(this.doc, string);
    }

    public void setURI(String string) {
        if (string != null) {
            this.constructionElement.setAttributeNS(null, "URI", string);
        }
    }

    public String getURI() {
        return this.constructionElement.getAttributeNS(null, "URI");
    }

    public void setId(String string) {
        if (string != null) {
            this.constructionElement.setAttributeNS(null, "Id", string);
            this.constructionElement.setIdAttributeNS(null, "Id", true);
        }
    }

    public String getId() {
        return this.constructionElement.getAttributeNS(null, "Id");
    }

    public void setType(String string) {
        if (string != null) {
            this.constructionElement.setAttributeNS(null, "Type", string);
        }
    }

    public String getType() {
        return this.constructionElement.getAttributeNS(null, "Type");
    }

    public boolean typeIsReferenceToObject() {
        return OBJECT_URI.equals(this.getType());
    }

    public boolean typeIsReferenceToManifest() {
        return MANIFEST_URI.equals(this.getType());
    }

    private void setDigestValueElement(byte[] byArray) {
        for (Node node = this.digestValueElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.digestValueElement.removeChild(node);
        }
        String string = Base64.encode(byArray);
        Text text = this.doc.createTextNode(string);
        this.digestValueElement.appendChild(text);
    }

    public void generateDigestValue() throws XMLSignatureException, ReferenceNotInitializedException {
        this.setDigestValueElement(this.calculateDigest(false));
    }

    public XMLSignatureInput getContentsBeforeTransformation() throws ReferenceNotInitializedException {
        try {
            Attr attr = this.constructionElement.getAttributeNodeNS(null, "URI");
            ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, this.baseURI, this.manifest.getPerManifestResolvers(), this.secureValidation);
            resourceResolver.addProperties(this.manifest.getResolverProperties());
            return resourceResolver.resolve(attr, this.baseURI);
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new ReferenceNotInitializedException("empty", resourceResolverException);
        }
    }

    private XMLSignatureInput getContentsAfterTransformation(XMLSignatureInput xMLSignatureInput, OutputStream outputStream) throws XMLSignatureException {
        try {
            Transforms transforms = this.getTransforms();
            XMLSignatureInput xMLSignatureInput2 = null;
            if (transforms != null) {
                this.transformsOutput = xMLSignatureInput2 = transforms.performTransforms(xMLSignatureInput, outputStream);
            } else {
                xMLSignatureInput2 = xMLSignatureInput;
            }
            return xMLSignatureInput2;
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new XMLSignatureException("empty", resourceResolverException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getContentsAfterTransformation() throws XMLSignatureException {
        XMLSignatureInput xMLSignatureInput = this.getContentsBeforeTransformation();
        this.cacheDereferencedElement(xMLSignatureInput);
        return this.getContentsAfterTransformation(xMLSignatureInput, null);
    }

    public XMLSignatureInput getNodesetBeforeFirstCanonicalization() throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput = this.getContentsBeforeTransformation();
            this.cacheDereferencedElement(xMLSignatureInput);
            XMLSignatureInput xMLSignatureInput2 = xMLSignatureInput;
            Transforms transforms = this.getTransforms();
            if (transforms != null) {
                Transform transform;
                String string;
                for (int i = 0; !(i >= transforms.getLength() || (string = (transform = transforms.item(i)).getURI()).equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments")); ++i) {
                    xMLSignatureInput2 = transform.performTransform(xMLSignatureInput2, null);
                }
                xMLSignatureInput2.setSourceURI(xMLSignatureInput.getSourceURI());
            }
            return xMLSignatureInput2;
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new XMLSignatureException("empty", resourceResolverException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        try {
            ElementProxy elementProxy;
            XMLSignatureInput xMLSignatureInput = this.getNodesetBeforeFirstCanonicalization();
            Transforms transforms = this.getTransforms();
            ElementProxy elementProxy2 = null;
            if (transforms != null) {
                for (int i = 0; i < transforms.getLength(); ++i) {
                    elementProxy = transforms.item(i);
                    String string = ((Transform)elementProxy).getURI();
                    if (!string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") && !string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) continue;
                    elementProxy2 = elementProxy;
                    break;
                }
            }
            Set<String> set = new HashSet<String>();
            if (elementProxy2 != null && elementProxy2.length("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces") == 1) {
                elementProxy = new InclusiveNamespaces(XMLUtils.selectNode(elementProxy2.getElement().getFirstChild(), "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces", 0), this.getBaseURI());
                set = InclusiveNamespaces.prefixStr2Set(((InclusiveNamespaces)elementProxy).getInclusiveNamespaces());
            }
            return xMLSignatureInput.getHTMLRepresentation(set);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new XMLSignatureException("empty", invalidTransformException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getTransformsOutput() {
        return this.transformsOutput;
    }

    public ReferenceData getReferenceData() {
        return this.referenceData;
    }

    protected XMLSignatureInput dereferenceURIandPerformTransforms(OutputStream outputStream) throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput;
            XMLSignatureInput xMLSignatureInput2 = this.getContentsBeforeTransformation();
            this.cacheDereferencedElement(xMLSignatureInput2);
            this.transformsOutput = xMLSignatureInput = this.getContentsAfterTransformation(xMLSignatureInput2, outputStream);
            return xMLSignatureInput;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
    }

    private void cacheDereferencedElement(XMLSignatureInput xMLSignatureInput) {
        if (xMLSignatureInput.isNodeSet()) {
            try {
                final Set<Node> set = xMLSignatureInput.getNodeSet();
                this.referenceData = new ReferenceNodeSetData(){

                    @Override
                    public Iterator<Node> iterator() {
                        return new Iterator<Node>(){
                            Iterator<Node> sIterator;
                            {
                                this.sIterator = set.iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.sIterator.hasNext();
                            }

                            @Override
                            public Node next() {
                                return this.sIterator.next();
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }
            catch (Exception exception) {
                log.warn("cannot cache dereferenced data: " + exception);
            }
        } else if (xMLSignatureInput.isElement()) {
            this.referenceData = new ReferenceSubTreeData(xMLSignatureInput.getSubNode(), xMLSignatureInput.isExcludeComments());
        } else if (xMLSignatureInput.isOctetStream() || xMLSignatureInput.isByteArray()) {
            try {
                this.referenceData = new ReferenceOctetStreamData(xMLSignatureInput.getOctetStream(), xMLSignatureInput.getSourceURI(), xMLSignatureInput.getMIMEType());
            }
            catch (IOException iOException) {
                log.warn("cannot cache dereferenced data: " + iOException);
            }
        }
    }

    public Transforms getTransforms() throws XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        return this.transforms;
    }

    public byte[] getReferencedBytes() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput = this.dereferenceURIandPerformTransforms(null);
            return xMLSignatureInput.getBytes();
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new ReferenceNotInitializedException("empty", canonicalizationException);
        }
    }

    private byte[] calculateDigest(boolean bl) throws ReferenceNotInitializedException, XMLSignatureException {
        OutputStream outputStream = null;
        try {
            MessageDigestAlgorithm messageDigestAlgorithm = this.getMessageDigestAlgorithm();
            messageDigestAlgorithm.reset();
            DigesterOutputStream digesterOutputStream = new DigesterOutputStream(messageDigestAlgorithm);
            outputStream = new UnsyncBufferedOutputStream(digesterOutputStream);
            XMLSignatureInput xMLSignatureInput = this.dereferenceURIandPerformTransforms(outputStream);
            if (useC14N11 && !bl && !xMLSignatureInput.isOutputStreamSet() && !xMLSignatureInput.isOctetStream()) {
                if (this.transforms == null) {
                    this.transforms = new Transforms(this.doc);
                    this.transforms.setSecureValidation(this.secureValidation);
                    this.constructionElement.insertBefore(this.transforms.getElement(), this.digestMethodElem);
                }
                this.transforms.addTransform("http://www.w3.org/2006/12/xml-c14n11");
                xMLSignatureInput.updateOutputStream(outputStream, true);
            } else {
                xMLSignatureInput.updateOutputStream(outputStream);
            }
            outputStream.flush();
            if (xMLSignatureInput.getOctetStreamReal() != null) {
                xMLSignatureInput.getOctetStreamReal().close();
            }
            byte[] byArray = digesterOutputStream.getDigestValue();
            return byArray;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    throw new ReferenceNotInitializedException("empty", iOException);
                }
            }
        }
    }

    public byte[] getDigestValue() throws Base64DecodingException, XMLSecurityException {
        if (this.digestValueElement == null) {
            Object[] objectArray = new Object[]{"DigestValue", "http://www.w3.org/2000/09/xmldsig#"};
            throw new XMLSecurityException("signature.Verification.NoSignatureElement", objectArray);
        }
        return Base64.decode(this.digestValueElement);
    }

    public boolean verify() throws ReferenceNotInitializedException, XMLSecurityException {
        byte[] byArray;
        byte[] byArray2 = this.getDigestValue();
        boolean bl = MessageDigestAlgorithm.isEqual(byArray2, byArray = this.calculateDigest(true));
        if (!bl) {
            log.warn("Verification failed for URI \"" + this.getURI() + "\"");
            log.warn("Expected Digest: " + Base64.encode(byArray2));
            log.warn("Actual Digest: " + Base64.encode(byArray));
        } else if (log.isDebugEnabled()) {
            log.debug("Verification successful for URI \"" + this.getURI() + "\"");
        }
        return bl;
    }

    public String getBaseLocalName() {
        return "Reference";
    }
}

