/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509SubjectName;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class X509SubjectNameResolver
extends KeyResolverSpi {
    private static Log log = LogFactory.getLog(X509SubjectNameResolver.class);

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineLookupResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Can I resolve " + element.getTagName() + "?");
        }
        Element[] elementArray = null;
        XMLX509SubjectName[] xMLX509SubjectNameArray = null;
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            if (log.isDebugEnabled()) {
                log.debug("I can't");
            }
            return null;
        }
        elementArray = XMLUtils.selectDsNodes(element.getFirstChild(), "X509SubjectName");
        if (elementArray == null || elementArray.length <= 0) {
            if (log.isDebugEnabled()) {
                log.debug("I can't");
            }
            return null;
        }
        try {
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509SubjectName"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                if (log.isDebugEnabled()) {
                    log.debug("", keyResolverException);
                }
                throw keyResolverException;
            }
            xMLX509SubjectNameArray = new XMLX509SubjectName[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                xMLX509SubjectNameArray[i] = new XMLX509SubjectName(elementArray[i], string);
            }
            Iterator<Certificate> iterator = storageResolver.getIterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                XMLX509SubjectName xMLX509SubjectName = new XMLX509SubjectName(element.getOwnerDocument(), x509Certificate);
                if (log.isDebugEnabled()) {
                    log.debug("Found Certificate SN: " + xMLX509SubjectName.getSubjectName());
                }
                for (int i = 0; i < xMLX509SubjectNameArray.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug("Found Element SN:     " + xMLX509SubjectNameArray[i].getSubjectName());
                    }
                    if (xMLX509SubjectName.equals(xMLX509SubjectNameArray[i])) {
                        if (log.isDebugEnabled()) {
                            log.debug("match !!! ");
                        }
                        return x509Certificate;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            if (log.isDebugEnabled()) {
                log.debug("XMLSecurityException", xMLSecurityException);
            }
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

