/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Digest;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class X509DigestResolver
extends KeyResolverSpi {
    private static Log log = LogFactory.getLog(X509DigestResolver.class);

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        if (XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            try {
                X509Data x509Data = new X509Data(element, string);
                return x509Data.containsDigest();
            }
            catch (XMLSecurityException xMLSecurityException) {
                return false;
            }
        }
        return false;
    }

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineLookupResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Can I resolve " + element.getTagName());
        }
        if (!this.engineCanResolve(element, string, storageResolver)) {
            return null;
        }
        try {
            return this.resolveCertificate(element, string, storageResolver);
        }
        catch (XMLSecurityException xMLSecurityException) {
            if (log.isDebugEnabled()) {
                log.debug("XMLSecurityException", xMLSecurityException);
            }
            return null;
        }
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    private X509Certificate resolveCertificate(Element element, String string, StorageResolver storageResolver) throws XMLSecurityException {
        XMLX509Digest[] xMLX509DigestArray = null;
        Element[] elementArray = XMLUtils.selectDs11Nodes(element.getFirstChild(), "X509Digest");
        if (elementArray == null || elementArray.length <= 0) {
            return null;
        }
        try {
            this.checkStorage(storageResolver);
            xMLX509DigestArray = new XMLX509Digest[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                xMLX509DigestArray[i] = new XMLX509Digest(elementArray[i], string);
            }
            Iterator<Certificate> iterator = storageResolver.getIterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                for (int i = 0; i < xMLX509DigestArray.length; ++i) {
                    XMLX509Digest xMLX509Digest = xMLX509DigestArray[i];
                    byte[] byArray = XMLX509Digest.getDigestBytesFromCert(x509Certificate, xMLX509Digest.getAlgorithm());
                    if (!Arrays.equals(xMLX509Digest.getDigestBytes(), byArray)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Found certificate with: " + x509Certificate.getSubjectX500Principal().getName());
                    }
                    return x509Certificate;
                }
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new KeyResolverException("empty", xMLSecurityException);
        }
        return null;
    }

    private void checkStorage(StorageResolver storageResolver) throws KeyResolverException {
        if (storageResolver == null) {
            Object[] objectArray = new Object[]{"X509Digest"};
            KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
            if (log.isDebugEnabled()) {
                log.debug("", keyResolverException);
            }
            throw keyResolverException;
        }
    }
}

