/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class X509CertificateResolver
extends KeyResolverSpi {
    private static Log log = LogFactory.getLog(X509CertificateResolver.class);

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineLookupResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        try {
            Element[] elementArray = XMLUtils.selectDsNodes(element.getFirstChild(), "X509Certificate");
            if (elementArray == null || elementArray.length == 0) {
                Element element2 = XMLUtils.selectDsNode(element.getFirstChild(), "X509Data", 0);
                if (element2 != null) {
                    return this.engineLookupResolveX509Certificate(element2, string, storageResolver);
                }
                return null;
            }
            for (int i = 0; i < elementArray.length; ++i) {
                XMLX509Certificate xMLX509Certificate = new XMLX509Certificate(elementArray[i], string);
                X509Certificate x509Certificate = xMLX509Certificate.getX509Certificate();
                if (x509Certificate == null) continue;
                return x509Certificate;
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            if (log.isDebugEnabled()) {
                log.debug("XMLSecurityException", xMLSecurityException);
            }
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

