/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.RetrievalMethod;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrievalMethodResolver
extends KeyResolverSpi {
    private static Log log = LogFactory.getLog(RetrievalMethodResolver.class);

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) {
        block18: {
            if (!XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod")) {
                return null;
            }
            try {
                RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
                String string2 = retrievalMethod.getType();
                XMLSignatureInput xMLSignatureInput = RetrievalMethodResolver.resolveInput(retrievalMethod, string, this.secureValidation);
                if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(string2)) {
                    X509Certificate x509Certificate = RetrievalMethodResolver.getRawCertificate(xMLSignatureInput);
                    if (x509Certificate != null) {
                        return x509Certificate.getPublicKey();
                    }
                    return null;
                }
                Element element2 = RetrievalMethodResolver.obtainReferenceElement(xMLSignatureInput);
                if (XMLUtils.elementIsInSignatureSpace(element2, "RetrievalMethod")) {
                    if (this.secureValidation) {
                        String string3 = "Error: It is forbidden to have one RetrievalMethod point to another with secure validation";
                        if (log.isDebugEnabled()) {
                            log.debug(string3);
                        }
                        return null;
                    }
                    RetrievalMethod retrievalMethod2 = new RetrievalMethod(element2, string);
                    XMLSignatureInput xMLSignatureInput2 = RetrievalMethodResolver.resolveInput(retrievalMethod2, string, this.secureValidation);
                    Element element3 = RetrievalMethodResolver.obtainReferenceElement(xMLSignatureInput2);
                    if (element3 == element) {
                        if (log.isDebugEnabled()) {
                            log.debug("Error: Can't have RetrievalMethods pointing to each other");
                        }
                        return null;
                    }
                }
                return RetrievalMethodResolver.resolveKey(element2, string, storageResolver);
            }
            catch (XMLSecurityException xMLSecurityException) {
                if (log.isDebugEnabled()) {
                    log.debug("XMLSecurityException", xMLSecurityException);
                }
            }
            catch (CertificateException certificateException) {
                if (log.isDebugEnabled()) {
                    log.debug("CertificateException", certificateException);
                }
            }
            catch (IOException iOException) {
                if (log.isDebugEnabled()) {
                    log.debug("IOException", iOException);
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (log.isDebugEnabled()) {
                    log.debug("ParserConfigurationException", parserConfigurationException);
                }
            }
            catch (SAXException sAXException) {
                if (!log.isDebugEnabled()) break block18;
                log.debug("SAXException", sAXException);
            }
        }
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) {
        block17: {
            if (!XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod")) {
                return null;
            }
            try {
                RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
                String string2 = retrievalMethod.getType();
                XMLSignatureInput xMLSignatureInput = RetrievalMethodResolver.resolveInput(retrievalMethod, string, this.secureValidation);
                if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(string2)) {
                    return RetrievalMethodResolver.getRawCertificate(xMLSignatureInput);
                }
                Element element2 = RetrievalMethodResolver.obtainReferenceElement(xMLSignatureInput);
                if (XMLUtils.elementIsInSignatureSpace(element2, "RetrievalMethod")) {
                    if (this.secureValidation) {
                        String string3 = "Error: It is forbidden to have one RetrievalMethod point to another with secure validation";
                        if (log.isDebugEnabled()) {
                            log.debug(string3);
                        }
                        return null;
                    }
                    RetrievalMethod retrievalMethod2 = new RetrievalMethod(element2, string);
                    XMLSignatureInput xMLSignatureInput2 = RetrievalMethodResolver.resolveInput(retrievalMethod2, string, this.secureValidation);
                    Element element3 = RetrievalMethodResolver.obtainReferenceElement(xMLSignatureInput2);
                    if (element3 == element) {
                        if (log.isDebugEnabled()) {
                            log.debug("Error: Can't have RetrievalMethods pointing to each other");
                        }
                        return null;
                    }
                }
                return RetrievalMethodResolver.resolveCertificate(element2, string, storageResolver);
            }
            catch (XMLSecurityException xMLSecurityException) {
                if (log.isDebugEnabled()) {
                    log.debug("XMLSecurityException", xMLSecurityException);
                }
            }
            catch (CertificateException certificateException) {
                if (log.isDebugEnabled()) {
                    log.debug("CertificateException", certificateException);
                }
            }
            catch (IOException iOException) {
                if (log.isDebugEnabled()) {
                    log.debug("IOException", iOException);
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (log.isDebugEnabled()) {
                    log.debug("ParserConfigurationException", parserConfigurationException);
                }
            }
            catch (SAXException sAXException) {
                if (!log.isDebugEnabled()) break block17;
                log.debug("SAXException", sAXException);
            }
        }
        return null;
    }

    private static X509Certificate resolveCertificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Now we have a {" + element.getNamespaceURI() + "}" + element.getLocalName() + " Element");
        }
        if (element != null) {
            return KeyResolver.getX509Certificate(element, string, storageResolver);
        }
        return null;
    }

    private static PublicKey resolveKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Now we have a {" + element.getNamespaceURI() + "}" + element.getLocalName() + " Element");
        }
        if (element != null) {
            return KeyResolver.getPublicKey(element, string, storageResolver);
        }
        return null;
    }

    private static Element obtainReferenceElement(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException, KeyResolverException {
        Element element;
        if (xMLSignatureInput.isElement()) {
            element = (Element)xMLSignatureInput.getSubNode();
        } else if (xMLSignatureInput.isNodeSet()) {
            element = RetrievalMethodResolver.getDocumentElement(xMLSignatureInput.getNodeSet());
        } else {
            byte[] byArray = xMLSignatureInput.getBytes();
            element = RetrievalMethodResolver.getDocFromBytes(byArray);
            if (log.isDebugEnabled()) {
                log.debug("we have to parse " + byArray.length + " bytes");
            }
        }
        return element;
    }

    private static X509Certificate getRawCertificate(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, IOException, CertificateException {
        byte[] byArray = xMLSignatureInput.getBytes();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        return x509Certificate;
    }

    private static XMLSignatureInput resolveInput(RetrievalMethod retrievalMethod, String string, boolean bl) throws XMLSecurityException {
        Attr attr = retrievalMethod.getURIAttr();
        Transforms transforms = retrievalMethod.getTransforms();
        ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string, bl);
        XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, string);
        if (transforms != null) {
            if (log.isDebugEnabled()) {
                log.debug("We have Transforms");
            }
            xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
        }
        return xMLSignatureInput;
    }

    private static Element getDocFromBytes(byte[] byArray) throws KeyResolverException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
            return document.getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new KeyResolverException("empty", sAXException);
        }
        catch (IOException iOException) {
            throw new KeyResolverException("empty", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new KeyResolverException("empty", parserConfigurationException);
        }
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    private static Element getDocumentElement(Set<Node> set) {
        Object object;
        Object object2;
        Iterator<Node> iterator = set.iterator();
        Node node = null;
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 == null || 1 != object2.getNodeType()) continue;
            node = (Element)object2;
            break;
        }
        object2 = new ArrayList();
        while (node != null) {
            object2.add(node);
            object = node.getParentNode();
            if (object == null || 1 != object.getNodeType()) break;
            node = (Element)object;
        }
        object = object2.listIterator(object2.size() - 1);
        Element element = null;
        while (object.hasPrevious()) {
            element = (Element)object.previous();
            if (!set.contains(element)) continue;
            return element;
        }
        return null;
    }
}

