/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;
import org.apache.xml.security.keys.content.x509.XMLX509SubjectName;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class PrivateKeyResolver
extends KeyResolverSpi {
    private static Log log = LogFactory.getLog(PrivateKeyResolver.class.getName());
    private KeyStore keyStore;
    private char[] password;

    public PrivateKeyResolver(KeyStore keyStore, char[] cArray) {
        this.keyStore = keyStore;
        this.password = cArray;
    }

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        return XMLUtils.elementIsInSignatureSpace(element, "X509Data") || XMLUtils.elementIsInSignatureSpace(element, "KeyName");
    }

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    public PrivateKey engineLookupAndResolvePrivateKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Can I resolve " + element.getTagName() + "?");
        }
        if (XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            PrivateKey privateKey = this.resolveX509Data(element, string);
            if (privateKey != null) {
                return privateKey;
            }
        } else if (XMLUtils.elementIsInSignatureSpace(element, "KeyName")) {
            log.debug("Can I resolve KeyName?");
            String string2 = element.getFirstChild().getNodeValue();
            try {
                Key key = this.keyStore.getKey(string2, this.password);
                if (key instanceof PrivateKey) {
                    return (PrivateKey)key;
                }
            }
            catch (Exception exception) {
                log.debug("Cannot recover the key", exception);
            }
        }
        log.debug("I can't");
        return null;
    }

    private PrivateKey resolveX509Data(Element element, String string) {
        log.debug("Can I resolve X509Data?");
        try {
            PrivateKey privateKey;
            SignatureElementProxy signatureElementProxy;
            int n;
            X509Data x509Data = new X509Data(element, string);
            int n2 = x509Data.lengthSKI();
            for (n = 0; n < n2; ++n) {
                signatureElementProxy = x509Data.itemSKI(n);
                privateKey = this.resolveX509SKI((XMLX509SKI)signatureElementProxy);
                if (privateKey == null) continue;
                return privateKey;
            }
            n2 = x509Data.lengthIssuerSerial();
            for (n = 0; n < n2; ++n) {
                signatureElementProxy = x509Data.itemIssuerSerial(n);
                privateKey = this.resolveX509IssuerSerial((XMLX509IssuerSerial)signatureElementProxy);
                if (privateKey == null) continue;
                return privateKey;
            }
            n2 = x509Data.lengthSubjectName();
            for (n = 0; n < n2; ++n) {
                signatureElementProxy = x509Data.itemSubjectName(n);
                privateKey = this.resolveX509SubjectName((XMLX509SubjectName)signatureElementProxy);
                if (privateKey == null) continue;
                return privateKey;
            }
            n2 = x509Data.lengthCertificate();
            for (n = 0; n < n2; ++n) {
                signatureElementProxy = x509Data.itemCertificate(n);
                privateKey = this.resolveX509Certificate((XMLX509Certificate)signatureElementProxy);
                if (privateKey == null) continue;
                return privateKey;
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug("XMLSecurityException", xMLSecurityException);
        }
        catch (KeyStoreException keyStoreException) {
            log.debug("KeyStoreException", keyStoreException);
        }
        return null;
    }

    private PrivateKey resolveX509SKI(XMLX509SKI xMLX509SKI) throws XMLSecurityException, KeyStoreException {
        log.debug("Can I resolve X509SKI?");
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            XMLX509SKI xMLX509SKI2;
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!this.keyStore.isKeyEntry(string) || !((certificate = this.keyStore.getCertificate(string)) instanceof X509Certificate) || !(xMLX509SKI2 = new XMLX509SKI(xMLX509SKI.getDocument(), (X509Certificate)certificate)).equals(xMLX509SKI)) continue;
            log.debug("match !!! ");
            try {
                Key key = this.keyStore.getKey(string, this.password);
                if (!(key instanceof PrivateKey)) continue;
                return (PrivateKey)key;
            }
            catch (Exception exception) {
                log.debug("Cannot recover the key", exception);
            }
        }
        return null;
    }

    private PrivateKey resolveX509IssuerSerial(XMLX509IssuerSerial xMLX509IssuerSerial) throws KeyStoreException {
        log.debug("Can I resolve X509IssuerSerial?");
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            XMLX509IssuerSerial xMLX509IssuerSerial2;
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!this.keyStore.isKeyEntry(string) || !((certificate = this.keyStore.getCertificate(string)) instanceof X509Certificate) || !(xMLX509IssuerSerial2 = new XMLX509IssuerSerial(xMLX509IssuerSerial.getDocument(), (X509Certificate)certificate)).equals(xMLX509IssuerSerial)) continue;
            log.debug("match !!! ");
            try {
                Key key = this.keyStore.getKey(string, this.password);
                if (!(key instanceof PrivateKey)) continue;
                return (PrivateKey)key;
            }
            catch (Exception exception) {
                log.debug("Cannot recover the key", exception);
            }
        }
        return null;
    }

    private PrivateKey resolveX509SubjectName(XMLX509SubjectName xMLX509SubjectName) throws KeyStoreException {
        log.debug("Can I resolve X509SubjectName?");
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            XMLX509SubjectName xMLX509SubjectName2;
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!this.keyStore.isKeyEntry(string) || !((certificate = this.keyStore.getCertificate(string)) instanceof X509Certificate) || !(xMLX509SubjectName2 = new XMLX509SubjectName(xMLX509SubjectName.getDocument(), (X509Certificate)certificate)).equals(xMLX509SubjectName)) continue;
            log.debug("match !!! ");
            try {
                Key key = this.keyStore.getKey(string, this.password);
                if (!(key instanceof PrivateKey)) continue;
                return (PrivateKey)key;
            }
            catch (Exception exception) {
                log.debug("Cannot recover the key", exception);
            }
        }
        return null;
    }

    private PrivateKey resolveX509Certificate(XMLX509Certificate xMLX509Certificate) throws XMLSecurityException, KeyStoreException {
        log.debug("Can I resolve X509Certificate?");
        byte[] byArray = xMLX509Certificate.getCertificateBytes();
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!this.keyStore.isKeyEntry(string) || !((certificate = this.keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
            byte[] byArray2 = null;
            try {
                byArray2 = certificate.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
            if (byArray2 == null || !Arrays.equals(byArray2, byArray)) continue;
            log.debug("match !!! ");
            try {
                Key key = this.keyStore.getKey(string, this.password);
                if (!(key instanceof PrivateKey)) continue;
                return (PrivateKey)key;
            }
            catch (Exception exception) {
                log.debug("Cannot recover the key", exception);
            }
        }
        return null;
    }
}

