/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyInfoReference;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class KeyInfoReferenceResolver
extends KeyResolverSpi {
    private static Log log = LogFactory.getLog(KeyInfoReferenceResolver.class);

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        return XMLUtils.elementIsInSignature11Space(element, "KeyInfoReference");
    }

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        block5: {
            if (log.isDebugEnabled()) {
                log.debug("Can I resolve " + element.getTagName());
            }
            if (!this.engineCanResolve(element, string, storageResolver)) {
                return null;
            }
            try {
                KeyInfo keyInfo = this.resolveReferentKeyInfo(element, string, storageResolver);
                if (keyInfo != null) {
                    return keyInfo.getPublicKey();
                }
            }
            catch (XMLSecurityException xMLSecurityException) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("XMLSecurityException", xMLSecurityException);
            }
        }
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        block5: {
            if (log.isDebugEnabled()) {
                log.debug("Can I resolve " + element.getTagName());
            }
            if (!this.engineCanResolve(element, string, storageResolver)) {
                return null;
            }
            try {
                KeyInfo keyInfo = this.resolveReferentKeyInfo(element, string, storageResolver);
                if (keyInfo != null) {
                    return keyInfo.getX509Certificate();
                }
            }
            catch (XMLSecurityException xMLSecurityException) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("XMLSecurityException", xMLSecurityException);
            }
        }
        return null;
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        block5: {
            if (log.isDebugEnabled()) {
                log.debug("Can I resolve " + element.getTagName());
            }
            if (!this.engineCanResolve(element, string, storageResolver)) {
                return null;
            }
            try {
                KeyInfo keyInfo = this.resolveReferentKeyInfo(element, string, storageResolver);
                if (keyInfo != null) {
                    return keyInfo.getSecretKey();
                }
            }
            catch (XMLSecurityException xMLSecurityException) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("XMLSecurityException", xMLSecurityException);
            }
        }
        return null;
    }

    public PrivateKey engineLookupAndResolvePrivateKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        block5: {
            if (log.isDebugEnabled()) {
                log.debug("Can I resolve " + element.getTagName());
            }
            if (!this.engineCanResolve(element, string, storageResolver)) {
                return null;
            }
            try {
                KeyInfo keyInfo = this.resolveReferentKeyInfo(element, string, storageResolver);
                if (keyInfo != null) {
                    return keyInfo.getPrivateKey();
                }
            }
            catch (XMLSecurityException xMLSecurityException) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("XMLSecurityException", xMLSecurityException);
            }
        }
        return null;
    }

    private KeyInfo resolveReferentKeyInfo(Element element, String string, StorageResolver storageResolver) throws XMLSecurityException {
        KeyInfoReference keyInfoReference = new KeyInfoReference(element, string);
        Attr attr = keyInfoReference.getURIAttr();
        XMLSignatureInput xMLSignatureInput = this.resolveInput(attr, string, this.secureValidation);
        Element element2 = null;
        try {
            element2 = this.obtainReferenceElement(xMLSignatureInput);
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug("XMLSecurityException", exception);
            }
            return null;
        }
        if (element2 == null) {
            log.debug("De-reference of KeyInfoReference URI returned null: " + attr.getValue());
            return null;
        }
        this.validateReference(element2);
        KeyInfo keyInfo = new KeyInfo(element2, string);
        keyInfo.addStorageResolver(storageResolver);
        return keyInfo;
    }

    private void validateReference(Element element) throws XMLSecurityException {
        if (!XMLUtils.elementIsInSignatureSpace(element, "KeyInfo")) {
            Object[] objectArray = new Object[]{new QName(element.getNamespaceURI(), element.getLocalName())};
            throw new XMLSecurityException("KeyInfoReferenceResolver.InvalidReferentElement.WrongType", objectArray);
        }
        KeyInfo keyInfo = new KeyInfo(element, "");
        if (keyInfo.containsKeyInfoReference()) {
            if (this.secureValidation) {
                throw new XMLSecurityException("KeyInfoReferenceResolver.InvalidReferentElement.ReferenceWithSecure");
            }
            throw new XMLSecurityException("KeyInfoReferenceResolver.InvalidReferentElement.ReferenceWithoutSecure");
        }
    }

    private XMLSignatureInput resolveInput(Attr attr, String string, boolean bl) throws XMLSecurityException {
        ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string, bl);
        XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, string);
        return xMLSignatureInput;
    }

    private Element obtainReferenceElement(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException, KeyResolverException {
        Element element;
        if (xMLSignatureInput.isElement()) {
            element = (Element)xMLSignatureInput.getSubNode();
        } else {
            if (xMLSignatureInput.isNodeSet()) {
                log.debug("De-reference of KeyInfoReference returned an unsupported NodeSet");
                return null;
            }
            byte[] byArray = xMLSignatureInput.getBytes();
            element = this.getDocFromBytes(byArray);
        }
        return element;
    }

    private Element getDocFromBytes(byte[] byArray) throws KeyResolverException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
            return document.getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new KeyResolverException("empty", sAXException);
        }
        catch (IOException iOException) {
            throw new KeyResolverException("empty", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new KeyResolverException("empty", parserConfigurationException);
        }
    }
}

