/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.keyresolver.implementations.RSAKeyValueResolver;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class EncryptedKeyResolver
extends KeyResolverSpi {
    private static Log log = LogFactory.getLog(RSAKeyValueResolver.class);
    private Key kek;
    private String algorithm;
    private List<KeyResolverSpi> internalKeyResolvers;

    public EncryptedKeyResolver(String string) {
        this.kek = null;
        this.algorithm = string;
    }

    public EncryptedKeyResolver(String string, Key key) {
        this.algorithm = string;
        this.kek = key;
    }

    public void registerInternalKeyResolver(KeyResolverSpi keyResolverSpi) {
        if (this.internalKeyResolvers == null) {
            this.internalKeyResolvers = new ArrayList<KeyResolverSpi>();
        }
        this.internalKeyResolvers.add(keyResolverSpi);
    }

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        SecretKey secretKey;
        block8: {
            if (log.isDebugEnabled()) {
                log.debug("EncryptedKeyResolver - Can I resolve " + element.getTagName());
            }
            if (element == null) {
                return null;
            }
            secretKey = null;
            boolean bl = XMLUtils.elementIsInEncryptionSpace(element, "EncryptedKey");
            if (bl) {
                if (log.isDebugEnabled()) {
                    log.debug("Passed an Encrypted Key");
                }
                try {
                    XMLCipher xMLCipher = XMLCipher.getInstance();
                    xMLCipher.init(4, this.kek);
                    if (this.internalKeyResolvers != null) {
                        int n = this.internalKeyResolvers.size();
                        for (int i = 0; i < n; ++i) {
                            xMLCipher.registerInternalKeyResolver(this.internalKeyResolvers.get(i));
                        }
                    }
                    EncryptedKey encryptedKey = xMLCipher.loadEncryptedKey(element);
                    secretKey = (SecretKey)xMLCipher.decryptKey(encryptedKey, this.algorithm);
                }
                catch (XMLEncryptionException xMLEncryptionException) {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug(xMLEncryptionException);
                }
            }
        }
        return secretKey;
    }
}

