/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content.x509;

import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509DataContent;
import org.apache.xml.security.utils.Signature11ElementProxy;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509Digest
extends Signature11ElementProxy
implements XMLX509DataContent {
    public XMLX509Digest(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public XMLX509Digest(Document document, byte[] byArray, String string) {
        super(document);
        this.addBase64Text(byArray);
        this.constructionElement.setAttributeNS(null, "Algorithm", string);
    }

    public XMLX509Digest(Document document, X509Certificate x509Certificate, String string) throws XMLSecurityException {
        super(document);
        this.addBase64Text(XMLX509Digest.getDigestBytesFromCert(x509Certificate, string));
        this.constructionElement.setAttributeNS(null, "Algorithm", string);
    }

    public Attr getAlgorithmAttr() {
        return this.constructionElement.getAttributeNodeNS(null, "Algorithm");
    }

    public String getAlgorithm() {
        return this.getAlgorithmAttr().getNodeValue();
    }

    public byte[] getDigestBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public static byte[] getDigestBytesFromCert(X509Certificate x509Certificate, String string) throws XMLSecurityException {
        String string2 = JCEMapper.translateURItoJCEID(string);
        if (string2 == null) {
            Object[] objectArray = new Object[]{string};
            throw new XMLSecurityException("XMLX509Digest.UnknownDigestAlgorithm", objectArray);
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string2);
            return messageDigest.digest(x509Certificate.getEncoded());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string2};
            throw new XMLSecurityException("XMLX509Digest.FailedDigest", objectArray);
        }
    }

    public String getBaseLocalName() {
        return "X509Digest";
    }
}

