/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content.keyvalues;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.keyvalues.KeyValueContent;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DSAKeyValue
extends SignatureElementProxy
implements KeyValueContent {
    public DSAKeyValue(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public DSAKeyValue(Document document, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(document);
        XMLUtils.addReturnToElement(this.constructionElement);
        this.addBigIntegerElement(bigInteger, "P");
        this.addBigIntegerElement(bigInteger2, "Q");
        this.addBigIntegerElement(bigInteger3, "G");
        this.addBigIntegerElement(bigInteger4, "Y");
    }

    public DSAKeyValue(Document document, Key key) throws IllegalArgumentException {
        super(document);
        XMLUtils.addReturnToElement(this.constructionElement);
        if (!(key instanceof DSAPublicKey)) {
            Object[] objectArray = new Object[]{"DSAKeyValue", key.getClass().getName()};
            throw new IllegalArgumentException(I18n.translate("KeyValue.IllegalArgument", objectArray));
        }
        this.addBigIntegerElement(((DSAPublicKey)key).getParams().getP(), "P");
        this.addBigIntegerElement(((DSAPublicKey)key).getParams().getQ(), "Q");
        this.addBigIntegerElement(((DSAPublicKey)key).getParams().getG(), "G");
        this.addBigIntegerElement(((DSAPublicKey)key).getY(), "Y");
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        try {
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(this.getBigIntegerFromChildElement("Y", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("P", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("Q", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("G", "http://www.w3.org/2000/09/xmldsig#"));
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PublicKey publicKey = keyFactory.generatePublic(dSAPublicKeySpec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLSecurityException("empty", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new XMLSecurityException("empty", invalidKeySpecException);
        }
    }

    public String getBaseLocalName() {
        return "DSAKeyValue";
    }
}

