/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.DEREncodedKeyValue;
import org.apache.xml.security.keys.content.KeyInfoReference;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.keys.content.KeyValue;
import org.apache.xml.security.keys.content.MgmtData;
import org.apache.xml.security.keys.content.PGPData;
import org.apache.xml.security.keys.content.RetrievalMethod;
import org.apache.xml.security.keys.content.SPKIData;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyInfo
extends SignatureElementProxy {
    private static Log log = LogFactory.getLog(KeyInfo.class);
    private List<X509Data> x509Datas = null;
    private List<EncryptedKey> encryptedKeys = null;
    private static final List<StorageResolver> nullList;
    private List<StorageResolver> storageResolvers = nullList;
    private List<KeyResolverSpi> internalKeyResolvers = new ArrayList<KeyResolverSpi>();
    private boolean secureValidation;

    public KeyInfo(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public KeyInfo(Element element, String string) throws XMLSecurityException {
        super(element, string);
        Attr attr = element.getAttributeNodeNS(null, "Id");
        if (attr != null) {
            element.setIdAttributeNode(attr, true);
        }
    }

    public void setSecureValidation(boolean bl) {
        this.secureValidation = bl;
    }

    public void setId(String string) {
        if (string != null) {
            this.constructionElement.setAttributeNS(null, "Id", string);
            this.constructionElement.setIdAttributeNS(null, "Id", true);
        }
    }

    public String getId() {
        return this.constructionElement.getAttributeNS(null, "Id");
    }

    public void addKeyName(String string) {
        this.add(new KeyName(this.doc, string));
    }

    public void add(KeyName keyName) {
        this.constructionElement.appendChild(keyName.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public void addKeyValue(PublicKey publicKey) {
        this.add(new KeyValue(this.doc, publicKey));
    }

    public void addKeyValue(Element element) {
        this.add(new KeyValue(this.doc, element));
    }

    public void add(DSAKeyValue dSAKeyValue) {
        this.add(new KeyValue(this.doc, dSAKeyValue));
    }

    public void add(RSAKeyValue rSAKeyValue) {
        this.add(new KeyValue(this.doc, rSAKeyValue));
    }

    public void add(PublicKey publicKey) {
        this.add(new KeyValue(this.doc, publicKey));
    }

    public void add(KeyValue keyValue) {
        this.constructionElement.appendChild(keyValue.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public void addMgmtData(String string) {
        this.add(new MgmtData(this.doc, string));
    }

    public void add(MgmtData mgmtData) {
        this.constructionElement.appendChild(mgmtData.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public void add(PGPData pGPData) {
        this.constructionElement.appendChild(pGPData.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public void addRetrievalMethod(String string, Transforms transforms, String string2) {
        this.add(new RetrievalMethod(this.doc, string, transforms, string2));
    }

    public void add(RetrievalMethod retrievalMethod) {
        this.constructionElement.appendChild(retrievalMethod.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public void add(SPKIData sPKIData) {
        this.constructionElement.appendChild(sPKIData.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public void add(X509Data x509Data) {
        if (this.x509Datas == null) {
            this.x509Datas = new ArrayList<X509Data>();
        }
        this.x509Datas.add(x509Data);
        this.constructionElement.appendChild(x509Data.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public void add(EncryptedKey encryptedKey) throws XMLEncryptionException {
        if (this.encryptedKeys == null) {
            this.encryptedKeys = new ArrayList<EncryptedKey>();
        }
        this.encryptedKeys.add(encryptedKey);
        XMLCipher xMLCipher = XMLCipher.getInstance();
        this.constructionElement.appendChild(xMLCipher.martial(encryptedKey));
    }

    public void addDEREncodedKeyValue(PublicKey publicKey) throws XMLSecurityException {
        this.add(new DEREncodedKeyValue(this.doc, publicKey));
    }

    public void add(DEREncodedKeyValue dEREncodedKeyValue) {
        this.constructionElement.appendChild(dEREncodedKeyValue.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public void addKeyInfoReference(String string) throws XMLSecurityException {
        this.add(new KeyInfoReference(this.doc, string));
    }

    public void add(KeyInfoReference keyInfoReference) {
        this.constructionElement.appendChild(keyInfoReference.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public void addUnknownElement(Element element) {
        this.constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public int lengthKeyName() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyName");
    }

    public int lengthKeyValue() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
    }

    public int lengthMgmtData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "MgmtData");
    }

    public int lengthPGPData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "PGPData");
    }

    public int lengthRetrievalMethod() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
    }

    public int lengthSPKIData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "SPKIData");
    }

    public int lengthX509Data() {
        if (this.x509Datas != null) {
            return this.x509Datas.size();
        }
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public int lengthDEREncodedKeyValue() {
        return this.length("http://www.w3.org/2009/xmldsig11#", "DEREncodedKeyValue");
    }

    public int lengthKeyInfoReference() {
        return this.length("http://www.w3.org/2009/xmldsig11#", "KeyInfoReference");
    }

    public int lengthUnknownElement() {
        int n = 0;
        NodeList nodeList = this.constructionElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            ++n;
        }
        return n;
    }

    public KeyName itemKeyName(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.constructionElement.getFirstChild(), "KeyName", n);
        if (element != null) {
            return new KeyName(element, this.baseURI);
        }
        return null;
    }

    public KeyValue itemKeyValue(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.constructionElement.getFirstChild(), "KeyValue", n);
        if (element != null) {
            return new KeyValue(element, this.baseURI);
        }
        return null;
    }

    public MgmtData itemMgmtData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.constructionElement.getFirstChild(), "MgmtData", n);
        if (element != null) {
            return new MgmtData(element, this.baseURI);
        }
        return null;
    }

    public PGPData itemPGPData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.constructionElement.getFirstChild(), "PGPData", n);
        if (element != null) {
            return new PGPData(element, this.baseURI);
        }
        return null;
    }

    public RetrievalMethod itemRetrievalMethod(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.constructionElement.getFirstChild(), "RetrievalMethod", n);
        if (element != null) {
            return new RetrievalMethod(element, this.baseURI);
        }
        return null;
    }

    public SPKIData itemSPKIData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.constructionElement.getFirstChild(), "SPKIData", n);
        if (element != null) {
            return new SPKIData(element, this.baseURI);
        }
        return null;
    }

    public X509Data itemX509Data(int n) throws XMLSecurityException {
        if (this.x509Datas != null) {
            return this.x509Datas.get(n);
        }
        Element element = XMLUtils.selectDsNode(this.constructionElement.getFirstChild(), "X509Data", n);
        if (element != null) {
            return new X509Data(element, this.baseURI);
        }
        return null;
    }

    public EncryptedKey itemEncryptedKey(int n) throws XMLSecurityException {
        if (this.encryptedKeys != null) {
            return this.encryptedKeys.get(n);
        }
        Element element = XMLUtils.selectXencNode(this.constructionElement.getFirstChild(), "EncryptedKey", n);
        if (element != null) {
            XMLCipher xMLCipher = XMLCipher.getInstance();
            xMLCipher.init(4, null);
            return xMLCipher.loadEncryptedKey(element);
        }
        return null;
    }

    public DEREncodedKeyValue itemDEREncodedKeyValue(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDs11Node(this.constructionElement.getFirstChild(), "DEREncodedKeyValue", n);
        if (element != null) {
            return new DEREncodedKeyValue(element, this.baseURI);
        }
        return null;
    }

    public KeyInfoReference itemKeyInfoReference(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDs11Node(this.constructionElement.getFirstChild(), "KeyInfoReference", n);
        if (element != null) {
            return new KeyInfoReference(element, this.baseURI);
        }
        return null;
    }

    public Element itemUnknownElement(int n) {
        NodeList nodeList = this.constructionElement.getChildNodes();
        int n2 = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || ++n2 != n) continue;
            return (Element)node;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.constructionElement.getFirstChild() == null;
    }

    public boolean containsKeyName() {
        return this.lengthKeyName() > 0;
    }

    public boolean containsKeyValue() {
        return this.lengthKeyValue() > 0;
    }

    public boolean containsMgmtData() {
        return this.lengthMgmtData() > 0;
    }

    public boolean containsPGPData() {
        return this.lengthPGPData() > 0;
    }

    public boolean containsRetrievalMethod() {
        return this.lengthRetrievalMethod() > 0;
    }

    public boolean containsSPKIData() {
        return this.lengthSPKIData() > 0;
    }

    public boolean containsUnknownElement() {
        return this.lengthUnknownElement() > 0;
    }

    public boolean containsX509Data() {
        return this.lengthX509Data() > 0;
    }

    public boolean containsDEREncodedKeyValue() {
        return this.lengthDEREncodedKeyValue() > 0;
    }

    public boolean containsKeyInfoReference() {
        return this.lengthKeyInfoReference() > 0;
    }

    public PublicKey getPublicKey() throws KeyResolverException {
        PublicKey publicKey = this.getPublicKeyFromInternalResolvers();
        if (publicKey != null) {
            if (log.isDebugEnabled()) {
                log.debug("I could find a key using the per-KeyInfo key resolvers");
            }
            return publicKey;
        }
        if (log.isDebugEnabled()) {
            log.debug("I couldn't find a key using the per-KeyInfo key resolvers");
        }
        if ((publicKey = this.getPublicKeyFromStaticResolvers()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("I could find a key using the system-wide key resolvers");
            }
            return publicKey;
        }
        if (log.isDebugEnabled()) {
            log.debug("I couldn't find a key using the system-wide key resolvers");
        }
        return null;
    }

    PublicKey getPublicKeyFromStaticResolvers() throws KeyResolverException {
        Iterator<KeyResolverSpi> iterator = KeyResolver.iterator();
        while (iterator.hasNext()) {
            KeyResolverSpi keyResolverSpi = iterator.next();
            keyResolverSpi.setSecureValidation(this.secureValidation);
            String string = this.getBaseURI();
            for (Node node = this.constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                for (StorageResolver storageResolver : this.storageResolvers) {
                    PublicKey publicKey = keyResolverSpi.engineLookupAndResolvePublicKey((Element)node, string, storageResolver);
                    if (publicKey == null) continue;
                    return publicKey;
                }
            }
        }
        return null;
    }

    PublicKey getPublicKeyFromInternalResolvers() throws KeyResolverException {
        for (KeyResolverSpi keyResolverSpi : this.internalKeyResolvers) {
            if (log.isDebugEnabled()) {
                log.debug("Try " + keyResolverSpi.getClass().getName());
            }
            keyResolverSpi.setSecureValidation(this.secureValidation);
            String string = this.getBaseURI();
            for (Node node = this.constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                for (StorageResolver storageResolver : this.storageResolvers) {
                    PublicKey publicKey = keyResolverSpi.engineLookupAndResolvePublicKey((Element)node, string, storageResolver);
                    if (publicKey == null) continue;
                    return publicKey;
                }
            }
        }
        return null;
    }

    public X509Certificate getX509Certificate() throws KeyResolverException {
        X509Certificate x509Certificate = this.getX509CertificateFromInternalResolvers();
        if (x509Certificate != null) {
            if (log.isDebugEnabled()) {
                log.debug("I could find a X509Certificate using the per-KeyInfo key resolvers");
            }
            return x509Certificate;
        }
        if (log.isDebugEnabled()) {
            log.debug("I couldn't find a X509Certificate using the per-KeyInfo key resolvers");
        }
        if ((x509Certificate = this.getX509CertificateFromStaticResolvers()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("I could find a X509Certificate using the system-wide key resolvers");
            }
            return x509Certificate;
        }
        if (log.isDebugEnabled()) {
            log.debug("I couldn't find a X509Certificate using the system-wide key resolvers");
        }
        return null;
    }

    X509Certificate getX509CertificateFromStaticResolvers() throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Start getX509CertificateFromStaticResolvers() with " + KeyResolver.length() + " resolvers");
        }
        String string = this.getBaseURI();
        Iterator<KeyResolverSpi> iterator = KeyResolver.iterator();
        while (iterator.hasNext()) {
            KeyResolverSpi keyResolverSpi = iterator.next();
            keyResolverSpi.setSecureValidation(this.secureValidation);
            X509Certificate x509Certificate = this.applyCurrentResolver(string, keyResolverSpi);
            if (x509Certificate == null) continue;
            return x509Certificate;
        }
        return null;
    }

    private X509Certificate applyCurrentResolver(String string, KeyResolverSpi keyResolverSpi) throws KeyResolverException {
        for (Node node = this.constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            for (StorageResolver storageResolver : this.storageResolvers) {
                X509Certificate x509Certificate = keyResolverSpi.engineLookupResolveX509Certificate((Element)node, string, storageResolver);
                if (x509Certificate == null) continue;
                return x509Certificate;
            }
        }
        return null;
    }

    X509Certificate getX509CertificateFromInternalResolvers() throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Start getX509CertificateFromInternalResolvers() with " + this.lengthInternalKeyResolver() + " resolvers");
        }
        String string = this.getBaseURI();
        for (KeyResolverSpi keyResolverSpi : this.internalKeyResolvers) {
            if (log.isDebugEnabled()) {
                log.debug("Try " + keyResolverSpi.getClass().getName());
            }
            keyResolverSpi.setSecureValidation(this.secureValidation);
            X509Certificate x509Certificate = this.applyCurrentResolver(string, keyResolverSpi);
            if (x509Certificate == null) continue;
            return x509Certificate;
        }
        return null;
    }

    public SecretKey getSecretKey() throws KeyResolverException {
        SecretKey secretKey = this.getSecretKeyFromInternalResolvers();
        if (secretKey != null) {
            if (log.isDebugEnabled()) {
                log.debug("I could find a secret key using the per-KeyInfo key resolvers");
            }
            return secretKey;
        }
        if (log.isDebugEnabled()) {
            log.debug("I couldn't find a secret key using the per-KeyInfo key resolvers");
        }
        if ((secretKey = this.getSecretKeyFromStaticResolvers()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("I could find a secret key using the system-wide key resolvers");
            }
            return secretKey;
        }
        if (log.isDebugEnabled()) {
            log.debug("I couldn't find a secret key using the system-wide key resolvers");
        }
        return null;
    }

    SecretKey getSecretKeyFromStaticResolvers() throws KeyResolverException {
        Iterator<KeyResolverSpi> iterator = KeyResolver.iterator();
        while (iterator.hasNext()) {
            KeyResolverSpi keyResolverSpi = iterator.next();
            keyResolverSpi.setSecureValidation(this.secureValidation);
            String string = this.getBaseURI();
            for (Node node = this.constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                for (StorageResolver storageResolver : this.storageResolvers) {
                    SecretKey secretKey = keyResolverSpi.engineLookupAndResolveSecretKey((Element)node, string, storageResolver);
                    if (secretKey == null) continue;
                    return secretKey;
                }
            }
        }
        return null;
    }

    SecretKey getSecretKeyFromInternalResolvers() throws KeyResolverException {
        for (KeyResolverSpi keyResolverSpi : this.internalKeyResolvers) {
            if (log.isDebugEnabled()) {
                log.debug("Try " + keyResolverSpi.getClass().getName());
            }
            keyResolverSpi.setSecureValidation(this.secureValidation);
            String string = this.getBaseURI();
            for (Node node = this.constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                for (StorageResolver storageResolver : this.storageResolvers) {
                    SecretKey secretKey = keyResolverSpi.engineLookupAndResolveSecretKey((Element)node, string, storageResolver);
                    if (secretKey == null) continue;
                    return secretKey;
                }
            }
        }
        return null;
    }

    public PrivateKey getPrivateKey() throws KeyResolverException {
        PrivateKey privateKey = this.getPrivateKeyFromInternalResolvers();
        if (privateKey != null) {
            if (log.isDebugEnabled()) {
                log.debug("I could find a private key using the per-KeyInfo key resolvers");
            }
            return privateKey;
        }
        if (log.isDebugEnabled()) {
            log.debug("I couldn't find a secret key using the per-KeyInfo key resolvers");
        }
        if ((privateKey = this.getPrivateKeyFromStaticResolvers()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("I could find a private key using the system-wide key resolvers");
            }
            return privateKey;
        }
        if (log.isDebugEnabled()) {
            log.debug("I couldn't find a private key using the system-wide key resolvers");
        }
        return null;
    }

    PrivateKey getPrivateKeyFromStaticResolvers() throws KeyResolverException {
        Iterator<KeyResolverSpi> iterator = KeyResolver.iterator();
        while (iterator.hasNext()) {
            KeyResolverSpi keyResolverSpi = iterator.next();
            keyResolverSpi.setSecureValidation(this.secureValidation);
            String string = this.getBaseURI();
            for (Node node = this.constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                PrivateKey privateKey;
                if (node.getNodeType() != 1 || (privateKey = keyResolverSpi.engineLookupAndResolvePrivateKey((Element)node, string, null)) == null) continue;
                return privateKey;
            }
        }
        return null;
    }

    PrivateKey getPrivateKeyFromInternalResolvers() throws KeyResolverException {
        for (KeyResolverSpi keyResolverSpi : this.internalKeyResolvers) {
            if (log.isDebugEnabled()) {
                log.debug("Try " + keyResolverSpi.getClass().getName());
            }
            keyResolverSpi.setSecureValidation(this.secureValidation);
            String string = this.getBaseURI();
            for (Node node = this.constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                PrivateKey privateKey;
                if (node.getNodeType() != 1 || (privateKey = keyResolverSpi.engineLookupAndResolvePrivateKey((Element)node, string, null)) == null) continue;
                return privateKey;
            }
        }
        return null;
    }

    public void registerInternalKeyResolver(KeyResolverSpi keyResolverSpi) {
        this.internalKeyResolvers.add(keyResolverSpi);
    }

    int lengthInternalKeyResolver() {
        return this.internalKeyResolvers.size();
    }

    KeyResolverSpi itemInternalKeyResolver(int n) {
        return this.internalKeyResolvers.get(n);
    }

    public void addStorageResolver(StorageResolver storageResolver) {
        if (this.storageResolvers == nullList) {
            this.storageResolvers = new ArrayList<StorageResolver>();
        }
        this.storageResolvers.add(storageResolver);
    }

    public String getBaseLocalName() {
        return "KeyInfo";
    }

    static {
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(null);
        nullList = Collections.unmodifiableList(arrayList);
    }
}

