/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import org.apache.xml.security.utils.I18n;

public class XMLSecurityRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected String msgID;

    public XMLSecurityRuntimeException() {
        super("Missing message string");
        this.msgID = null;
    }

    public XMLSecurityRuntimeException(String string) {
        super(I18n.getExceptionMessage(string));
        this.msgID = string;
    }

    public XMLSecurityRuntimeException(String string, Object[] objectArray) {
        super(MessageFormat.format(I18n.getExceptionMessage(string), objectArray));
        this.msgID = string;
    }

    public XMLSecurityRuntimeException(Exception exception) {
        super("Missing message ID to locate message string in resource bundle \"org/apache/xml/security/resource/xmlsecurity\". Original Exception was a " + exception.getClass().getName() + " and message " + exception.getMessage(), exception);
    }

    public XMLSecurityRuntimeException(String string, Exception exception) {
        super(I18n.getExceptionMessage(string, exception), exception);
        this.msgID = string;
    }

    public XMLSecurityRuntimeException(String string, Object[] objectArray, Exception exception) {
        super(MessageFormat.format(I18n.getExceptionMessage(string), objectArray));
        this.msgID = string;
    }

    public String getMsgID() {
        if (this.msgID == null) {
            return "Missing message ID";
        }
        return this.msgID;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = super.getLocalizedMessage();
        string2 = string2 != null ? string + ": " + string2 : string;
        if (this.getCause() != null) {
            string2 = string2 + "\nOriginal Exception was " + this.getCause().toString();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace(System.err);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
    }

    public Exception getOriginalException() {
        if (this.getCause() instanceof Exception) {
            return (Exception)this.getCause();
        }
        return null;
    }
}

