/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.encryption.CipherData;
import org.apache.xml.security.encryption.CipherReference;
import org.apache.xml.security.encryption.EncryptedType;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.w3c.dom.Attr;

public class XMLCipherInput {
    private static Log logger = LogFactory.getLog(XMLCipherInput.class);
    private CipherData cipherData;
    private int mode;
    private boolean secureValidation;

    public XMLCipherInput(CipherData cipherData) throws XMLEncryptionException {
        this.cipherData = cipherData;
        this.mode = 2;
        if (this.cipherData == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
    }

    public XMLCipherInput(EncryptedType encryptedType) throws XMLEncryptionException {
        this.cipherData = encryptedType == null ? null : encryptedType.getCipherData();
        this.mode = 2;
        if (this.cipherData == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
    }

    public void setSecureValidation(boolean bl) {
        this.secureValidation = bl;
    }

    public byte[] getBytes() throws XMLEncryptionException {
        if (this.mode == 2) {
            return this.getDecryptBytes();
        }
        return null;
    }

    private byte[] getDecryptBytes() throws XMLEncryptionException {
        String string = null;
        if (this.cipherData.getDataType() == 2) {
            Object object;
            if (logger.isDebugEnabled()) {
                logger.debug("Found a reference type CipherData");
            }
            CipherReference cipherReference = this.cipherData.getCipherReference();
            Attr attr = cipherReference.getURIAsAttr();
            XMLSignatureInput xMLSignatureInput = null;
            try {
                object = ResourceResolver.getInstance(attr, null, this.secureValidation);
                xMLSignatureInput = ((ResourceResolver)object).resolve(attr, null);
            }
            catch (ResourceResolverException resourceResolverException) {
                throw new XMLEncryptionException("empty", resourceResolverException);
            }
            if (xMLSignatureInput != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Managed to resolve URI \"" + cipherReference.getURI() + "\"");
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Failed to resolve URI \"" + cipherReference.getURI() + "\"");
            }
            if ((object = cipherReference.getTransforms()) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Have transforms in cipher reference");
                }
                try {
                    Transforms transforms = object.getDSTransforms();
                    transforms.setSecureValidation(this.secureValidation);
                    xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
                }
                catch (TransformationException transformationException) {
                    throw new XMLEncryptionException("empty", transformationException);
                }
            }
            try {
                return xMLSignatureInput.getBytes();
            }
            catch (IOException iOException) {
                throw new XMLEncryptionException("empty", iOException);
            }
            catch (CanonicalizationException canonicalizationException) {
                throw new XMLEncryptionException("empty", canonicalizationException);
            }
        }
        if (this.cipherData.getDataType() != 1) {
            throw new XMLEncryptionException("CipherData.getDataType() returned unexpected value");
        }
        string = this.cipherData.getCipherValue().getValue();
        if (logger.isDebugEnabled()) {
            logger.debug("Encrypted octets:\n" + string);
        }
        try {
            return Base64.decode(string);
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new XMLEncryptionException("empty", base64DecodingException);
        }
    }
}

