/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.encryption.AgreementMethod;
import org.apache.xml.security.encryption.CipherData;
import org.apache.xml.security.encryption.CipherReference;
import org.apache.xml.security.encryption.CipherValue;
import org.apache.xml.security.encryption.DocumentSerializer;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.EncryptionMethod;
import org.apache.xml.security.encryption.EncryptionProperties;
import org.apache.xml.security.encryption.EncryptionProperty;
import org.apache.xml.security.encryption.Reference;
import org.apache.xml.security.encryption.ReferenceList;
import org.apache.xml.security.encryption.Serializer;
import org.apache.xml.security.encryption.Transforms;
import org.apache.xml.security.encryption.XMLCipherInput;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.keyresolver.implementations.EncryptedKeyResolver;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLCipher {
    private static Log log = LogFactory.getLog(XMLCipher.class);
    public static final String TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES_128 = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES_256 = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String AES_192 = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String AES_128_GCM = "http://www.w3.org/2009/xmlenc11#aes128-gcm";
    public static final String AES_192_GCM = "http://www.w3.org/2009/xmlenc11#aes192-gcm";
    public static final String AES_256_GCM = "http://www.w3.org/2009/xmlenc11#aes256-gcm";
    public static final String RSA_v1dot5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String RSA_OAEP = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    public static final String RSA_OAEP_11 = "http://www.w3.org/2009/xmlenc11#rsa-oaep";
    public static final String DIFFIE_HELLMAN = "http://www.w3.org/2001/04/xmlenc#dh";
    public static final String TRIPLEDES_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String AES_128_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String AES_256_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    public static final String AES_192_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String RIPEMD_160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    public static final String XML_DSIG = "http://www.w3.org/2000/09/xmldsig#";
    public static final String N14C_XML = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String N14C_XML_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String EXCL_XML_N14C = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String EXCL_XML_N14C_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String PHYSICAL_XML_N14C = "http://santuario.apache.org/c14n/physical";
    public static final String BASE64_ENCODING = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int UNWRAP_MODE = 4;
    public static final int WRAP_MODE = 3;
    private static final String ENC_ALGORITHMS = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2009/xmlenc11#rsa-oaep\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\nhttp://www.w3.org/2009/xmlenc11#aes128-gcm\nhttp://www.w3.org/2009/xmlenc11#aes192-gcm\nhttp://www.w3.org/2009/xmlenc11#aes256-gcm\n";
    private Cipher contextCipher;
    private int cipherMode = Integer.MIN_VALUE;
    private String algorithm = null;
    private String requestedJCEProvider = null;
    private Canonicalizer canon;
    private Document contextDocument;
    private Factory factory;
    private Serializer serializer;
    private Key key;
    private Key kek;
    private EncryptedKey ek;
    private EncryptedData ed;
    private SecureRandom random;
    private boolean secureValidation;
    private String digestAlg;
    private List<KeyResolverSpi> internalKeyResolvers;

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
        serializer.setCanonicalizer(this.canon);
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    private XMLCipher(String string, String string2, String string3, String string4) throws XMLEncryptionException {
        if (log.isDebugEnabled()) {
            log.debug("Constructing XMLCipher...");
        }
        this.factory = new Factory();
        this.algorithm = string;
        this.requestedJCEProvider = string2;
        this.digestAlg = string4;
        try {
            this.canon = string3 == null ? Canonicalizer.getInstance(PHYSICAL_XML_N14C) : Canonicalizer.getInstance(string3);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLEncryptionException("empty", invalidCanonicalizerException);
        }
        if (this.serializer == null) {
            this.serializer = new DocumentSerializer();
        }
        this.serializer.setCanonicalizer(this.canon);
        if (string != null) {
            this.contextCipher = this.constructCipher(string, string4);
        }
    }

    private static boolean isValidEncryptionAlgorithm(String string) {
        return string.equals(TRIPLEDES) || string.equals(AES_128) || string.equals(AES_256) || string.equals(AES_192) || string.equals(AES_128_GCM) || string.equals(AES_192_GCM) || string.equals(AES_256_GCM) || string.equals(RSA_v1dot5) || string.equals(RSA_OAEP) || string.equals(RSA_OAEP_11) || string.equals(TRIPLEDES_KeyWrap) || string.equals(AES_128_KeyWrap) || string.equals(AES_256_KeyWrap) || string.equals(AES_192_KeyWrap);
    }

    private static void validateTransformation(String string) {
        if (null == string) {
            throw new NullPointerException("Transformation unexpectedly null...");
        }
        if (!XMLCipher.isValidEncryptionAlgorithm(string)) {
            log.warn("Algorithm non-standard, expected one of http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2009/xmlenc11#rsa-oaep\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\nhttp://www.w3.org/2009/xmlenc11#aes128-gcm\nhttp://www.w3.org/2009/xmlenc11#aes192-gcm\nhttp://www.w3.org/2009/xmlenc11#aes256-gcm\n");
        }
    }

    public static XMLCipher getInstance(String string) throws XMLEncryptionException {
        if (log.isDebugEnabled()) {
            log.debug("Getting XMLCipher with transformation");
        }
        XMLCipher.validateTransformation(string);
        return new XMLCipher(string, null, null, null);
    }

    public static XMLCipher getInstance(String string, String string2) throws XMLEncryptionException {
        if (log.isDebugEnabled()) {
            log.debug("Getting XMLCipher with transformation and c14n algorithm");
        }
        XMLCipher.validateTransformation(string);
        return new XMLCipher(string, null, string2, null);
    }

    public static XMLCipher getInstance(String string, String string2, String string3) throws XMLEncryptionException {
        if (log.isDebugEnabled()) {
            log.debug("Getting XMLCipher with transformation and c14n algorithm");
        }
        XMLCipher.validateTransformation(string);
        return new XMLCipher(string, null, string2, string3);
    }

    public static XMLCipher getProviderInstance(String string, String string2) throws XMLEncryptionException {
        if (log.isDebugEnabled()) {
            log.debug("Getting XMLCipher with transformation and provider");
        }
        if (null == string2) {
            throw new NullPointerException("Provider unexpectedly null..");
        }
        XMLCipher.validateTransformation(string);
        return new XMLCipher(string, string2, null, null);
    }

    public static XMLCipher getProviderInstance(String string, String string2, String string3) throws XMLEncryptionException {
        if (log.isDebugEnabled()) {
            log.debug("Getting XMLCipher with transformation, provider and c14n algorithm");
        }
        if (null == string2) {
            throw new NullPointerException("Provider unexpectedly null..");
        }
        XMLCipher.validateTransformation(string);
        return new XMLCipher(string, string2, string3, null);
    }

    public static XMLCipher getProviderInstance(String string, String string2, String string3, String string4) throws XMLEncryptionException {
        if (log.isDebugEnabled()) {
            log.debug("Getting XMLCipher with transformation, provider and c14n algorithm");
        }
        if (null == string2) {
            throw new NullPointerException("Provider unexpectedly null..");
        }
        XMLCipher.validateTransformation(string);
        return new XMLCipher(string, string2, string3, string4);
    }

    public static XMLCipher getInstance() throws XMLEncryptionException {
        if (log.isDebugEnabled()) {
            log.debug("Getting XMLCipher with no arguments");
        }
        return new XMLCipher(null, null, null, null);
    }

    public static XMLCipher getProviderInstance(String string) throws XMLEncryptionException {
        if (log.isDebugEnabled()) {
            log.debug("Getting XMLCipher with provider");
        }
        return new XMLCipher(null, string, null, null);
    }

    public void init(int n, Key key) throws XMLEncryptionException {
        if (log.isDebugEnabled()) {
            log.debug("Initializing XMLCipher...");
        }
        this.ek = null;
        this.ed = null;
        switch (n) {
            case 1: {
                if (log.isDebugEnabled()) {
                    log.debug("opmode = ENCRYPT_MODE");
                }
                this.ed = this.createEncryptedData(1, "NO VALUE YET");
                break;
            }
            case 2: {
                if (!log.isDebugEnabled()) break;
                log.debug("opmode = DECRYPT_MODE");
                break;
            }
            case 3: {
                if (log.isDebugEnabled()) {
                    log.debug("opmode = WRAP_MODE");
                }
                this.ek = this.createEncryptedKey(1, "NO VALUE YET");
                break;
            }
            case 4: {
                if (!log.isDebugEnabled()) break;
                log.debug("opmode = UNWRAP_MODE");
                break;
            }
            default: {
                log.error("Mode unexpectedly invalid");
                throw new XMLEncryptionException("Invalid mode in init");
            }
        }
        this.cipherMode = n;
        this.key = key;
    }

    public void setSecureValidation(boolean bl) {
        this.secureValidation = bl;
    }

    public void registerInternalKeyResolver(KeyResolverSpi keyResolverSpi) {
        if (this.internalKeyResolvers == null) {
            this.internalKeyResolvers = new ArrayList<KeyResolverSpi>();
        }
        this.internalKeyResolvers.add(keyResolverSpi);
    }

    public EncryptedData getEncryptedData() {
        if (log.isDebugEnabled()) {
            log.debug("Returning EncryptedData");
        }
        return this.ed;
    }

    public EncryptedKey getEncryptedKey() {
        if (log.isDebugEnabled()) {
            log.debug("Returning EncryptedKey");
        }
        return this.ek;
    }

    public void setKEK(Key key) {
        this.kek = key;
    }

    public Element martial(EncryptedData encryptedData) {
        return this.factory.toElement(encryptedData);
    }

    public Element martial(Document document, EncryptedData encryptedData) {
        this.contextDocument = document;
        return this.factory.toElement(encryptedData);
    }

    public Element martial(EncryptedKey encryptedKey) {
        return this.factory.toElement(encryptedKey);
    }

    public Element martial(Document document, EncryptedKey encryptedKey) {
        this.contextDocument = document;
        return this.factory.toElement(encryptedKey);
    }

    public Element martial(ReferenceList referenceList) {
        return this.factory.toElement(referenceList);
    }

    public Element martial(Document document, ReferenceList referenceList) {
        this.contextDocument = document;
        return this.factory.toElement(referenceList);
    }

    private Document encryptElement(Element element) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Encrypting element...");
        }
        if (null == element) {
            log.error("Element unexpectedly null...");
        }
        if (this.cipherMode != 1 && log.isDebugEnabled()) {
            log.debug("XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        if (this.algorithm == null) {
            throw new XMLEncryptionException("XMLCipher instance without transformation specified");
        }
        this.encryptData(this.contextDocument, element, false);
        Element element2 = this.factory.toElement(this.ed);
        Node node = element.getParentNode();
        node.replaceChild(element2, element);
        return this.contextDocument;
    }

    private Document encryptElementContent(Element element) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Encrypting element content...");
        }
        if (null == element) {
            log.error("Element unexpectedly null...");
        }
        if (this.cipherMode != 1 && log.isDebugEnabled()) {
            log.debug("XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        if (this.algorithm == null) {
            throw new XMLEncryptionException("XMLCipher instance without transformation specified");
        }
        this.encryptData(this.contextDocument, element, true);
        Element element2 = this.factory.toElement(this.ed);
        XMLCipher.removeContent(element);
        element.appendChild(element2);
        return this.contextDocument;
    }

    public Document doFinal(Document document, Document document2) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Processing source document...");
        }
        if (null == document) {
            log.error("Context document unexpectedly null...");
        }
        if (null == document2) {
            log.error("Source document unexpectedly null...");
        }
        this.contextDocument = document;
        Document document3 = null;
        switch (this.cipherMode) {
            case 2: {
                document3 = this.decryptElement(document2.getDocumentElement());
                break;
            }
            case 1: {
                document3 = this.encryptElement(document2.getDocumentElement());
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new XMLEncryptionException("empty", new IllegalStateException());
            }
        }
        return document3;
    }

    public Document doFinal(Document document, Element element) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Processing source element...");
        }
        if (null == document) {
            log.error("Context document unexpectedly null...");
        }
        if (null == element) {
            log.error("Source element unexpectedly null...");
        }
        this.contextDocument = document;
        Document document2 = null;
        switch (this.cipherMode) {
            case 2: {
                document2 = this.decryptElement(element);
                break;
            }
            case 1: {
                document2 = this.encryptElement(element);
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new XMLEncryptionException("empty", new IllegalStateException());
            }
        }
        return document2;
    }

    public Document doFinal(Document document, Element element, boolean bl) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Processing source element...");
        }
        if (null == document) {
            log.error("Context document unexpectedly null...");
        }
        if (null == element) {
            log.error("Source element unexpectedly null...");
        }
        this.contextDocument = document;
        Document document2 = null;
        switch (this.cipherMode) {
            case 2: {
                if (bl) {
                    document2 = this.decryptElementContent(element);
                    break;
                }
                document2 = this.decryptElement(element);
                break;
            }
            case 1: {
                if (bl) {
                    document2 = this.encryptElementContent(element);
                    break;
                }
                document2 = this.encryptElement(element);
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new XMLEncryptionException("empty", new IllegalStateException());
            }
        }
        return document2;
    }

    public EncryptedData encryptData(Document document, Element element) throws Exception {
        return this.encryptData(document, element, false);
    }

    public EncryptedData encryptData(Document document, String string, InputStream inputStream) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Encrypting element...");
        }
        if (null == document) {
            log.error("Context document unexpectedly null...");
        }
        if (null == inputStream) {
            log.error("Serialized data unexpectedly null...");
        }
        if (this.cipherMode != 1 && log.isDebugEnabled()) {
            log.debug("XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        return this.encryptData(document, null, string, inputStream);
    }

    public EncryptedData encryptData(Document document, Element element, boolean bl) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Encrypting element...");
        }
        if (null == document) {
            log.error("Context document unexpectedly null...");
        }
        if (null == element) {
            log.error("Element unexpectedly null...");
        }
        if (this.cipherMode != 1 && log.isDebugEnabled()) {
            log.debug("XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        if (bl) {
            return this.encryptData(document, element, "http://www.w3.org/2001/04/xmlenc#Content", null);
        }
        return this.encryptData(document, element, "http://www.w3.org/2001/04/xmlenc#Element", null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EncryptedData encryptData(Document document, Element element, String string, InputStream inputStream) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.contextDocument = document;
        if (this.algorithm == null) {
            throw new XMLEncryptionException("XMLCipher instance without transformation specified");
        }
        byte[] byArray = null;
        if (inputStream == null) {
            if (string.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                object4 = element.getChildNodes();
                if (null == object4) {
                    Object[] objectArray = new Object[]{"Element has no content."};
                    throw new XMLEncryptionException("empty", objectArray);
                }
                byArray = this.serializer.serializeToByteArray((NodeList)object4);
            } else {
                byArray = this.serializer.serializeToByteArray(element);
            }
            if (log.isDebugEnabled()) {
                log.debug("Serialized octets:\n" + new String(byArray, "UTF-8"));
            }
        }
        object4 = null;
        Cipher cipher = this.contextCipher == null ? this.constructCipher(this.algorithm, null) : this.contextCipher;
        try {
            if (AES_128_GCM.equals(this.algorithm) || AES_192_GCM.equals(this.algorithm) || AES_256_GCM.equals(this.algorithm)) {
                if (this.random == null) {
                    this.random = SecureRandom.getInstance("SHA1PRNG");
                }
                byte[] byArray2 = new byte[12];
                this.random.nextBytes(byArray2);
                object3 = new IvParameterSpec(byArray2);
                cipher.init(this.cipherMode, this.key, (AlgorithmParameterSpec)object3);
            } else {
                cipher.init(this.cipherMode, this.key);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException("empty", invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLEncryptionException("empty", noSuchAlgorithmException);
        }
        try {
            if (inputStream != null) {
                int n;
                object3 = new byte[8192];
                object2 = new ByteArrayOutputStream();
                while ((n = inputStream.read((byte[])object3)) != -1) {
                    object = cipher.update((byte[])object3, 0, n);
                    ((OutputStream)object2).write((byte[])object);
                }
                ((OutputStream)object2).write(cipher.doFinal());
                object4 = ((ByteArrayOutputStream)object2).toByteArray();
            } else {
                object4 = cipher.doFinal(byArray);
                if (log.isDebugEnabled()) {
                    log.debug("Expected cipher.outputSize = " + Integer.toString(cipher.getOutputSize(byArray.length)));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Actual cipher.outputSize = " + Integer.toString(((Object)object4).length));
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLEncryptionException("empty", illegalStateException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new XMLEncryptionException("empty", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new XMLEncryptionException("empty", badPaddingException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XMLEncryptionException("empty", unsupportedEncodingException);
        }
        byte[] byArray3 = cipher.getIV();
        object3 = new byte[byArray3.length + ((Object)object4).length];
        System.arraycopy(byArray3, 0, object3, 0, byArray3.length);
        System.arraycopy(object4, 0, object3, byArray3.length, ((Object)object4).length);
        object2 = Base64.encode((byte[])object3);
        if (log.isDebugEnabled()) {
            log.debug("Encrypted octets:\n" + (String)object2);
            log.debug("Encrypted octets length = " + ((String)object2).length());
        }
        try {
            object = this.ed.getCipherData();
            CipherValue cipherValue = object.getCipherValue();
            cipherValue.setValue((String)object2);
            if (string != null) {
                this.ed.setType(new URI(string).toString());
            }
            EncryptionMethod encryptionMethod = this.factory.newEncryptionMethod(new URI(this.algorithm).toString());
            encryptionMethod.setDigestAlgorithm(this.digestAlg);
            this.ed.setEncryptionMethod(encryptionMethod);
            return this.ed;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XMLEncryptionException("empty", uRISyntaxException);
        }
    }

    public EncryptedData loadEncryptedData(Document document, Element element) throws XMLEncryptionException {
        if (log.isDebugEnabled()) {
            log.debug("Loading encrypted element...");
        }
        if (null == document) {
            throw new NullPointerException("Context document unexpectedly null...");
        }
        if (null == element) {
            throw new NullPointerException("Element unexpectedly null...");
        }
        if (this.cipherMode != 2) {
            throw new XMLEncryptionException("XMLCipher unexpectedly not in DECRYPT_MODE...");
        }
        this.contextDocument = document;
        this.ed = this.factory.newEncryptedData(element);
        return this.ed;
    }

    public EncryptedKey loadEncryptedKey(Document document, Element element) throws XMLEncryptionException {
        if (log.isDebugEnabled()) {
            log.debug("Loading encrypted key...");
        }
        if (null == document) {
            throw new NullPointerException("Context document unexpectedly null...");
        }
        if (null == element) {
            throw new NullPointerException("Element unexpectedly null...");
        }
        if (this.cipherMode != 4 && this.cipherMode != 2) {
            throw new XMLEncryptionException("XMLCipher unexpectedly not in UNWRAP_MODE or DECRYPT_MODE...");
        }
        this.contextDocument = document;
        this.ek = this.factory.newEncryptedKey(element);
        return this.ek;
    }

    public EncryptedKey loadEncryptedKey(Element element) throws XMLEncryptionException {
        return this.loadEncryptedKey(element.getOwnerDocument(), element);
    }

    public EncryptedKey encryptKey(Document document, Key key) throws XMLEncryptionException {
        return this.encryptKey(document, key, null, null);
    }

    public EncryptedKey encryptKey(Document document, Key key, String string, byte[] byArray) throws XMLEncryptionException {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug("Encrypting key ...");
        }
        if (null == key) {
            log.error("Key unexpectedly null...");
        }
        if (this.cipherMode != 3) {
            log.debug("XMLCipher unexpectedly not in WRAP_MODE...");
        }
        if (this.algorithm == null) {
            throw new XMLEncryptionException("XMLCipher instance without transformation specified");
        }
        this.contextDocument = document;
        byte[] byArray2 = null;
        Cipher cipher = this.contextCipher == null ? this.constructCipher(this.algorithm, null) : this.contextCipher;
        try {
            object = this.constructOAEPParameters(this.algorithm, this.digestAlg, string, byArray);
            if (object == null) {
                cipher.init(3, this.key);
            } else {
                cipher.init(3, this.key, (AlgorithmParameterSpec)object);
            }
            byArray2 = cipher.wrap(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException("empty", invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new XMLEncryptionException("empty", illegalBlockSizeException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException("empty", invalidAlgorithmParameterException);
        }
        object = Base64.encode(byArray2);
        if (log.isDebugEnabled()) {
            log.debug("Encrypted key octets:\n" + (String)object);
            log.debug("Encrypted key octets length = " + ((String)object).length());
        }
        CipherValue cipherValue = this.ek.getCipherData().getCipherValue();
        cipherValue.setValue((String)object);
        try {
            EncryptionMethod encryptionMethod = this.factory.newEncryptionMethod(new URI(this.algorithm).toString());
            encryptionMethod.setDigestAlgorithm(this.digestAlg);
            encryptionMethod.setMGFAlgorithm(string);
            encryptionMethod.setOAEPparams(byArray);
            this.ek.setEncryptionMethod(encryptionMethod);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XMLEncryptionException("empty", uRISyntaxException);
        }
        return this.ek;
    }

    public Key decryptKey(EncryptedKey encryptedKey, String string) throws XMLEncryptionException {
        Key key;
        String string2;
        Object object;
        Object object2;
        if (log.isDebugEnabled()) {
            log.debug("Decrypting key from previously loaded EncryptedKey...");
        }
        if (this.cipherMode != 4 && log.isDebugEnabled()) {
            log.debug("XMLCipher unexpectedly not in UNWRAP_MODE...");
        }
        if (string == null) {
            throw new XMLEncryptionException("Cannot decrypt a key without knowing the algorithm");
        }
        if (this.key == null) {
            block17: {
                if (log.isDebugEnabled()) {
                    log.debug("Trying to find a KEK via key resolvers");
                }
                if ((object2 = encryptedKey.getKeyInfo()) != null) {
                    ((KeyInfo)object2).setSecureValidation(this.secureValidation);
                    try {
                        object = encryptedKey.getEncryptionMethod().getAlgorithm();
                        string2 = JCEMapper.getJCEKeyAlgorithmFromURI((String)object);
                        this.key = "RSA".equals(string2) ? ((KeyInfo)object2).getPrivateKey() : ((KeyInfo)object2).getSecretKey();
                    }
                    catch (Exception exception) {
                        if (!log.isDebugEnabled()) break block17;
                        log.debug(exception);
                    }
                }
            }
            if (this.key == null) {
                log.error("XMLCipher::decryptKey called without a KEK and cannot resolve");
                throw new XMLEncryptionException("Unable to decrypt without a KEK");
            }
        }
        object2 = new XMLCipherInput(encryptedKey);
        ((XMLCipherInput)object2).setSecureValidation(this.secureValidation);
        object = ((XMLCipherInput)object2).getBytes();
        string2 = JCEMapper.getJCEKeyAlgorithmFromURI(string);
        if (log.isDebugEnabled()) {
            log.debug("JCE Key Algorithm: " + string2);
        }
        Cipher cipher = this.contextCipher == null ? this.constructCipher(encryptedKey.getEncryptionMethod().getAlgorithm(), encryptedKey.getEncryptionMethod().getDigestAlgorithm()) : this.contextCipher;
        try {
            EncryptionMethod encryptionMethod = encryptedKey.getEncryptionMethod();
            OAEPParameterSpec oAEPParameterSpec = this.constructOAEPParameters(encryptionMethod.getAlgorithm(), encryptionMethod.getDigestAlgorithm(), encryptionMethod.getMGFAlgorithm(), encryptionMethod.getOAEPparams());
            if (oAEPParameterSpec == null) {
                cipher.init(4, this.key);
            } else {
                cipher.init(4, this.key, oAEPParameterSpec);
            }
            key = cipher.unwrap((byte[])object, string2, 3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException("empty", invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLEncryptionException("empty", noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException("empty", invalidAlgorithmParameterException);
        }
        if (log.isDebugEnabled()) {
            log.debug("Decryption of key type " + string + " OK");
        }
        return key;
    }

    private OAEPParameterSpec constructOAEPParameters(String string, String string2, String string3, byte[] byArray) {
        if (RSA_OAEP.equals(string) || RSA_OAEP_11.equals(string)) {
            String string4 = "SHA-1";
            if (string2 != null) {
                string4 = JCEMapper.translateURItoJCEID(string2);
            }
            PSource.PSpecified pSpecified = PSource.PSpecified.DEFAULT;
            if (byArray != null) {
                pSpecified = new PSource.PSpecified(byArray);
            }
            MGF1ParameterSpec mGF1ParameterSpec = new MGF1ParameterSpec("SHA-1");
            if (RSA_OAEP_11.equals(string)) {
                if ("http://www.w3.org/2009/xmlenc11#mgf1sha256".equals(string3)) {
                    mGF1ParameterSpec = new MGF1ParameterSpec("SHA-256");
                } else if ("http://www.w3.org/2009/xmlenc11#mgf1sha384".equals(string3)) {
                    mGF1ParameterSpec = new MGF1ParameterSpec("SHA-384");
                } else if ("http://www.w3.org/2009/xmlenc11#mgf1sha512".equals(string3)) {
                    mGF1ParameterSpec = new MGF1ParameterSpec("SHA-512");
                }
            }
            return new OAEPParameterSpec(string4, "MGF1", mGF1ParameterSpec, pSpecified);
        }
        return null;
    }

    private Cipher constructCipher(String string, String string2) throws XMLEncryptionException {
        Cipher cipher;
        String string3 = JCEMapper.translateURItoJCEID(string);
        if (log.isDebugEnabled()) {
            log.debug("JCE Algorithm = " + string3);
        }
        try {
            cipher = this.requestedJCEProvider == null ? Cipher.getInstance(string3) : Cipher.getInstance(string3, this.requestedJCEProvider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (RSA_OAEP.equals(string) && (string2 == null || SHA1.equals(string2))) {
                try {
                    cipher = this.requestedJCEProvider == null ? Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding") : Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding", this.requestedJCEProvider);
                }
                catch (Exception exception) {
                    throw new XMLEncryptionException("empty", exception);
                }
            }
            throw new XMLEncryptionException("empty", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new XMLEncryptionException("empty", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new XMLEncryptionException("empty", noSuchPaddingException);
        }
        return cipher;
    }

    public Key decryptKey(EncryptedKey encryptedKey) throws XMLEncryptionException {
        return this.decryptKey(encryptedKey, this.ed.getEncryptionMethod().getAlgorithm());
    }

    private static void removeContent(Node node) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
    }

    private Document decryptElement(Element element) throws XMLEncryptionException {
        if (log.isDebugEnabled()) {
            log.debug("Decrypting element...");
        }
        if (this.cipherMode != 2) {
            log.error("XMLCipher unexpectedly not in DECRYPT_MODE...");
        }
        byte[] byArray = this.decryptToByteArray(element);
        if (log.isDebugEnabled()) {
            log.debug("Decrypted octets:\n" + new String(byArray));
        }
        Node node = element.getParentNode();
        Node node2 = this.serializer.deserialize(byArray, node);
        if (node != null && 9 == node.getNodeType()) {
            this.contextDocument.removeChild(this.contextDocument.getDocumentElement());
            this.contextDocument.appendChild(node2);
        } else if (node != null) {
            node.replaceChild(node2, element);
        }
        return this.contextDocument;
    }

    private Document decryptElementContent(Element element) throws XMLEncryptionException {
        Element element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
        if (null == element2) {
            throw new XMLEncryptionException("No EncryptedData child element.");
        }
        return this.decryptElement(element2);
    }

    public byte[] decryptToByteArray(Element element) throws XMLEncryptionException {
        Cipher cipher;
        int n;
        Object object;
        Object object2;
        Object object3;
        if (log.isDebugEnabled()) {
            log.debug("Decrypting to ByteArray...");
        }
        if (this.cipherMode != 2) {
            log.error("XMLCipher unexpectedly not in DECRYPT_MODE...");
        }
        EncryptedData encryptedData = this.factory.newEncryptedData(element);
        if (this.key == null) {
            block21: {
                object3 = encryptedData.getKeyInfo();
                if (object3 != null) {
                    try {
                        object2 = encryptedData.getEncryptionMethod().getAlgorithm();
                        object = new EncryptedKeyResolver((String)object2, this.kek);
                        if (this.internalKeyResolvers != null) {
                            int n2 = this.internalKeyResolvers.size();
                            for (n = 0; n < n2; ++n) {
                                ((EncryptedKeyResolver)object).registerInternalKeyResolver(this.internalKeyResolvers.get(n));
                            }
                        }
                        ((KeyInfo)object3).registerInternalKeyResolver((KeyResolverSpi)object);
                        ((KeyInfo)object3).setSecureValidation(this.secureValidation);
                        this.key = ((KeyInfo)object3).getSecretKey();
                    }
                    catch (KeyResolverException keyResolverException) {
                        if (!log.isDebugEnabled()) break block21;
                        log.debug(keyResolverException);
                    }
                }
            }
            if (this.key == null) {
                log.error("XMLCipher::decryptElement called without a key and unable to resolve");
                throw new XMLEncryptionException("encryption.nokey");
            }
        }
        object3 = new XMLCipherInput(encryptedData);
        ((XMLCipherInput)object3).setSecureValidation(this.secureValidation);
        object2 = ((XMLCipherInput)object3).getBytes();
        object = JCEMapper.translateURItoJCEID(encryptedData.getEncryptionMethod().getAlgorithm());
        if (log.isDebugEnabled()) {
            log.debug("JCE Algorithm = " + (String)object);
        }
        try {
            cipher = this.requestedJCEProvider == null ? Cipher.getInstance((String)object) : Cipher.getInstance((String)object, this.requestedJCEProvider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLEncryptionException("empty", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new XMLEncryptionException("empty", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new XMLEncryptionException("empty", noSuchPaddingException);
        }
        n = cipher.getBlockSize();
        String string = encryptedData.getEncryptionMethod().getAlgorithm();
        if (AES_128_GCM.equals(string) || AES_192_GCM.equals(string) || AES_256_GCM.equals(string)) {
            n = 12;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(object2, 0, byArray, 0, n);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
        try {
            cipher.init(this.cipherMode, this.key, ivParameterSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException("empty", invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException("empty", invalidAlgorithmParameterException);
        }
        try {
            return cipher.doFinal((byte[])object2, n, ((Object)object2).length - n);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new XMLEncryptionException("empty", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new XMLEncryptionException("empty", badPaddingException);
        }
    }

    public EncryptedData createEncryptedData(int n, String string) throws XMLEncryptionException {
        EncryptedData encryptedData = null;
        CipherData cipherData = null;
        switch (n) {
            case 2: {
                CipherReference cipherReference = this.factory.newCipherReference(string);
                cipherData = this.factory.newCipherData(n);
                cipherData.setCipherReference(cipherReference);
                encryptedData = this.factory.newEncryptedData(cipherData);
                break;
            }
            case 1: {
                CipherValue cipherValue = this.factory.newCipherValue(string);
                cipherData = this.factory.newCipherData(n);
                cipherData.setCipherValue(cipherValue);
                encryptedData = this.factory.newEncryptedData(cipherData);
            }
        }
        return encryptedData;
    }

    public EncryptedKey createEncryptedKey(int n, String string) throws XMLEncryptionException {
        EncryptedKey encryptedKey = null;
        CipherData cipherData = null;
        switch (n) {
            case 2: {
                CipherReference cipherReference = this.factory.newCipherReference(string);
                cipherData = this.factory.newCipherData(n);
                cipherData.setCipherReference(cipherReference);
                encryptedKey = this.factory.newEncryptedKey(cipherData);
                break;
            }
            case 1: {
                CipherValue cipherValue = this.factory.newCipherValue(string);
                cipherData = this.factory.newCipherData(n);
                cipherData.setCipherValue(cipherValue);
                encryptedKey = this.factory.newEncryptedKey(cipherData);
            }
        }
        return encryptedKey;
    }

    public AgreementMethod createAgreementMethod(String string) {
        return this.factory.newAgreementMethod(string);
    }

    public CipherData createCipherData(int n) {
        return this.factory.newCipherData(n);
    }

    public CipherReference createCipherReference(String string) {
        return this.factory.newCipherReference(string);
    }

    public CipherValue createCipherValue(String string) {
        return this.factory.newCipherValue(string);
    }

    public EncryptionMethod createEncryptionMethod(String string) {
        return this.factory.newEncryptionMethod(string);
    }

    public EncryptionProperties createEncryptionProperties() {
        return this.factory.newEncryptionProperties();
    }

    public EncryptionProperty createEncryptionProperty() {
        return this.factory.newEncryptionProperty();
    }

    public ReferenceList createReferenceList(int n) {
        return this.factory.newReferenceList(n);
    }

    public Transforms createTransforms() {
        return this.factory.newTransforms();
    }

    public Transforms createTransforms(Document document) {
        return this.factory.newTransforms(document);
    }

    private class Factory {
        private Factory() {
        }

        AgreementMethod newAgreementMethod(String string) {
            return new AgreementMethodImpl(string);
        }

        CipherData newCipherData(int n) {
            return new CipherDataImpl(n);
        }

        CipherReference newCipherReference(String string) {
            return new CipherReferenceImpl(string);
        }

        CipherValue newCipherValue(String string) {
            return new CipherValueImpl(string);
        }

        EncryptedData newEncryptedData(CipherData cipherData) {
            return new EncryptedDataImpl(cipherData);
        }

        EncryptedKey newEncryptedKey(CipherData cipherData) {
            return new EncryptedKeyImpl(cipherData);
        }

        EncryptionMethod newEncryptionMethod(String string) {
            return new EncryptionMethodImpl(string);
        }

        EncryptionProperties newEncryptionProperties() {
            return new EncryptionPropertiesImpl();
        }

        EncryptionProperty newEncryptionProperty() {
            return new EncryptionPropertyImpl();
        }

        ReferenceList newReferenceList(int n) {
            return new ReferenceListImpl(n);
        }

        Transforms newTransforms() {
            return new TransformsImpl();
        }

        Transforms newTransforms(Document document) {
            return new TransformsImpl(document);
        }

        CipherData newCipherData(Element element) throws XMLEncryptionException {
            if (null == element) {
                throw new NullPointerException("element is null");
            }
            int n = 0;
            Element element2 = null;
            if (element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").getLength() > 0) {
                n = 1;
                element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0);
            } else if (element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference").getLength() > 0) {
                n = 2;
                element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference").item(0);
            }
            CipherData cipherData = this.newCipherData(n);
            if (n == 1) {
                cipherData.setCipherValue(this.newCipherValue(element2));
            } else if (n == 2) {
                cipherData.setCipherReference(this.newCipherReference(element2));
            }
            return cipherData;
        }

        CipherReference newCipherReference(Element element) throws XMLEncryptionException {
            Attr attr = element.getAttributeNodeNS(null, "URI");
            CipherReferenceImpl cipherReferenceImpl = new CipherReferenceImpl(attr);
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "Transforms");
            Element element2 = (Element)nodeList.item(0);
            if (element2 != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating a DSIG based Transforms element");
                }
                try {
                    cipherReferenceImpl.setTransforms(new TransformsImpl(element2));
                }
                catch (XMLSignatureException xMLSignatureException) {
                    throw new XMLEncryptionException("empty", xMLSignatureException);
                }
                catch (InvalidTransformException invalidTransformException) {
                    throw new XMLEncryptionException("empty", invalidTransformException);
                }
                catch (XMLSecurityException xMLSecurityException) {
                    throw new XMLEncryptionException("empty", xMLSecurityException);
                }
            }
            return cipherReferenceImpl;
        }

        CipherValue newCipherValue(Element element) {
            String string = XMLUtils.getFullTextChildrenFromElement(element);
            return this.newCipherValue(string);
        }

        EncryptedData newEncryptedData(Element element) throws XMLEncryptionException {
            Object object;
            Element element2;
            EncryptedData encryptedData = null;
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherData");
            Element element3 = (Element)nodeList.item(nodeList.getLength() - 1);
            CipherData cipherData = this.newCipherData(element3);
            encryptedData = this.newEncryptedData(cipherData);
            encryptedData.setId(element.getAttributeNS(null, "Id"));
            encryptedData.setType(element.getAttributeNS(null, "Type"));
            encryptedData.setMimeType(element.getAttributeNS(null, "MimeType"));
            encryptedData.setEncoding(element.getAttributeNS(null, "Encoding"));
            Element element4 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod").item(0);
            if (null != element4) {
                encryptedData.setEncryptionMethod(this.newEncryptionMethod(element4));
            }
            if (null != (element2 = (Element)element.getElementsByTagNameNS(XMLCipher.XML_DSIG, "KeyInfo").item(0))) {
                object = this.newKeyInfo(element2);
                encryptedData.setKeyInfo((KeyInfo)object);
            }
            if (null != (object = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties").item(0))) {
                encryptedData.setEncryptionProperties(this.newEncryptionProperties((Element)object));
            }
            return encryptedData;
        }

        EncryptedKey newEncryptedKey(Element element) throws XMLEncryptionException {
            Element element2;
            Element element3;
            Object object;
            Element element4;
            EncryptedKey encryptedKey = null;
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherData");
            Element element5 = (Element)nodeList.item(nodeList.getLength() - 1);
            CipherData cipherData = this.newCipherData(element5);
            encryptedKey = this.newEncryptedKey(cipherData);
            encryptedKey.setId(element.getAttributeNS(null, "Id"));
            encryptedKey.setType(element.getAttributeNS(null, "Type"));
            encryptedKey.setMimeType(element.getAttributeNS(null, "MimeType"));
            encryptedKey.setEncoding(element.getAttributeNS(null, "Encoding"));
            encryptedKey.setRecipient(element.getAttributeNS(null, "Recipient"));
            Element element6 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod").item(0);
            if (null != element6) {
                encryptedKey.setEncryptionMethod(this.newEncryptionMethod(element6));
            }
            if (null != (element4 = (Element)element.getElementsByTagNameNS(XMLCipher.XML_DSIG, "KeyInfo").item(0))) {
                object = this.newKeyInfo(element4);
                encryptedKey.setKeyInfo((KeyInfo)object);
            }
            if (null != (object = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties").item(0))) {
                encryptedKey.setEncryptionProperties(this.newEncryptionProperties((Element)object));
            }
            if (null != (element3 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "ReferenceList").item(0))) {
                encryptedKey.setReferenceList(this.newReferenceList(element3));
            }
            if (null != (element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName").item(0))) {
                encryptedKey.setCarriedName(element2.getFirstChild().getNodeValue());
            }
            return encryptedKey;
        }

        KeyInfo newKeyInfo(Element element) throws XMLEncryptionException {
            try {
                KeyInfo keyInfo = new KeyInfo(element, null);
                keyInfo.setSecureValidation(XMLCipher.this.secureValidation);
                if (XMLCipher.this.internalKeyResolvers != null) {
                    int n = XMLCipher.this.internalKeyResolvers.size();
                    for (int i = 0; i < n; ++i) {
                        keyInfo.registerInternalKeyResolver((KeyResolverSpi)XMLCipher.this.internalKeyResolvers.get(i));
                    }
                }
                return keyInfo;
            }
            catch (XMLSecurityException xMLSecurityException) {
                throw new XMLEncryptionException("Error loading Key Info", xMLSecurityException);
            }
        }

        EncryptionMethod newEncryptionMethod(Element element) {
            Object object;
            Object object2;
            Element element2;
            String string = element.getAttributeNS(null, "Algorithm");
            EncryptionMethod encryptionMethod = this.newEncryptionMethod(string);
            Element element3 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeySize").item(0);
            if (null != element3) {
                encryptionMethod.setKeySize(Integer.valueOf(element3.getFirstChild().getNodeValue()));
            }
            if (null != (element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "OAEPparams").item(0))) {
                try {
                    object2 = element2.getFirstChild().getNodeValue();
                    encryptionMethod.setOAEPparams(Base64.decode(((String)object2).getBytes("UTF-8")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException("UTF-8 not supported", unsupportedEncodingException);
                }
                catch (Base64DecodingException base64DecodingException) {
                    throw new RuntimeException("BASE-64 decoding error", base64DecodingException);
                }
            }
            if ((object2 = (Element)element.getElementsByTagNameNS(XMLCipher.XML_DSIG, "DigestMethod").item(0)) != null) {
                object = object2.getAttributeNS(null, "Algorithm");
                encryptionMethod.setDigestAlgorithm((String)object);
            }
            if ((object = (Element)element.getElementsByTagNameNS("http://www.w3.org/2009/xmlenc11#", "MGF").item(0)) != null && !XMLCipher.RSA_OAEP.equals(XMLCipher.this.algorithm)) {
                String string2 = object.getAttributeNS(null, "Algorithm");
                encryptionMethod.setMGFAlgorithm(string2);
            }
            return encryptionMethod;
        }

        EncryptionProperties newEncryptionProperties(Element element) {
            EncryptionProperties encryptionProperties = this.newEncryptionProperties();
            encryptionProperties.setId(element.getAttributeNS(null, "Id"));
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperty");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (null == node) continue;
                encryptionProperties.addEncryptionProperty(this.newEncryptionProperty((Element)node));
            }
            return encryptionProperties;
        }

        EncryptionProperty newEncryptionProperty(Element element) {
            EncryptionProperty encryptionProperty = this.newEncryptionProperty();
            encryptionProperty.setTarget(element.getAttributeNS(null, "Target"));
            encryptionProperty.setId(element.getAttributeNS(null, "Id"));
            return encryptionProperty;
        }

        ReferenceList newReferenceList(Element element) {
            int n = 0;
            if (null != element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "DataReference").item(0)) {
                n = 1;
            } else if (null != element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeyReference").item(0)) {
                n = 2;
            }
            ReferenceListImpl referenceListImpl = new ReferenceListImpl(n);
            NodeList nodeList = null;
            switch (n) {
                case 1: {
                    nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "DataReference");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        String string = ((Element)nodeList.item(i)).getAttributeNS(null, "URI");
                        referenceListImpl.add(referenceListImpl.newDataReference(string));
                    }
                    break;
                }
                case 2: {
                    nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeyReference");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        String string = ((Element)nodeList.item(i)).getAttributeNS(null, "URI");
                        referenceListImpl.add(referenceListImpl.newKeyReference(string));
                    }
                    break;
                }
            }
            return referenceListImpl;
        }

        Element toElement(EncryptedData encryptedData) {
            return ((EncryptedDataImpl)encryptedData).toElement();
        }

        Element toElement(EncryptedKey encryptedKey) {
            return ((EncryptedKeyImpl)encryptedKey).toElement();
        }

        Element toElement(ReferenceList referenceList) {
            return ((ReferenceListImpl)referenceList).toElement();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ReferenceListImpl
        implements ReferenceList {
            private Class<?> sentry;
            private List<Reference> references;

            public ReferenceListImpl(int n) {
                if (n == 1) {
                    this.sentry = DataReference.class;
                } else if (n == 2) {
                    this.sentry = KeyReference.class;
                } else {
                    throw new IllegalArgumentException();
                }
                this.references = new LinkedList<Reference>();
            }

            @Override
            public void add(Reference reference) {
                if (!reference.getClass().equals(this.sentry)) {
                    throw new IllegalArgumentException();
                }
                this.references.add(reference);
            }

            @Override
            public void remove(Reference reference) {
                if (!reference.getClass().equals(this.sentry)) {
                    throw new IllegalArgumentException();
                }
                this.references.remove(reference);
            }

            @Override
            public int size() {
                return this.references.size();
            }

            @Override
            public boolean isEmpty() {
                return this.references.isEmpty();
            }

            @Override
            public Iterator<Reference> getReferences() {
                return this.references.iterator();
            }

            Element toElement() {
                Element element = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
                for (Reference reference : this.references) {
                    element.appendChild(((ReferenceImpl)reference).toElement());
                }
                return element;
            }

            @Override
            public Reference newDataReference(String string) {
                return new DataReference(string);
            }

            @Override
            public Reference newKeyReference(String string) {
                return new KeyReference(string);
            }

            private class KeyReference
            extends ReferenceImpl {
                KeyReference(String string) {
                    super(string);
                }

                public String getType() {
                    return "KeyReference";
                }
            }

            private class DataReference
            extends ReferenceImpl {
                DataReference(String string) {
                    super(string);
                }

                public String getType() {
                    return "DataReference";
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private abstract class ReferenceImpl
            implements Reference {
                private String uri;
                private List<Element> referenceInformation;

                ReferenceImpl(String string) {
                    this.uri = string;
                    this.referenceInformation = new LinkedList<Element>();
                }

                @Override
                public abstract String getType();

                @Override
                public String getURI() {
                    return this.uri;
                }

                @Override
                public Iterator<Element> getElementRetrievalInformation() {
                    return this.referenceInformation.iterator();
                }

                @Override
                public void setURI(String string) {
                    this.uri = string;
                }

                @Override
                public void removeElementRetrievalInformation(Element element) {
                    this.referenceInformation.remove(element);
                }

                @Override
                public void addElementRetrievalInformation(Element element) {
                    this.referenceInformation.add(element);
                }

                public Element toElement() {
                    String string = this.getType();
                    Element element = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", string);
                    element.setAttributeNS(null, "URI", this.uri);
                    return element;
                }
            }
        }

        private class TransformsImpl
        extends org.apache.xml.security.transforms.Transforms
        implements Transforms {
            public TransformsImpl() {
                super(XMLCipher.this.contextDocument);
            }

            public TransformsImpl(Document document) {
                if (document == null) {
                    throw new RuntimeException("Document is null");
                }
                this.doc = document;
                this.constructionElement = this.createElementForFamilyLocal(this.doc, this.getBaseNamespace(), this.getBaseLocalName());
            }

            public TransformsImpl(Element element) throws XMLSignatureException, InvalidTransformException, XMLSecurityException, TransformationException {
                super(element, "");
            }

            public Element toElement() {
                if (this.doc == null) {
                    this.doc = XMLCipher.this.contextDocument;
                }
                return this.getElement();
            }

            public org.apache.xml.security.transforms.Transforms getDSTransforms() {
                return this;
            }

            public String getBaseNamespace() {
                return "http://www.w3.org/2001/04/xmlenc#";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EncryptionPropertyImpl
        implements EncryptionProperty {
            private String target = null;
            private String id = null;
            private Map<String, String> attributeMap = new HashMap<String, String>();
            private List<Element> encryptionInformation = new LinkedList<Element>();

            @Override
            public String getTarget() {
                return this.target;
            }

            @Override
            public void setTarget(String string) {
                if (string == null || string.length() == 0) {
                    this.target = null;
                } else if (string.startsWith("#")) {
                    this.target = string;
                } else {
                    URI uRI = null;
                    try {
                        uRI = new URI(string);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw (IllegalArgumentException)new IllegalArgumentException().initCause(uRISyntaxException);
                    }
                    this.target = uRI.toString();
                }
            }

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public void setId(String string) {
                this.id = string;
            }

            @Override
            public String getAttribute(String string) {
                return this.attributeMap.get(string);
            }

            @Override
            public void setAttribute(String string, String string2) {
                this.attributeMap.put(string, string2);
            }

            @Override
            public Iterator<Element> getEncryptionInformation() {
                return this.encryptionInformation.iterator();
            }

            @Override
            public void addEncryptionInformation(Element element) {
                this.encryptionInformation.add(element);
            }

            @Override
            public void removeEncryptionInformation(Element element) {
                this.encryptionInformation.remove(element);
            }

            Element toElement() {
                Element element = XMLUtils.createElementInEncryptionSpace(XMLCipher.this.contextDocument, "EncryptionProperty");
                if (null != this.target) {
                    element.setAttributeNS(null, "Target", this.target);
                }
                if (null != this.id) {
                    element.setAttributeNS(null, "Id", this.id);
                }
                return element;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EncryptionPropertiesImpl
        implements EncryptionProperties {
            private String id = null;
            private List<EncryptionProperty> encryptionProperties = new LinkedList<EncryptionProperty>();

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public void setId(String string) {
                this.id = string;
            }

            @Override
            public Iterator<EncryptionProperty> getEncryptionProperties() {
                return this.encryptionProperties.iterator();
            }

            @Override
            public void addEncryptionProperty(EncryptionProperty encryptionProperty) {
                this.encryptionProperties.add(encryptionProperty);
            }

            @Override
            public void removeEncryptionProperty(EncryptionProperty encryptionProperty) {
                this.encryptionProperties.remove(encryptionProperty);
            }

            Element toElement() {
                Element element = XMLUtils.createElementInEncryptionSpace(XMLCipher.this.contextDocument, "EncryptionProperties");
                if (null != this.id) {
                    element.setAttributeNS(null, "Id", this.id);
                }
                Iterator<EncryptionProperty> iterator = this.getEncryptionProperties();
                while (iterator.hasNext()) {
                    element.appendChild(((EncryptionPropertyImpl)iterator.next()).toElement());
                }
                return element;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EncryptionMethodImpl
        implements EncryptionMethod {
            private String algorithm = null;
            private int keySize = Integer.MIN_VALUE;
            private byte[] oaepParams = null;
            private List<Element> encryptionMethodInformation = null;
            private String digestAlgorithm = null;
            private String mgfAlgorithm = null;

            public EncryptionMethodImpl(String string) {
                URI uRI = null;
                try {
                    uRI = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw (IllegalArgumentException)new IllegalArgumentException().initCause(uRISyntaxException);
                }
                this.algorithm = uRI.toString();
                this.encryptionMethodInformation = new LinkedList<Element>();
            }

            @Override
            public String getAlgorithm() {
                return this.algorithm;
            }

            @Override
            public int getKeySize() {
                return this.keySize;
            }

            @Override
            public void setKeySize(int n) {
                this.keySize = n;
            }

            @Override
            public byte[] getOAEPparams() {
                return this.oaepParams;
            }

            @Override
            public void setOAEPparams(byte[] byArray) {
                this.oaepParams = byArray;
            }

            @Override
            public void setDigestAlgorithm(String string) {
                this.digestAlgorithm = string;
            }

            @Override
            public String getDigestAlgorithm() {
                return this.digestAlgorithm;
            }

            @Override
            public void setMGFAlgorithm(String string) {
                this.mgfAlgorithm = string;
            }

            @Override
            public String getMGFAlgorithm() {
                return this.mgfAlgorithm;
            }

            @Override
            public Iterator<Element> getEncryptionMethodInformation() {
                return this.encryptionMethodInformation.iterator();
            }

            @Override
            public void addEncryptionMethodInformation(Element element) {
                this.encryptionMethodInformation.add(element);
            }

            @Override
            public void removeEncryptionMethodInformation(Element element) {
                this.encryptionMethodInformation.remove(element);
            }

            Element toElement() {
                Object object;
                Element element = XMLUtils.createElementInEncryptionSpace(XMLCipher.this.contextDocument, "EncryptionMethod");
                element.setAttributeNS(null, "Algorithm", this.algorithm);
                if (this.keySize > 0) {
                    element.appendChild(XMLUtils.createElementInEncryptionSpace(XMLCipher.this.contextDocument, "KeySize").appendChild(XMLCipher.this.contextDocument.createTextNode(String.valueOf(this.keySize))));
                }
                if (null != this.oaepParams) {
                    object = XMLUtils.createElementInEncryptionSpace(XMLCipher.this.contextDocument, "OAEPparams");
                    object.appendChild(XMLCipher.this.contextDocument.createTextNode(Base64.encode(this.oaepParams)));
                    element.appendChild((Node)object);
                }
                if (this.digestAlgorithm != null) {
                    object = XMLUtils.createElementInSignatureSpace(XMLCipher.this.contextDocument, "DigestMethod");
                    object.setAttributeNS(null, "Algorithm", this.digestAlgorithm);
                    element.appendChild((Node)object);
                }
                if (this.mgfAlgorithm != null) {
                    object = XMLUtils.createElementInEncryption11Space(XMLCipher.this.contextDocument, "MGF");
                    object.setAttributeNS(null, "Algorithm", this.mgfAlgorithm);
                    object.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + ElementProxy.getDefaultPrefix("http://www.w3.org/2009/xmlenc11#"), "http://www.w3.org/2009/xmlenc11#");
                    element.appendChild((Node)object);
                }
                object = this.encryptionMethodInformation.iterator();
                while (object.hasNext()) {
                    element.appendChild((Node)object.next());
                }
                return element;
            }
        }

        private abstract class EncryptedTypeImpl {
            private String id = null;
            private String type = null;
            private String mimeType = null;
            private String encoding = null;
            private EncryptionMethod encryptionMethod = null;
            private KeyInfo keyInfo = null;
            private CipherData cipherData = null;
            private EncryptionProperties encryptionProperties = null;

            protected EncryptedTypeImpl(CipherData cipherData) {
                this.cipherData = cipherData;
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String string) {
                if (string == null || string.length() == 0) {
                    this.type = null;
                } else {
                    URI uRI = null;
                    try {
                        uRI = new URI(string);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw (IllegalArgumentException)new IllegalArgumentException().initCause(uRISyntaxException);
                    }
                    this.type = uRI.toString();
                }
            }

            public String getMimeType() {
                return this.mimeType;
            }

            public void setMimeType(String string) {
                this.mimeType = string;
            }

            public String getEncoding() {
                return this.encoding;
            }

            public void setEncoding(String string) {
                if (string == null || string.length() == 0) {
                    this.encoding = null;
                } else {
                    URI uRI = null;
                    try {
                        uRI = new URI(string);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw (IllegalArgumentException)new IllegalArgumentException().initCause(uRISyntaxException);
                    }
                    this.encoding = uRI.toString();
                }
            }

            public EncryptionMethod getEncryptionMethod() {
                return this.encryptionMethod;
            }

            public void setEncryptionMethod(EncryptionMethod encryptionMethod) {
                this.encryptionMethod = encryptionMethod;
            }

            public KeyInfo getKeyInfo() {
                return this.keyInfo;
            }

            public void setKeyInfo(KeyInfo keyInfo) {
                this.keyInfo = keyInfo;
            }

            public CipherData getCipherData() {
                return this.cipherData;
            }

            public EncryptionProperties getEncryptionProperties() {
                return this.encryptionProperties;
            }

            public void setEncryptionProperties(EncryptionProperties encryptionProperties) {
                this.encryptionProperties = encryptionProperties;
            }
        }

        private class EncryptedKeyImpl
        extends EncryptedTypeImpl
        implements EncryptedKey {
            private String keyRecipient;
            private ReferenceList referenceList;
            private String carriedName;

            public EncryptedKeyImpl(CipherData cipherData) {
                super(cipherData);
                this.keyRecipient = null;
                this.referenceList = null;
                this.carriedName = null;
            }

            public String getRecipient() {
                return this.keyRecipient;
            }

            public void setRecipient(String string) {
                this.keyRecipient = string;
            }

            public ReferenceList getReferenceList() {
                return this.referenceList;
            }

            public void setReferenceList(ReferenceList referenceList) {
                this.referenceList = referenceList;
            }

            public String getCarriedName() {
                return this.carriedName;
            }

            public void setCarriedName(String string) {
                this.carriedName = string;
            }

            Element toElement() {
                Element element = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
                if (null != super.getId()) {
                    element.setAttributeNS(null, "Id", super.getId());
                }
                if (null != super.getType()) {
                    element.setAttributeNS(null, "Type", super.getType());
                }
                if (null != super.getMimeType()) {
                    element.setAttributeNS(null, "MimeType", super.getMimeType());
                }
                if (null != super.getEncoding()) {
                    element.setAttributeNS(null, "Encoding", super.getEncoding());
                }
                if (null != this.getRecipient()) {
                    element.setAttributeNS(null, "Recipient", this.getRecipient());
                }
                if (null != super.getEncryptionMethod()) {
                    element.appendChild(((EncryptionMethodImpl)super.getEncryptionMethod()).toElement());
                }
                if (null != super.getKeyInfo()) {
                    element.appendChild(super.getKeyInfo().getElement().cloneNode(true));
                }
                element.appendChild(((CipherDataImpl)super.getCipherData()).toElement());
                if (null != super.getEncryptionProperties()) {
                    element.appendChild(((EncryptionPropertiesImpl)super.getEncryptionProperties()).toElement());
                }
                if (this.referenceList != null && !this.referenceList.isEmpty()) {
                    element.appendChild(((ReferenceListImpl)this.getReferenceList()).toElement());
                }
                if (null != this.carriedName) {
                    Element element2 = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName");
                    Text text = XMLCipher.this.contextDocument.createTextNode(this.carriedName);
                    element2.appendChild(text);
                    element.appendChild(element2);
                }
                return element;
            }
        }

        private class EncryptedDataImpl
        extends EncryptedTypeImpl
        implements EncryptedData {
            public EncryptedDataImpl(CipherData cipherData) {
                super(cipherData);
            }

            Element toElement() {
                Element element = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
                if (null != super.getId()) {
                    element.setAttributeNS(null, "Id", super.getId());
                }
                if (null != super.getType()) {
                    element.setAttributeNS(null, "Type", super.getType());
                }
                if (null != super.getMimeType()) {
                    element.setAttributeNS(null, "MimeType", super.getMimeType());
                }
                if (null != super.getEncoding()) {
                    element.setAttributeNS(null, "Encoding", super.getEncoding());
                }
                if (null != super.getEncryptionMethod()) {
                    element.appendChild(((EncryptionMethodImpl)super.getEncryptionMethod()).toElement());
                }
                if (null != super.getKeyInfo()) {
                    element.appendChild(super.getKeyInfo().getElement().cloneNode(true));
                }
                element.appendChild(((CipherDataImpl)super.getCipherData()).toElement());
                if (null != super.getEncryptionProperties()) {
                    element.appendChild(((EncryptionPropertiesImpl)super.getEncryptionProperties()).toElement());
                }
                return element;
            }
        }

        private class CipherValueImpl
        implements CipherValue {
            private String cipherValue = null;

            public CipherValueImpl(String string) {
                this.cipherValue = string;
            }

            public String getValue() {
                return this.cipherValue;
            }

            public void setValue(String string) {
                this.cipherValue = string;
            }

            Element toElement() {
                Element element = XMLUtils.createElementInEncryptionSpace(XMLCipher.this.contextDocument, "CipherValue");
                element.appendChild(XMLCipher.this.contextDocument.createTextNode(this.cipherValue));
                return element;
            }
        }

        private class CipherReferenceImpl
        implements CipherReference {
            private String referenceURI = null;
            private Transforms referenceTransforms = null;
            private Attr referenceNode = null;

            public CipherReferenceImpl(String string) {
                this.referenceURI = string;
                this.referenceNode = null;
            }

            public CipherReferenceImpl(Attr attr) {
                this.referenceURI = attr.getNodeValue();
                this.referenceNode = attr;
            }

            public String getURI() {
                return this.referenceURI;
            }

            public Attr getURIAsAttr() {
                return this.referenceNode;
            }

            public Transforms getTransforms() {
                return this.referenceTransforms;
            }

            public void setTransforms(Transforms transforms) {
                this.referenceTransforms = transforms;
            }

            Element toElement() {
                Element element = XMLUtils.createElementInEncryptionSpace(XMLCipher.this.contextDocument, "CipherReference");
                element.setAttributeNS(null, "URI", this.referenceURI);
                if (null != this.referenceTransforms) {
                    element.appendChild(((TransformsImpl)this.referenceTransforms).toElement());
                }
                return element;
            }
        }

        private class CipherDataImpl
        implements CipherData {
            private static final String valueMessage = "Data type is reference type.";
            private static final String referenceMessage = "Data type is value type.";
            private CipherValue cipherValue = null;
            private CipherReference cipherReference = null;
            private int cipherType = Integer.MIN_VALUE;

            public CipherDataImpl(int n) {
                this.cipherType = n;
            }

            public CipherValue getCipherValue() {
                return this.cipherValue;
            }

            public void setCipherValue(CipherValue cipherValue) throws XMLEncryptionException {
                if (this.cipherType == 2) {
                    throw new XMLEncryptionException("empty", new UnsupportedOperationException(valueMessage));
                }
                this.cipherValue = cipherValue;
            }

            public CipherReference getCipherReference() {
                return this.cipherReference;
            }

            public void setCipherReference(CipherReference cipherReference) throws XMLEncryptionException {
                if (this.cipherType == 1) {
                    throw new XMLEncryptionException("empty", new UnsupportedOperationException(referenceMessage));
                }
                this.cipherReference = cipherReference;
            }

            public int getDataType() {
                return this.cipherType;
            }

            Element toElement() {
                Element element = XMLUtils.createElementInEncryptionSpace(XMLCipher.this.contextDocument, "CipherData");
                if (this.cipherType == 1) {
                    element.appendChild(((CipherValueImpl)this.cipherValue).toElement());
                } else if (this.cipherType == 2) {
                    element.appendChild(((CipherReferenceImpl)this.cipherReference).toElement());
                }
                return element;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class AgreementMethodImpl
        implements AgreementMethod {
            private byte[] kaNonce = null;
            private List<Element> agreementMethodInformation = new LinkedList<Element>();
            private KeyInfo originatorKeyInfo = null;
            private KeyInfo recipientKeyInfo = null;
            private String algorithmURI = null;

            public AgreementMethodImpl(String string) {
                URI uRI = null;
                try {
                    uRI = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw (IllegalArgumentException)new IllegalArgumentException().initCause(uRISyntaxException);
                }
                this.algorithmURI = uRI.toString();
            }

            @Override
            public byte[] getKANonce() {
                return this.kaNonce;
            }

            @Override
            public void setKANonce(byte[] byArray) {
                this.kaNonce = byArray;
            }

            @Override
            public Iterator<Element> getAgreementMethodInformation() {
                return this.agreementMethodInformation.iterator();
            }

            @Override
            public void addAgreementMethodInformation(Element element) {
                this.agreementMethodInformation.add(element);
            }

            @Override
            public void revoveAgreementMethodInformation(Element element) {
                this.agreementMethodInformation.remove(element);
            }

            @Override
            public KeyInfo getOriginatorKeyInfo() {
                return this.originatorKeyInfo;
            }

            @Override
            public void setOriginatorKeyInfo(KeyInfo keyInfo) {
                this.originatorKeyInfo = keyInfo;
            }

            @Override
            public KeyInfo getRecipientKeyInfo() {
                return this.recipientKeyInfo;
            }

            @Override
            public void setRecipientKeyInfo(KeyInfo keyInfo) {
                this.recipientKeyInfo = keyInfo;
            }

            @Override
            public String getAlgorithm() {
                return this.algorithmURI;
            }
        }
    }
}

