/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.security.encryption.AbstractSerializer;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class TransformSerializer
extends AbstractSerializer {
    private TransformerFactory transformerFactory;

    public Node deserialize(byte[] byArray, Node node) throws XMLEncryptionException {
        byte[] byArray2 = TransformSerializer.createContext(byArray, node);
        return this.deserialize(node, new StreamSource(new ByteArrayInputStream(byArray2)));
    }

    public Node deserialize(String string, Node node) throws XMLEncryptionException {
        String string2 = TransformSerializer.createContext(string, node);
        return this.deserialize(node, new StreamSource(new StringReader(string2)));
    }

    private Node deserialize(Node node, Source source) throws XMLEncryptionException {
        try {
            Document document = null;
            document = 9 == node.getNodeType() ? (Document)node : node.getOwnerDocument();
            if (this.transformerFactory == null) {
                this.transformerFactory = TransformerFactory.newInstance();
                this.transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            }
            Transformer transformer = this.transformerFactory.newTransformer();
            DOMResult dOMResult = new DOMResult();
            DocumentFragment documentFragment = document.createDocumentFragment();
            dOMResult.setNode(documentFragment);
            transformer.transform(source, dOMResult);
            Node node2 = documentFragment.getFirstChild();
            Node node3 = node2.getFirstChild();
            if (node3 != null && node3.getNextSibling() == null) {
                return node3;
            }
            DocumentFragment documentFragment2 = document.createDocumentFragment();
            while (node3 != null) {
                node2.removeChild(node3);
                documentFragment2.appendChild(node3);
                node3 = node2.getFirstChild();
            }
            return documentFragment2;
        }
        catch (Exception exception) {
            throw new XMLEncryptionException("empty", exception);
        }
    }
}

