/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.xml.security.c14n.implementations.NameSpaceSymbEntry;
import org.apache.xml.security.c14n.implementations.SymbMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameSpaceSymbTable {
    private static final String XMLNS = "xmlns";
    private static final SymbMap initialMap = new SymbMap();
    private SymbMap symb;
    private List<SymbMap> level = new ArrayList<SymbMap>();
    private boolean cloned = true;

    public NameSpaceSymbTable() {
        this.symb = (SymbMap)initialMap.clone();
    }

    public void getUnrenderedNodes(Collection<Attr> collection) {
        for (NameSpaceSymbEntry nameSpaceSymbEntry : this.symb.entrySet()) {
            if (nameSpaceSymbEntry.rendered || nameSpaceSymbEntry.n == null) continue;
            nameSpaceSymbEntry = (NameSpaceSymbEntry)nameSpaceSymbEntry.clone();
            this.needsClone();
            this.symb.put(nameSpaceSymbEntry.prefix, nameSpaceSymbEntry);
            nameSpaceSymbEntry.lastrendered = nameSpaceSymbEntry.uri;
            nameSpaceSymbEntry.rendered = true;
            collection.add(nameSpaceSymbEntry.n);
        }
    }

    public void outputNodePush() {
        this.push();
    }

    public void outputNodePop() {
        this.pop();
    }

    public void push() {
        this.level.add(null);
        this.cloned = false;
    }

    public void pop() {
        int n = this.level.size() - 1;
        SymbMap symbMap = this.level.remove(n);
        if (symbMap != null) {
            this.symb = symbMap;
            this.cloned = n == 0 ? false : this.level.get(n - 1) != this.symb;
        } else {
            this.cloned = false;
        }
    }

    final void needsClone() {
        if (!this.cloned) {
            this.level.set(this.level.size() - 1, this.symb);
            this.symb = (SymbMap)this.symb.clone();
            this.cloned = true;
        }
    }

    public Attr getMapping(String string) {
        NameSpaceSymbEntry nameSpaceSymbEntry = this.symb.get(string);
        if (nameSpaceSymbEntry == null) {
            return null;
        }
        if (nameSpaceSymbEntry.rendered) {
            return null;
        }
        nameSpaceSymbEntry = (NameSpaceSymbEntry)nameSpaceSymbEntry.clone();
        this.needsClone();
        this.symb.put(string, nameSpaceSymbEntry);
        nameSpaceSymbEntry.rendered = true;
        nameSpaceSymbEntry.lastrendered = nameSpaceSymbEntry.uri;
        return nameSpaceSymbEntry.n;
    }

    public Attr getMappingWithoutRendered(String string) {
        NameSpaceSymbEntry nameSpaceSymbEntry = this.symb.get(string);
        if (nameSpaceSymbEntry == null) {
            return null;
        }
        if (nameSpaceSymbEntry.rendered) {
            return null;
        }
        return nameSpaceSymbEntry.n;
    }

    public boolean addMapping(String string, String string2, Attr attr) {
        NameSpaceSymbEntry nameSpaceSymbEntry = this.symb.get(string);
        if (nameSpaceSymbEntry != null && string2.equals(nameSpaceSymbEntry.uri)) {
            return false;
        }
        NameSpaceSymbEntry nameSpaceSymbEntry2 = new NameSpaceSymbEntry(string2, attr, false, string);
        this.needsClone();
        this.symb.put(string, nameSpaceSymbEntry2);
        if (nameSpaceSymbEntry != null) {
            nameSpaceSymbEntry2.lastrendered = nameSpaceSymbEntry.lastrendered;
            if (nameSpaceSymbEntry.lastrendered != null && nameSpaceSymbEntry.lastrendered.equals(string2)) {
                nameSpaceSymbEntry2.rendered = true;
            }
        }
        return true;
    }

    public Node addMappingAndRender(String string, String string2, Attr attr) {
        NameSpaceSymbEntry nameSpaceSymbEntry = this.symb.get(string);
        if (nameSpaceSymbEntry != null && string2.equals(nameSpaceSymbEntry.uri)) {
            if (!nameSpaceSymbEntry.rendered) {
                nameSpaceSymbEntry = (NameSpaceSymbEntry)nameSpaceSymbEntry.clone();
                this.needsClone();
                this.symb.put(string, nameSpaceSymbEntry);
                nameSpaceSymbEntry.lastrendered = string2;
                nameSpaceSymbEntry.rendered = true;
                return nameSpaceSymbEntry.n;
            }
            return null;
        }
        NameSpaceSymbEntry nameSpaceSymbEntry2 = new NameSpaceSymbEntry(string2, attr, true, string);
        nameSpaceSymbEntry2.lastrendered = string2;
        this.needsClone();
        this.symb.put(string, nameSpaceSymbEntry2);
        if (nameSpaceSymbEntry != null && nameSpaceSymbEntry.lastrendered != null && nameSpaceSymbEntry.lastrendered.equals(string2)) {
            nameSpaceSymbEntry2.rendered = true;
            return null;
        }
        return nameSpaceSymbEntry2.n;
    }

    public int getLevel() {
        return this.level.size();
    }

    public void removeMapping(String string) {
        NameSpaceSymbEntry nameSpaceSymbEntry = this.symb.get(string);
        if (nameSpaceSymbEntry != null) {
            this.needsClone();
            this.symb.put(string, null);
        }
    }

    public void removeMappingIfNotRender(String string) {
        NameSpaceSymbEntry nameSpaceSymbEntry = this.symb.get(string);
        if (nameSpaceSymbEntry != null && !nameSpaceSymbEntry.rendered) {
            this.needsClone();
            this.symb.put(string, null);
        }
    }

    public boolean removeMappingIfRender(String string) {
        NameSpaceSymbEntry nameSpaceSymbEntry = this.symb.get(string);
        if (nameSpaceSymbEntry != null && nameSpaceSymbEntry.rendered) {
            this.needsClone();
            this.symb.put(string, null);
        }
        return false;
    }

    static {
        NameSpaceSymbEntry nameSpaceSymbEntry = new NameSpaceSymbEntry("", null, true, XMLNS);
        nameSpaceSymbEntry.lastrendered = "";
        initialMap.put(XMLNS, nameSpaceSymbEntry);
    }
}

