/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.helper.C14nHelper;
import org.apache.xml.security.c14n.implementations.CanonicalizerBase;
import org.apache.xml.security.c14n.implementations.NameSpaceSymbTable;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Canonicalizer11
extends CanonicalizerBase {
    private static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final String XML_LANG_URI = "http://www.w3.org/XML/1998/namespace";
    private static Log log = LogFactory.getLog(Canonicalizer11.class);
    private final SortedSet<Attr> result = new TreeSet<Attr>(COMPARE);
    private boolean firstCall = true;
    private XmlAttrStack xmlattrStack = new XmlAttrStack();

    public Canonicalizer11(boolean bl) {
        super(bl);
    }

    @Override
    public byte[] engineCanonicalizeXPathNodeSet(Set<Node> set, String string) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    @Override
    public byte[] engineCanonicalizeSubTree(Node node, String string) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    @Override
    protected Iterator<Attr> handleAttributesSubtree(Element element, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        if (!element.hasAttributes() && !this.firstCall) {
            return null;
        }
        SortedSet<Attr> sortedSet = this.result;
        sortedSet.clear();
        if (element.hasAttributes()) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node;
                Attr attr = (Attr)namedNodeMap.item(i);
                String string = attr.getNamespaceURI();
                String string2 = attr.getLocalName();
                String string3 = attr.getValue();
                if (!XMLNS_URI.equals(string)) {
                    sortedSet.add(attr);
                    continue;
                }
                if ("xml".equals(string2) && XML_LANG_URI.equals(string3) || (node = nameSpaceSymbTable.addMappingAndRender(string2, string3, attr)) == null) continue;
                sortedSet.add((Attr)node);
                if (!C14nHelper.namespaceIsRelative(attr)) continue;
                Object[] objectArray = new Object[]{element.getTagName(), string2, attr.getNodeValue()};
                throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
            }
        }
        if (this.firstCall) {
            nameSpaceSymbTable.getUnrenderedNodes(sortedSet);
            this.xmlattrStack.getXmlnsAttr(sortedSet);
            this.firstCall = false;
        }
        return sortedSet.iterator();
    }

    @Override
    protected Iterator<Attr> handleAttributes(Element element, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        Object object;
        this.xmlattrStack.push(nameSpaceSymbTable.getLevel());
        boolean bl = this.isVisibleDO(element, nameSpaceSymbTable.getLevel()) == 1;
        SortedSet<Attr> sortedSet = this.result;
        sortedSet.clear();
        if (element.hasAttributes()) {
            object = element.getAttributes();
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)object.item(i);
                String string = attr.getNamespaceURI();
                String string2 = attr.getLocalName();
                String string3 = attr.getValue();
                if (!XMLNS_URI.equals(string)) {
                    if (XML_LANG_URI.equals(string)) {
                        if (string2.equals("id")) {
                            if (!bl) continue;
                            sortedSet.add(attr);
                            continue;
                        }
                        this.xmlattrStack.addXmlnsAttr(attr);
                        continue;
                    }
                    if (!bl) continue;
                    sortedSet.add(attr);
                    continue;
                }
                if ("xml".equals(string2) && XML_LANG_URI.equals(string3)) continue;
                if (this.isVisible(attr)) {
                    Node node;
                    if (!bl && nameSpaceSymbTable.removeMappingIfRender(string2) || (node = nameSpaceSymbTable.addMappingAndRender(string2, string3, attr)) == null) continue;
                    sortedSet.add((Attr)node);
                    if (!C14nHelper.namespaceIsRelative(attr)) continue;
                    Object[] objectArray = new Object[]{element.getTagName(), string2, attr.getNodeValue()};
                    throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
                }
                if (bl && !"xmlns".equals(string2)) {
                    nameSpaceSymbTable.removeMapping(string2);
                    continue;
                }
                nameSpaceSymbTable.addMapping(string2, string3, attr);
            }
        }
        if (bl) {
            object = element.getAttributeNodeNS(XMLNS_URI, "xmlns");
            Node node = null;
            if (object == null) {
                node = nameSpaceSymbTable.getMapping("xmlns");
            } else if (!this.isVisible((Node)object)) {
                node = nameSpaceSymbTable.addMappingAndRender("xmlns", "", nullNode);
            }
            if (node != null) {
                sortedSet.add((Attr)node);
            }
            this.xmlattrStack.getXmlnsAttr(sortedSet);
            nameSpaceSymbTable.getUnrenderedNodes(sortedSet);
        }
        return sortedSet.iterator();
    }

    @Override
    protected void circumventBugIfNeeded(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException {
        if (!xMLSignatureInput.isNeedsToBeExpanded()) {
            return;
        }
        Document document = null;
        document = xMLSignatureInput.getSubNode() != null ? XMLUtils.getOwnerDocument(xMLSignatureInput.getSubNode()) : XMLUtils.getOwnerDocument(xMLSignatureInput.getNodeSet());
        XMLUtils.circumventBug2650(document);
    }

    @Override
    protected void handleParent(Element element, NameSpaceSymbTable nameSpaceSymbTable) {
        Object object;
        String string;
        Object object2;
        if (!element.hasAttributes() && element.getNamespaceURI() == null) {
            return;
        }
        this.xmlattrStack.push(-1);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            object2 = (Attr)namedNodeMap.item(i);
            string = object2.getLocalName();
            object = object2.getNodeValue();
            if (XMLNS_URI.equals(object2.getNamespaceURI())) {
                if ("xml".equals(string) && XML_LANG_URI.equals(object)) continue;
                nameSpaceSymbTable.addMapping(string, (String)object, (Attr)object2);
                continue;
            }
            if ("id".equals(string) || !XML_LANG_URI.equals(object2.getNamespaceURI())) continue;
            this.xmlattrStack.addXmlnsAttr((Attr)object2);
        }
        if (element.getNamespaceURI() != null) {
            String string2 = element.getPrefix();
            object2 = element.getNamespaceURI();
            if (string2 == null || string2.equals("")) {
                string2 = "xmlns";
                string = "xmlns";
            } else {
                string = "xmlns:" + string2;
            }
            object = element.getOwnerDocument().createAttributeNS(XMLNS_URI, string);
            object.setValue((String)object2);
            nameSpaceSymbTable.addMapping(string2, (String)object2, (Attr)object);
        }
    }

    private static String joinURI(String string, String string2) throws URISyntaxException {
        String string3;
        String string4;
        String string5;
        String string6;
        URI uRI;
        String string7 = null;
        String string8 = null;
        String string9 = "";
        String string10 = null;
        if (string != null) {
            if (string.endsWith("..")) {
                string = string + "/";
            }
            uRI = new URI(string);
            string7 = uRI.getScheme();
            string8 = uRI.getAuthority();
            string9 = uRI.getPath();
            string10 = uRI.getQuery();
        }
        uRI = new URI(string2);
        String string11 = uRI.getScheme();
        String string12 = uRI.getAuthority();
        String string13 = uRI.getPath();
        String string14 = uRI.getQuery();
        if (string11 != null && string11.equals(string7)) {
            string11 = null;
        }
        if (string11 != null) {
            string6 = string11;
            string5 = string12;
            string4 = Canonicalizer11.removeDotSegments(string13);
            string3 = string14;
        } else {
            if (string12 != null) {
                string5 = string12;
                string4 = Canonicalizer11.removeDotSegments(string13);
                string3 = string14;
            } else {
                if (string13.length() == 0) {
                    string4 = string9;
                    string3 = string14 != null ? string14 : string10;
                } else {
                    if (string13.startsWith("/")) {
                        string4 = Canonicalizer11.removeDotSegments(string13);
                    } else {
                        int n;
                        string4 = string8 != null && string9.length() == 0 ? "/" + string13 : ((n = string9.lastIndexOf(47)) == -1 ? string13 : string9.substring(0, n + 1) + string13);
                        string4 = Canonicalizer11.removeDotSegments(string4);
                    }
                    string3 = string14;
                }
                string5 = string8;
            }
            string6 = string7;
        }
        return new URI(string6, string5, string4, string3, null).toString();
    }

    private static String removeDotSegments(String string) {
        if (log.isDebugEnabled()) {
            log.debug("STEP   OUTPUT BUFFER\t\tINPUT BUFFER");
        }
        String string2 = string;
        while (string2.indexOf("//") > -1) {
            string2 = string2.replaceAll("//", "/");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string2.charAt(0) == '/') {
            stringBuilder.append("/");
            string2 = string2.substring(1);
        }
        Canonicalizer11.printStep("1 ", stringBuilder.toString(), string2);
        while (string2.length() != 0) {
            String string3;
            int n;
            if (string2.startsWith("./")) {
                string2 = string2.substring(2);
                Canonicalizer11.printStep("2A", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.startsWith("../")) {
                string2 = string2.substring(3);
                if (!stringBuilder.toString().equals("/")) {
                    stringBuilder.append("../");
                }
                Canonicalizer11.printStep("2A", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.startsWith("/./")) {
                string2 = string2.substring(2);
                Canonicalizer11.printStep("2B", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.equals("/.")) {
                string2 = string2.replaceFirst("/.", "/");
                Canonicalizer11.printStep("2B", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.startsWith("/../")) {
                string2 = string2.substring(3);
                if (stringBuilder.length() == 0) {
                    stringBuilder.append("/");
                } else if (stringBuilder.toString().endsWith("../")) {
                    stringBuilder.append("..");
                } else if (stringBuilder.toString().endsWith("..")) {
                    stringBuilder.append("/..");
                } else {
                    n = stringBuilder.lastIndexOf("/");
                    if (n == -1) {
                        stringBuilder = new StringBuilder();
                        if (string2.charAt(0) == '/') {
                            string2 = string2.substring(1);
                        }
                    } else {
                        stringBuilder = stringBuilder.delete(n, stringBuilder.length());
                    }
                }
                Canonicalizer11.printStep("2C", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.equals("/..")) {
                string2 = string2.replaceFirst("/..", "/");
                if (stringBuilder.length() == 0) {
                    stringBuilder.append("/");
                } else if (stringBuilder.toString().endsWith("../")) {
                    stringBuilder.append("..");
                } else if (stringBuilder.toString().endsWith("..")) {
                    stringBuilder.append("/..");
                } else {
                    n = stringBuilder.lastIndexOf("/");
                    if (n == -1) {
                        stringBuilder = new StringBuilder();
                        if (string2.charAt(0) == '/') {
                            string2 = string2.substring(1);
                        }
                    } else {
                        stringBuilder = stringBuilder.delete(n, stringBuilder.length());
                    }
                }
                Canonicalizer11.printStep("2C", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.equals(".")) {
                string2 = "";
                Canonicalizer11.printStep("2D", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.equals("..")) {
                if (!stringBuilder.toString().equals("/")) {
                    stringBuilder.append("..");
                }
                string2 = "";
                Canonicalizer11.printStep("2D", stringBuilder.toString(), string2);
                continue;
            }
            n = -1;
            int n2 = string2.indexOf(47);
            if (n2 == 0) {
                n = string2.indexOf(47, 1);
            } else {
                n = n2;
                n2 = 0;
            }
            if (n == -1) {
                string3 = string2.substring(n2);
                string2 = "";
            } else {
                string3 = string2.substring(n2, n);
                string2 = string2.substring(n);
            }
            stringBuilder.append(string3);
            Canonicalizer11.printStep("2E", stringBuilder.toString(), string2);
        }
        if (stringBuilder.toString().endsWith("..")) {
            stringBuilder.append("/");
            Canonicalizer11.printStep("3 ", stringBuilder.toString(), string2);
        }
        return stringBuilder.toString();
    }

    private static void printStep(String string, String string2, String string3) {
        if (log.isDebugEnabled()) {
            log.debug(" " + string + ":   " + string2);
            if (string2.length() == 0) {
                log.debug("\t\t\t\t" + string3);
            } else {
                log.debug("\t\t\t" + string3);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XmlAttrStack {
        int currentLevel = 0;
        int lastlevel = 0;
        XmlsStackElement cur;
        List<XmlsStackElement> levels = new ArrayList<XmlsStackElement>();

        private XmlAttrStack() {
        }

        void push(int n) {
            this.currentLevel = n;
            if (this.currentLevel == -1) {
                return;
            }
            this.cur = null;
            while (this.lastlevel >= this.currentLevel) {
                this.levels.remove(this.levels.size() - 1);
                int n2 = this.levels.size();
                if (n2 == 0) {
                    this.lastlevel = 0;
                    return;
                }
                this.lastlevel = this.levels.get((int)(n2 - 1)).level;
            }
        }

        void addXmlnsAttr(Attr attr) {
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.levels.add(this.cur);
                this.lastlevel = this.currentLevel;
            }
            this.cur.nodes.add(attr);
        }

        void getXmlnsAttr(Collection<Attr> collection) {
            Object object;
            Iterator<Attr> iterator;
            int n = this.levels.size() - 1;
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.lastlevel = this.currentLevel;
                this.levels.add(this.cur);
            }
            boolean bl = false;
            XmlsStackElement xmlsStackElement = null;
            if (n == -1) {
                bl = true;
            } else {
                xmlsStackElement = this.levels.get(n);
                if (xmlsStackElement.rendered && xmlsStackElement.level + 1 == this.currentLevel) {
                    bl = true;
                }
            }
            if (bl) {
                collection.addAll(this.cur.nodes);
                this.cur.rendered = true;
                return;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl2 = true;
            while (n >= 0) {
                xmlsStackElement = this.levels.get(n);
                if (xmlsStackElement.rendered) {
                    bl2 = false;
                }
                iterator = xmlsStackElement.nodes.iterator();
                while (iterator.hasNext() && bl2) {
                    object = iterator.next();
                    if (object.getLocalName().equals("base") && !xmlsStackElement.rendered) {
                        arrayList.add(object);
                        continue;
                    }
                    if (hashMap.containsKey(object.getName())) continue;
                    hashMap.put(object.getName(), object);
                }
                --n;
            }
            if (!arrayList.isEmpty()) {
                iterator = collection.iterator();
                object = null;
                Attr attr = null;
                while (iterator.hasNext()) {
                    Attr attr2 = iterator.next();
                    if (!attr2.getLocalName().equals("base")) continue;
                    object = attr2.getValue();
                    attr = attr2;
                    break;
                }
                for (Attr attr2 : arrayList) {
                    if (object == null) {
                        object = attr2.getValue();
                        attr = attr2;
                        continue;
                    }
                    try {
                        object = Canonicalizer11.joinURI(attr2.getValue(), (String)object);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug(uRISyntaxException.getMessage(), uRISyntaxException);
                    }
                }
                if (object != null && ((String)object).length() != 0) {
                    attr.setValue((String)object);
                    collection.add(attr);
                }
            }
            this.cur.rendered = true;
            collection.addAll(hashMap.values());
        }

        static class XmlsStackElement {
            int level;
            boolean rendered = false;
            List<Attr> nodes = new ArrayList<Attr>();

            XmlsStackElement() {
            }
        }
    }
}

