/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.implementations;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.Base64;

public abstract class SignatureECDSA
extends SignatureAlgorithmSpi {
    private static Log log = LogFactory.getLog(SignatureECDSA.class);
    private Signature signatureAlgorithm = null;

    public abstract String engineGetURI();

    public static byte[] convertASN1toXMLDSIG(byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (byArray.length < 8 || byArray[0] != 48) {
            throw new IOException("Invalid ASN.1 format of ECDSA signature");
        }
        if (byArray[1] > 0) {
            n5 = 2;
        } else if (byArray[1] == -127) {
            n5 = 3;
        } else {
            throw new IOException("Invalid ASN.1 format of ECDSA signature");
        }
        for (n4 = n3 = byArray[n5 + 1]; n4 > 0 && byArray[n5 + 2 + n3 - n4] == 0; --n4) {
        }
        for (n2 = n = byArray[n5 + 2 + n3 + 1]; n2 > 0 && byArray[n5 + 2 + n3 + 2 + n - n2] == 0; --n2) {
        }
        int n6 = Math.max(n4, n2);
        if ((byArray[n5 - 1] & 0xFF) != byArray.length - n5 || (byArray[n5 - 1] & 0xFF) != 2 + n3 + 2 + n || byArray[n5] != 2 || byArray[n5 + 2 + n3] != 2) {
            throw new IOException("Invalid ASN.1 format of ECDSA signature");
        }
        byte[] byArray2 = new byte[2 * n6];
        System.arraycopy(byArray, n5 + 2 + n3 - n4, byArray2, n6 - n4, n4);
        System.arraycopy(byArray, n5 + 2 + n3 + 2 + n - n2, byArray2, 2 * n6 - n2, n2);
        return byArray2;
    }

    public static byte[] convertXMLDSIGtoASN1(byte[] byArray) throws IOException {
        int n;
        byte[] byArray2;
        int n2;
        int n3;
        int n4;
        int n5;
        for (n5 = n4 = byArray.length / 2; n5 > 0 && byArray[n4 - n5] == 0; --n5) {
        }
        int n6 = n5;
        if (byArray[n4 - n5] < 0) {
            ++n6;
        }
        for (n3 = n4; n3 > 0 && byArray[2 * n4 - n3] == 0; --n3) {
        }
        int n7 = n3;
        if (byArray[2 * n4 - n3] < 0) {
            ++n7;
        }
        if ((n2 = 2 + n6 + 2 + n7) > 255) {
            throw new IOException("Invalid XMLDSIG format of ECDSA signature");
        }
        if (n2 < 128) {
            byArray2 = new byte[4 + n6 + 2 + n7];
            n = 1;
        } else {
            byArray2 = new byte[5 + n6 + 2 + n7];
            byArray2[1] = -127;
            n = 2;
        }
        byArray2[0] = 48;
        byArray2[n++] = (byte)n2;
        byArray2[n++] = 2;
        byArray2[n++] = (byte)n6;
        System.arraycopy(byArray, n4 - n5, byArray2, n + n6 - n5, n5);
        n += n6;
        byArray2[n++] = 2;
        byArray2[n++] = (byte)n7;
        System.arraycopy(byArray, 2 * n4 - n3, byArray2, n + n7 - n3, n3);
        return byArray2;
    }

    public SignatureECDSA() throws XMLSignatureException {
        String string = JCEMapper.translateURItoJCEID(this.engineGetURI());
        if (log.isDebugEnabled()) {
            log.debug("Created SignatureECDSA using " + string);
        }
        String string2 = JCEMapper.getProviderId();
        try {
            this.signatureAlgorithm = string2 == null ? Signature.getInstance(string) : Signature.getInstance(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{string, noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Object[] objectArray = new Object[]{string, noSuchProviderException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.setParameter(algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException("empty", invalidAlgorithmParameterException);
        }
    }

    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            byte[] byArray2 = SignatureECDSA.convertXMLDSIGtoASN1(byArray);
            if (log.isDebugEnabled()) {
                log.debug("Called ECDSA.verify() on " + Base64.encode(byArray));
            }
            return this.signatureAlgorithm.verify(byArray2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
    }

    protected void engineInitVerify(Key key) throws XMLSignatureException {
        if (!(key instanceof PublicKey)) {
            String string = key.getClass().getName();
            String string2 = PublicKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this.signatureAlgorithm.initVerify((PublicKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            Signature signature = this.signatureAlgorithm;
            try {
                this.signatureAlgorithm = Signature.getInstance(this.signatureAlgorithm.getAlgorithm());
            }
            catch (Exception exception) {
                if (log.isDebugEnabled()) {
                    log.debug("Exception when reinstantiating Signature:" + exception);
                }
                this.signatureAlgorithm = signature;
            }
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            byte[] byArray = this.signatureAlgorithm.sign();
            return SignatureECDSA.convertASN1toXMLDSIG(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
    }

    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = key.getClass().getName();
            String string2 = PrivateKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this.signatureAlgorithm.initSign((PrivateKey)key, secureRandom);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineInitSign(Key key) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = key.getClass().getName();
            String string2 = PrivateKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this.signatureAlgorithm.initSign((PrivateKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(by);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(byArray, n, n2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected String engineGetJCEAlgorithmString() {
        return this.signatureAlgorithm.getAlgorithm();
    }

    protected String engineGetJCEProviderName() {
        return this.signatureAlgorithm.getProvider().getName();
    }

    protected void engineSetHMACOutputLength(int n) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.HMACOutputLengthOnlyForHMAC");
    }

    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseAlgorithmParameterSpecOnRSA");
    }

    public static class SignatureECDSASHA512
    extends SignatureECDSA {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512";
        }
    }

    public static class SignatureECDSASHA384
    extends SignatureECDSA {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384";
        }
    }

    public static class SignatureECDSASHA256
    extends SignatureECDSA {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
        }
    }

    public static class SignatureECDSASHA1
    extends SignatureECDSA {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
        }
    }
}

