/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.implementations;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class IntegrityHmac
extends SignatureAlgorithmSpi {
    private static Log log = LogFactory.getLog(IntegrityHmac.class);
    private Mac macAlgorithm = null;
    private int HMACOutputLength = 0;
    private boolean HMACOutputLengthSet = false;

    public abstract String engineGetURI();

    abstract int getDigestLength();

    public IntegrityHmac() throws XMLSignatureException {
        String string = JCEMapper.translateURItoJCEID(this.engineGetURI());
        if (log.isDebugEnabled()) {
            log.debug("Created IntegrityHmacSHA1 using " + string);
        }
        try {
            this.macAlgorithm = Mac.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{string, noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("empty");
    }

    public void reset() {
        this.HMACOutputLength = 0;
        this.HMACOutputLengthSet = false;
        this.macAlgorithm.reset();
    }

    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            if (this.HMACOutputLengthSet && this.HMACOutputLength < this.getDigestLength()) {
                if (log.isDebugEnabled()) {
                    log.debug("HMACOutputLength must not be less than " + this.getDigestLength());
                }
                Object[] objectArray = new Object[]{String.valueOf(this.getDigestLength())};
                throw new XMLSignatureException("algorithms.HMACOutputLengthMin", objectArray);
            }
            byte[] byArray2 = this.macAlgorithm.doFinal();
            return MessageDigestAlgorithm.isEqual(byArray2, byArray);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    protected void engineInitVerify(Key key) throws XMLSignatureException {
        if (!(key instanceof SecretKey)) {
            String string = key.getClass().getName();
            String string2 = SecretKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this.macAlgorithm.init(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            Mac mac = this.macAlgorithm;
            try {
                this.macAlgorithm = Mac.getInstance(this.macAlgorithm.getAlgorithm());
            }
            catch (Exception exception) {
                if (log.isDebugEnabled()) {
                    log.debug("Exception when reinstantiating Mac:" + exception);
                }
                this.macAlgorithm = mac;
            }
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            if (this.HMACOutputLengthSet && this.HMACOutputLength < this.getDigestLength()) {
                if (log.isDebugEnabled()) {
                    log.debug("HMACOutputLength must not be less than " + this.getDigestLength());
                }
                Object[] objectArray = new Object[]{String.valueOf(this.getDigestLength())};
                throw new XMLSignatureException("algorithms.HMACOutputLengthMin", objectArray);
            }
            return this.macAlgorithm.doFinal();
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    protected void engineInitSign(Key key) throws XMLSignatureException {
        if (!(key instanceof SecretKey)) {
            String string = key.getClass().getName();
            String string2 = SecretKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this.macAlgorithm.init(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        if (!(key instanceof SecretKey)) {
            String string = key.getClass().getName();
            String string2 = SecretKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this.macAlgorithm.init(key, algorithmParameterSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException("empty", invalidAlgorithmParameterException);
        }
    }

    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseSecureRandomOnMAC");
    }

    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this.macAlgorithm.update(byArray);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this.macAlgorithm.update(by);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this.macAlgorithm.update(byArray, n, n2);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    protected String engineGetJCEAlgorithmString() {
        return this.macAlgorithm.getAlgorithm();
    }

    protected String engineGetJCEProviderName() {
        return this.macAlgorithm.getProvider().getName();
    }

    protected void engineSetHMACOutputLength(int n) {
        this.HMACOutputLength = n;
        this.HMACOutputLengthSet = true;
    }

    protected void engineGetContextFromElement(Element element) {
        super.engineGetContextFromElement(element);
        if (element == null) {
            throw new IllegalArgumentException("element null");
        }
        Text text = XMLUtils.selectDsNodeText(element.getFirstChild(), "HMACOutputLength", 0);
        if (text != null) {
            this.HMACOutputLength = Integer.parseInt(text.getData());
            this.HMACOutputLengthSet = true;
        }
    }

    public void engineAddContextToElement(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("null element");
        }
        if (this.HMACOutputLengthSet) {
            Document document = element.getOwnerDocument();
            Element element2 = XMLUtils.createElementInSignatureSpace(document, "HMACOutputLength");
            Text text = document.createTextNode(Integer.valueOf(this.HMACOutputLength).toString());
            element2.appendChild(text);
            XMLUtils.addReturnToElement(element);
            element.appendChild(element2);
            XMLUtils.addReturnToElement(element);
        }
    }

    public static class IntegrityHmacMD5
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
        }

        int getDigestLength() {
            return 128;
        }
    }

    public static class IntegrityHmacRIPEMD160
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
        }

        int getDigestLength() {
            return 160;
        }
    }

    public static class IntegrityHmacSHA512
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
        }

        int getDigestLength() {
            return 512;
        }
    }

    public static class IntegrityHmacSHA384
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
        }

        int getDigestLength() {
            return 384;
        }
    }

    public static class IntegrityHmacSHA256
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
        }

        int getDigestLength() {
            return 256;
        }
    }

    public static class IntegrityHmacSHA1
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        }

        int getDigestLength() {
            return 160;
        }
    }
}

