/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Init {
    public static final String CONF_NS = "http://www.xmlsecurity.org/NS/#configuration";
    private static Log log = LogFactory.getLog(Init.class);
    private static boolean alreadyInitialized = false;

    public static final synchronized boolean isInitialized() {
        return alreadyInitialized;
    }

    public static synchronized void init() {
        if (alreadyInitialized) {
            return;
        }
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                String string = System.getProperty("org.apache.xml.security.resource.config");
                if (string == null) {
                    return null;
                }
                return this.getClass().getResourceAsStream(string);
            }
        });
        if (inputStream == null) {
            Init.dynamicInit();
        } else {
            Init.fileInit(inputStream);
        }
        alreadyInitialized = true;
    }

    private static void dynamicInit() {
        I18n.init("en", "US");
        if (log.isDebugEnabled()) {
            log.debug("Registering default algorithms");
        }
        try {
            ElementProxy.registerDefaultPrefixes();
            Transform.registerDefaultAlgorithms();
            SignatureAlgorithm.registerDefaultAlgorithms();
            JCEMapper.registerDefaultAlgorithms();
            Canonicalizer.registerDefaultAlgorithms();
            ResourceResolver.registerDefaultResolvers();
            KeyResolver.registerDefaultResolvers();
        }
        catch (Exception exception) {
            log.error(exception);
            exception.printStackTrace();
        }
    }

    private static void fileInit(InputStream inputStream) {
        try {
            Node node;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            for (node = document.getFirstChild(); node != null && !"Configuration".equals(node.getLocalName()); node = node.getNextSibling()) {
            }
            if (node == null) {
                log.error("Error in reading configuration file - Configuration element not found");
                return;
            }
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                Object[] objectArray;
                String string;
                Object object;
                Object object2;
                Element[] elementArray;
                Object object3;
                if (1 != node2.getNodeType()) continue;
                String string2 = node2.getLocalName();
                if (string2.equals("ResourceBundles")) {
                    object3 = (Element[])node2;
                    elementArray = object3.getAttributeNodeNS(null, "defaultLanguageCode");
                    object2 = object3.getAttributeNodeNS(null, "defaultCountryCode");
                    object = elementArray == null ? null : elementArray.getNodeValue();
                    string = object2 == null ? null : object2.getNodeValue();
                    I18n.init((String)object, string);
                }
                if (string2.equals("CanonicalizationMethods")) {
                    object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "CanonicalizationMethod");
                    for (int i = 0; i < ((Element[])object3).length; ++i) {
                        object2 = object3[i].getAttributeNS(null, "URI");
                        object = object3[i].getAttributeNS(null, "JAVACLASS");
                        try {
                            Canonicalizer.register((String)object2, (String)object);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Canonicalizer.register(" + (String)object2 + ", " + (String)object + ")");
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            objectArray = new Object[]{object2, object};
                            log.error(I18n.translate("algorithm.classDoesNotExist", objectArray));
                        }
                    }
                }
                if (string2.equals("TransformAlgorithms")) {
                    object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "TransformAlgorithm");
                    for (int i = 0; i < ((Element[])object3).length; ++i) {
                        object2 = object3[i].getAttributeNS(null, "URI");
                        object = object3[i].getAttributeNS(null, "JAVACLASS");
                        try {
                            Transform.register((String)object2, (String)object);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Transform.register(" + (String)object2 + ", " + (String)object + ")");
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            objectArray = new Object[]{object2, object};
                            log.error(I18n.translate("algorithm.classDoesNotExist", objectArray));
                            continue;
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            log.warn("Not able to found dependencies for algorithm, I'll keep working.");
                        }
                    }
                }
                if ("JCEAlgorithmMappings".equals(string2) && (object3 = ((Element)node2).getElementsByTagName("Algorithms").item(0)) != null) {
                    elementArray = XMLUtils.selectNodes(object3.getFirstChild(), CONF_NS, "Algorithm");
                    for (int i = 0; i < elementArray.length; ++i) {
                        object = elementArray[i];
                        string = object.getAttributeNS(null, "URI");
                        JCEMapper.register(string, new JCEMapper.Algorithm((Element)object));
                    }
                }
                if (string2.equals("SignatureAlgorithms")) {
                    object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "SignatureAlgorithm");
                    for (int i = 0; i < ((Object)object3).length; ++i) {
                        object2 = object3[i].getAttributeNS(null, "URI");
                        object = object3[i].getAttributeNS(null, "JAVACLASS");
                        try {
                            SignatureAlgorithm.register((String)object2, (String)object);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("SignatureAlgorithm.register(" + (String)object2 + ", " + (String)object + ")");
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            objectArray = new Object[]{object2, object};
                            log.error(I18n.translate("algorithm.classDoesNotExist", objectArray));
                        }
                    }
                }
                if (string2.equals("ResourceResolvers")) {
                    object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "Resolver");
                    for (int i = 0; i < ((Object)object3).length; ++i) {
                        object2 = object3[i].getAttributeNS(null, "JAVACLASS");
                        object = object3[i].getAttributeNS(null, "DESCRIPTION");
                        if (object != null && ((String)object).length() > 0) {
                            if (log.isDebugEnabled()) {
                                log.debug("Register Resolver: " + (String)object2 + ": " + (String)object);
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug("Register Resolver: " + (String)object2 + ": For unknown purposes");
                        }
                        try {
                            ResourceResolver.register((String)object2);
                            continue;
                        }
                        catch (Throwable throwable) {
                            log.warn("Cannot register:" + (String)object2 + " perhaps some needed jars are not installed", throwable);
                        }
                    }
                }
                if (string2.equals("KeyResolver")) {
                    object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "Resolver");
                    ArrayList<String> arrayList = new ArrayList<String>(((Object)object3).length);
                    for (int i = 0; i < ((Object)object3).length; ++i) {
                        object = object3[i].getAttributeNS(null, "JAVACLASS");
                        string = object3[i].getAttributeNS(null, "DESCRIPTION");
                        if (string != null && string.length() > 0) {
                            if (log.isDebugEnabled()) {
                                log.debug("Register Resolver: " + (String)object + ": " + string);
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug("Register Resolver: " + (String)object + ": For unknown purposes");
                        }
                        arrayList.add((String)object);
                    }
                    KeyResolver.registerClassNames(arrayList);
                }
                if (!string2.equals("PrefixMappings")) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Now I try to bind prefixes:");
                }
                object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "PrefixMapping");
                for (int i = 0; i < ((Object)object3).length; ++i) {
                    object2 = object3[i].getAttributeNS(null, "namespace");
                    object = object3[i].getAttributeNS(null, "prefix");
                    if (log.isDebugEnabled()) {
                        log.debug("Now I try to bind " + (String)object + " to " + (String)object2);
                    }
                    ElementProxy.setDefaultPrefix((String)object2, (String)object);
                }
            }
        }
        catch (Exception exception) {
            log.error("Bad: ", exception);
            exception.printStackTrace();
        }
    }
}

