/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private Utils() {
    }

    public static byte[] readBytesFromStream(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            if (n >= 1024) continue;
            break;
        }
        return byteArrayOutputStream.toByteArray();
    }

    static Set<Node> toNodeSet(Iterator<Node> iterator) {
        HashSet<Node> hashSet = new HashSet<Node>();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            hashSet.add(node);
            if (node.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                hashSet.add(namedNodeMap.item(i));
            }
        }
        return hashSet;
    }

    public static String parseIdFromSameDocumentURI(String string) {
        if (string.length() == 0) {
            return null;
        }
        String string2 = string.substring(1);
        if (string2 != null && string2.startsWith("xpointer(id(")) {
            int n = string2.indexOf(39);
            int n2 = string2.indexOf(39, n + 1);
            string2 = string2.substring(n + 1, n2);
        }
        return string2;
    }

    public static boolean sameDocumentURI(String string) {
        return string != null && (string.length() == 0 || string.charAt(0) == '#');
    }
}

