/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.XMLObject;
import org.apache.jcp.xml.dsig.internal.dom.DOMManifest;
import org.apache.jcp.xml.dsig.internal.dom.DOMSignatureProperties;
import org.apache.jcp.xml.dsig.internal.dom.DOMStructure;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.apache.jcp.xml.dsig.internal.dom.DOMX509Data;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMXMLObject
extends DOMStructure
implements XMLObject {
    private final String id;
    private final String mimeType;
    private final String encoding;
    private final List<XMLStructure> content;
    private Element objectElem;

    public DOMXMLObject(List<? extends XMLStructure> list, String string, String string2, String string3) {
        if (list == null || list.isEmpty()) {
            this.content = Collections.emptyList();
        } else {
            this.content = Collections.unmodifiableList(new ArrayList<XMLStructure>(list));
            int n = this.content.size();
            for (int i = 0; i < n; ++i) {
                if (this.content.get(i) instanceof XMLStructure) continue;
                throw new ClassCastException("content[" + i + "] is not a valid type");
            }
        }
        this.id = string;
        this.mimeType = string2;
        this.encoding = string3;
    }

    public DOMXMLObject(Element element, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        this.encoding = DOMUtils.getAttributeValue(element, "Encoding");
        Attr attr = element.getAttributeNodeNS(null, "Id");
        if (attr != null) {
            this.id = attr.getValue();
            element.setIdAttributeNode(attr, true);
        } else {
            this.id = null;
        }
        this.mimeType = DOMUtils.getAttributeValue(element, "MimeType");
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<XMLStructure> arrayList = new ArrayList<XMLStructure>(n);
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                String string = element2.getLocalName();
                if (string.equals("Manifest")) {
                    arrayList.add(new DOMManifest(element2, xMLCryptoContext, provider));
                    continue;
                }
                if (string.equals("SignatureProperties")) {
                    arrayList.add(new DOMSignatureProperties(element2, xMLCryptoContext));
                    continue;
                }
                if (string.equals("X509Data")) {
                    arrayList.add(new DOMX509Data(element2));
                    continue;
                }
            }
            arrayList.add(new javax.xml.crypto.dom.DOMStructure(node));
        }
        this.content = arrayList.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(arrayList);
        this.objectElem = element;
    }

    @Override
    public List getContent() {
        return this.content;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void marshal(Node node, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Element element;
        Document document = DOMUtils.getOwnerDocument(node);
        Element element2 = element = this.objectElem != null ? this.objectElem : null;
        if (element == null) {
            element = DOMUtils.createElement(document, "Object", "http://www.w3.org/2000/09/xmldsig#", string);
            DOMUtils.setAttributeID(element, "Id", this.id);
            DOMUtils.setAttribute(element, "MimeType", this.mimeType);
            DOMUtils.setAttribute(element, "Encoding", this.encoding);
            for (XMLStructure xMLStructure : this.content) {
                if (xMLStructure instanceof DOMStructure) {
                    ((DOMStructure)xMLStructure).marshal(element, string, dOMCryptoContext);
                    continue;
                }
                javax.xml.crypto.dom.DOMStructure dOMStructure = (javax.xml.crypto.dom.DOMStructure)xMLStructure;
                DOMUtils.appendChild(element, dOMStructure.getNode());
            }
        }
        node.appendChild(element);
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2;
        if (this == object) {
            return true;
        }
        if (!(object instanceof XMLObject)) {
            return false;
        }
        XMLObject xMLObject = (XMLObject)object;
        boolean bl3 = this.id == null ? xMLObject.getId() == null : (bl2 = this.id.equals(xMLObject.getId()));
        boolean bl4 = this.encoding == null ? xMLObject.getEncoding() == null : (bl = this.encoding.equals(xMLObject.getEncoding()));
        boolean bl5 = this.mimeType == null ? xMLObject.getMimeType() == null : this.mimeType.equals(xMLObject.getMimeType());
        List list = xMLObject.getContent();
        return bl2 && bl && bl5 && this.equalsContent(list);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    private boolean equalsContent(List<XMLStructure> list) {
        if (this.content.size() != list.size()) {
            return false;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            XMLStructure xMLStructure = list.get(i);
            XMLStructure xMLStructure2 = this.content.get(i);
            if (xMLStructure instanceof javax.xml.crypto.dom.DOMStructure) {
                if (!(xMLStructure2 instanceof javax.xml.crypto.dom.DOMStructure)) {
                    return false;
                }
                Node node = ((javax.xml.crypto.dom.DOMStructure)xMLStructure).getNode();
                Node node2 = ((javax.xml.crypto.dom.DOMStructure)xMLStructure2).getNode();
                if (DOMUtils.nodesEqual(node2, node)) continue;
                return false;
            }
            if (xMLStructure2.equals(xMLStructure)) continue;
            return false;
        }
        return true;
    }
}

