/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.crypto.NodeSetData;
import org.apache.jcp.xml.dsig.internal.dom.ApacheData;
import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheNodeSetData
implements ApacheData,
NodeSetData {
    private XMLSignatureInput xi;

    public ApacheNodeSetData(XMLSignatureInput xMLSignatureInput) {
        this.xi = xMLSignatureInput;
    }

    @Override
    public Iterator iterator() {
        if (this.xi.getNodeFilters() != null) {
            return Collections.unmodifiableSet(this.getNodeSet(this.xi.getNodeFilters())).iterator();
        }
        try {
            return Collections.unmodifiableSet(this.xi.getNodeSet()).iterator();
        }
        catch (Exception exception) {
            throw new RuntimeException("unrecoverable error retrieving nodeset", exception);
        }
    }

    @Override
    public XMLSignatureInput getXMLSignatureInput() {
        return this.xi;
    }

    private Set<Node> getNodeSet(List<NodeFilter> list) {
        if (this.xi.isNeedsToBeExpanded()) {
            XMLUtils.circumventBug2650(XMLUtils.getOwnerDocument(this.xi.getSubNode()));
        }
        LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
        XMLUtils.getSet(this.xi.getSubNode(), linkedHashSet, null, !this.xi.isExcludeComments());
        LinkedHashSet<Node> linkedHashSet2 = new LinkedHashSet<Node>();
        for (Node node : linkedHashSet) {
            Iterator<NodeFilter> iterator = list.iterator();
            boolean bl = false;
            while (iterator.hasNext() && !bl) {
                NodeFilter nodeFilter = iterator.next();
                if (nodeFilter.isNodeInclude(node) == 1) continue;
                bl = true;
            }
            if (bl) continue;
            linkedHashSet2.add(node);
        }
        return linkedHashSet2;
    }
}

