/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcp.xml.dsig.internal.dom.ApacheData;
import org.apache.jcp.xml.dsig.internal.dom.ApacheNodeSetData;
import org.apache.jcp.xml.dsig.internal.dom.ApacheOctetStreamData;
import org.apache.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.apache.jcp.xml.dsig.internal.dom.Utils;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ApacheCanonicalizer
extends TransformService {
    private static Log log;
    protected Canonicalizer apacheCanonicalizer;
    private Transform apacheTransform;
    protected String inclusiveNamespaces;
    protected C14NMethodParameterSpec params;
    protected Document ownerDoc;
    protected Element transformElem;

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    public void init(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws InvalidAlgorithmParameterException {
        if (xMLCryptoContext != null && !(xMLCryptoContext instanceof DOMCryptoContext)) {
            throw new ClassCastException("context must be of type DOMCryptoContext");
        }
        if (xMLStructure == null || !(xMLStructure instanceof DOMStructure)) {
            throw new ClassCastException("parent must be of type DOMStructure");
        }
        this.transformElem = (Element)((DOMStructure)xMLStructure).getNode();
        this.ownerDoc = DOMUtils.getOwnerDocument(this.transformElem);
    }

    public void marshalParams(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws MarshalException {
        if (xMLCryptoContext != null && !(xMLCryptoContext instanceof DOMCryptoContext)) {
            throw new ClassCastException("context must be of type DOMCryptoContext");
        }
        if (xMLStructure == null || !(xMLStructure instanceof DOMStructure)) {
            throw new ClassCastException("parent must be of type DOMStructure");
        }
        this.transformElem = (Element)((DOMStructure)xMLStructure).getNode();
        this.ownerDoc = DOMUtils.getOwnerDocument(this.transformElem);
    }

    public Data canonicalize(Data data, XMLCryptoContext xMLCryptoContext) throws TransformException {
        return this.canonicalize(data, xMLCryptoContext, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Data canonicalize(Data data, XMLCryptoContext xMLCryptoContext, OutputStream outputStream) throws TransformException {
        if (this.apacheCanonicalizer == null) {
            try {
                this.apacheCanonicalizer = Canonicalizer.getInstance(this.getAlgorithm());
                if (log.isDebugEnabled()) {
                    log.debug("Created canonicalizer for algorithm: " + this.getAlgorithm());
                }
            }
            catch (InvalidCanonicalizerException invalidCanonicalizerException) {
                throw new TransformException("Couldn't find Canonicalizer for: " + this.getAlgorithm() + ": " + invalidCanonicalizerException.getMessage(), invalidCanonicalizerException);
            }
        }
        if (outputStream != null) {
            this.apacheCanonicalizer.setWriter(outputStream);
        } else {
            this.apacheCanonicalizer.setWriter(new ByteArrayOutputStream());
        }
        try {
            Set<Node> set = null;
            if (data instanceof ApacheData) {
                XMLSignatureInput xMLSignatureInput = ((ApacheData)data).getXMLSignatureInput();
                if (xMLSignatureInput.isElement()) {
                    if (this.inclusiveNamespaces == null) return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalizeSubtree(xMLSignatureInput.getSubNode())));
                    return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalizeSubtree(xMLSignatureInput.getSubNode(), this.inclusiveNamespaces)));
                }
                if (!xMLSignatureInput.isNodeSet()) return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalize(Utils.readBytesFromStream(xMLSignatureInput.getOctetStream()))));
                set = xMLSignatureInput.getNodeSet();
            } else {
                if (data instanceof DOMSubTreeData) {
                    DOMSubTreeData dOMSubTreeData = (DOMSubTreeData)data;
                    if (this.inclusiveNamespaces == null) return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalizeSubtree(dOMSubTreeData.getRoot())));
                    return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalizeSubtree(dOMSubTreeData.getRoot(), this.inclusiveNamespaces)));
                }
                if (!(data instanceof NodeSetData)) return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalize(Utils.readBytesFromStream(((OctetStreamData)data).getOctetStream()))));
                NodeSetData nodeSetData = (NodeSetData)data;
                Set<Node> set2 = Utils.toNodeSet(nodeSetData.iterator());
                set = set2;
                if (log.isDebugEnabled()) {
                    log.debug("Canonicalizing " + set.size() + " nodes");
                }
            }
            if (this.inclusiveNamespaces == null) return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalizeXPathNodeSet(set)));
            return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalizeXPathNodeSet(set, this.inclusiveNamespaces)));
        }
        catch (Exception exception) {
            throw new TransformException(exception);
        }
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext, OutputStream outputStream) throws TransformException {
        XMLSignatureInput xMLSignatureInput;
        if (data == null) {
            throw new NullPointerException("data must not be null");
        }
        if (outputStream == null) {
            throw new NullPointerException("output stream must not be null");
        }
        if (this.ownerDoc == null) {
            throw new TransformException("transform must be marshalled");
        }
        if (this.apacheTransform == null) {
            try {
                this.apacheTransform = new Transform(this.ownerDoc, this.getAlgorithm(), this.transformElem.getChildNodes());
                this.apacheTransform.setElement(this.transformElem, xMLCryptoContext.getBaseURI());
                if (log.isDebugEnabled()) {
                    log.debug("Created transform for algorithm: " + this.getAlgorithm());
                }
            }
            catch (Exception exception) {
                throw new TransformException("Couldn't find Transform for: " + this.getAlgorithm(), exception);
            }
        }
        if (data instanceof ApacheData) {
            if (log.isDebugEnabled()) {
                log.debug("ApacheData = true");
            }
            xMLSignatureInput = ((ApacheData)data).getXMLSignatureInput();
        } else if (data instanceof NodeSetData) {
            Object object;
            if (log.isDebugEnabled()) {
                log.debug("isNodeSet() = true");
            }
            if (data instanceof DOMSubTreeData) {
                object = (DOMSubTreeData)data;
                xMLSignatureInput = new XMLSignatureInput(((DOMSubTreeData)object).getRoot());
                xMLSignatureInput.setExcludeComments(((DOMSubTreeData)object).excludeComments());
            } else {
                object = Utils.toNodeSet(((NodeSetData)data).iterator());
                xMLSignatureInput = new XMLSignatureInput((Set<Node>)object);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("isNodeSet() = false");
            }
            try {
                xMLSignatureInput = new XMLSignatureInput(((OctetStreamData)data).getOctetStream());
            }
            catch (Exception exception) {
                throw new TransformException(exception);
            }
        }
        try {
            xMLSignatureInput = this.apacheTransform.performTransform(xMLSignatureInput, outputStream);
            if (!xMLSignatureInput.isNodeSet() && !xMLSignatureInput.isElement()) {
                return null;
            }
            if (xMLSignatureInput.isOctetStream()) {
                return new ApacheOctetStreamData(xMLSignatureInput);
            }
            return new ApacheNodeSetData(xMLSignatureInput);
        }
        catch (Exception exception) {
            throw new TransformException(exception);
        }
    }

    public final boolean isFeatureSupported(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return false;
    }

    static {
        Init.init();
        log = LogFactory.getLog(ApacheCanonicalizer.class);
    }
}

