/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.UnsyncByteArrayOutputStream;

public class DigesterOutputStream
extends OutputStream {
    private static Log log = LogFactory.getLog(DigesterOutputStream.class);
    private final boolean buffer;
    private UnsyncByteArrayOutputStream bos;
    private final MessageDigest md;

    public DigesterOutputStream(MessageDigest messageDigest) {
        this(messageDigest, false);
    }

    public DigesterOutputStream(MessageDigest messageDigest, boolean bl) {
        this.md = messageDigest;
        this.buffer = bl;
        if (bl) {
            this.bos = new UnsyncByteArrayOutputStream();
        }
    }

    public void write(int n) {
        if (this.buffer) {
            this.bos.write(n);
        }
        this.md.update((byte)n);
    }

    public void write(byte[] byArray, int n, int n2) {
        if (this.buffer) {
            this.bos.write(byArray, n, n2);
        }
        if (log.isDebugEnabled()) {
            log.debug("Pre-digested input:");
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i = n; i < n + n2; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
            log.debug(stringBuilder.toString());
        }
        this.md.update(byArray, n, n2);
    }

    public byte[] getDigestValue() {
        return this.md.digest();
    }

    public InputStream getInputStream() {
        if (this.buffer) {
            return new ByteArrayInputStream(this.bos.toByteArray());
        }
        return null;
    }

    public void close() throws IOException {
        if (this.buffer) {
            this.bos.close();
        }
    }
}

