/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PostMethod
extends EntityEnclosingMethod {
    private static final Log LOG = LogFactory.getLog(PostMethod.class);
    public static final String FORM_URL_ENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private Vector params = new Vector();

    public PostMethod() {
    }

    public PostMethod(String string) {
        super(string);
    }

    @Override
    public String getName() {
        return "POST";
    }

    @Override
    protected boolean hasRequestContent() {
        LOG.trace("enter PostMethod.hasRequestContent()");
        if (!this.params.isEmpty()) {
            return true;
        }
        return super.hasRequestContent();
    }

    @Override
    protected void clearRequestBody() {
        LOG.trace("enter PostMethod.clearRequestBody()");
        this.params.clear();
        super.clearRequestBody();
    }

    @Override
    protected RequestEntity generateRequestEntity() {
        if (!this.params.isEmpty()) {
            String string = EncodingUtil.formUrlEncode(this.getParameters(), this.getRequestCharSet());
            ByteArrayRequestEntity byteArrayRequestEntity = new ByteArrayRequestEntity(EncodingUtil.getAsciiBytes(string), FORM_URL_ENCODED_CONTENT_TYPE);
            return byteArrayRequestEntity;
        }
        return super.generateRequestEntity();
    }

    public void setParameter(String string, String string2) {
        LOG.trace("enter PostMethod.setParameter(String, String)");
        this.removeParameter(string);
        this.addParameter(string, string2);
    }

    public NameValuePair getParameter(String string) {
        LOG.trace("enter PostMethod.getParameter(String)");
        if (string == null) {
            return null;
        }
        for (NameValuePair nameValuePair : this.params) {
            if (!string.equals(nameValuePair.getName())) continue;
            return nameValuePair;
        }
        return null;
    }

    public NameValuePair[] getParameters() {
        LOG.trace("enter PostMethod.getParameters()");
        int n = this.params.size();
        Object[] objectArray = this.params.toArray();
        NameValuePair[] nameValuePairArray = new NameValuePair[n];
        for (int i = 0; i < n; ++i) {
            nameValuePairArray[i] = (NameValuePair)objectArray[i];
        }
        return nameValuePairArray;
    }

    public void addParameter(String string, String string2) throws IllegalArgumentException {
        LOG.trace("enter PostMethod.addParameter(String, String)");
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Arguments to addParameter(String, String) cannot be null");
        }
        super.clearRequestBody();
        this.params.add(new NameValuePair(string, string2));
    }

    public void addParameter(NameValuePair nameValuePair) throws IllegalArgumentException {
        LOG.trace("enter PostMethod.addParameter(NameValuePair)");
        if (nameValuePair == null) {
            throw new IllegalArgumentException("NameValuePair may not be null");
        }
        this.addParameter(nameValuePair.getName(), nameValuePair.getValue());
    }

    public void addParameters(NameValuePair[] nameValuePairArray) {
        LOG.trace("enter PostMethod.addParameters(NameValuePair[])");
        if (nameValuePairArray == null) {
            LOG.warn("Attempt to addParameters(null) ignored");
        } else {
            super.clearRequestBody();
            for (int i = 0; i < nameValuePairArray.length; ++i) {
                this.params.add(nameValuePairArray[i]);
            }
        }
    }

    public boolean removeParameter(String string) throws IllegalArgumentException {
        LOG.trace("enter PostMethod.removeParameter(String)");
        if (string == null) {
            throw new IllegalArgumentException("Argument passed to removeParameter(String) cannot be null");
        }
        boolean bl = false;
        Iterator iterator = this.params.iterator();
        while (iterator.hasNext()) {
            NameValuePair nameValuePair = (NameValuePair)iterator.next();
            if (!string.equals(nameValuePair.getName())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeParameter(String string, String string2) throws IllegalArgumentException {
        LOG.trace("enter PostMethod.removeParameter(String, String)");
        if (string == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter value may not be null");
        }
        Iterator iterator = this.params.iterator();
        while (iterator.hasNext()) {
            NameValuePair nameValuePair = (NameValuePair)iterator.next();
            if (!string.equals(nameValuePair.getName()) || !string2.equals(nameValuePair.getValue())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void setRequestBody(NameValuePair[] nameValuePairArray) throws IllegalArgumentException {
        LOG.trace("enter PostMethod.setRequestBody(NameValuePair[])");
        if (nameValuePairArray == null) {
            throw new IllegalArgumentException("Array of parameters may not be null");
        }
        this.clearRequestBody();
        this.addParameters(nameValuePairArray);
    }
}

