/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InputStreamRequestEntity
implements RequestEntity {
    public static final int CONTENT_LENGTH_AUTO = -2;
    private static final Log LOG = LogFactory.getLog(InputStreamRequestEntity.class);
    private long contentLength;
    private InputStream content;
    private byte[] buffer = null;
    private String contentType;

    public InputStreamRequestEntity(InputStream inputStream) {
        this(inputStream, null);
    }

    public InputStreamRequestEntity(InputStream inputStream, String string) {
        this(inputStream, -2L, string);
    }

    public InputStreamRequestEntity(InputStream inputStream, long l) {
        this(inputStream, l, null);
    }

    public InputStreamRequestEntity(InputStream inputStream, long l, String string) {
        if (inputStream == null) {
            throw new IllegalArgumentException("The content cannot be null");
        }
        this.content = inputStream;
        this.contentLength = l;
        this.contentType = string;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    private void bufferContent() {
        if (this.buffer != null) {
            return;
        }
        if (this.content != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[4096];
                int n = 0;
                while ((n = this.content.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                this.buffer = byteArrayOutputStream.toByteArray();
                this.content = null;
                this.contentLength = this.buffer.length;
            }
            catch (IOException iOException) {
                LOG.error(iOException.getMessage(), iOException);
                this.buffer = null;
                this.content = null;
                this.contentLength = 0L;
            }
        }
    }

    @Override
    public boolean isRepeatable() {
        return this.buffer != null;
    }

    @Override
    public void writeRequest(OutputStream outputStream) throws IOException {
        if (this.content != null) {
            byte[] byArray = new byte[4096];
            int n = 0;
            int n2 = 0;
            while ((n2 = this.content.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
                n += n2;
            }
        } else if (this.buffer != null) {
            outputStream.write(this.buffer);
        } else {
            throw new IllegalStateException("Content must be set before entity is written");
        }
    }

    @Override
    public long getContentLength() {
        if (this.contentLength == -2L && this.buffer == null) {
            this.bufferContent();
        }
        return this.contentLength;
    }

    public InputStream getContent() {
        return this.content;
    }
}

