/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.Wire;
import org.apache.commons.httpclient.WireLogOutputStream;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.httpclient.util.ExceptionUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpConnection {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final Log LOG = LogFactory.getLog(HttpConnection.class);
    private String hostName = null;
    private int portNumber = -1;
    private String proxyHostName = null;
    private int proxyPortNumber = -1;
    private Socket socket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private InputStream lastResponseInputStream = null;
    protected boolean isOpen = false;
    private Protocol protocolInUse;
    private HttpConnectionParams params = new HttpConnectionParams();
    private boolean locked = false;
    private boolean usingSecureSocket = false;
    private boolean tunnelEstablished = false;
    private HttpConnectionManager httpConnectionManager;
    private InetAddress localAddress;

    public HttpConnection(String string, int n) {
        this(null, -1, string, null, n, Protocol.getProtocol("http"));
    }

    public HttpConnection(String string, int n, Protocol protocol) {
        this(null, -1, string, null, n, protocol);
    }

    public HttpConnection(String string, String string2, int n, Protocol protocol) {
        this(null, -1, string, string2, n, protocol);
    }

    public HttpConnection(String string, int n, String string2, int n2) {
        this(string, n, string2, null, n2, Protocol.getProtocol("http"));
    }

    public HttpConnection(HostConfiguration hostConfiguration) {
        this(hostConfiguration.getProxyHost(), hostConfiguration.getProxyPort(), hostConfiguration.getHost(), hostConfiguration.getPort(), hostConfiguration.getProtocol());
        this.localAddress = hostConfiguration.getLocalAddress();
    }

    public HttpConnection(String string, int n, String string2, String string3, int n2, Protocol protocol) {
        this(string, n, string2, n2, protocol);
    }

    public HttpConnection(String string, int n, String string2, int n2, Protocol protocol) {
        if (string2 == null) {
            throw new IllegalArgumentException("host parameter is null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        this.proxyHostName = string;
        this.proxyPortNumber = n;
        this.hostName = string2;
        this.portNumber = protocol.resolvePort(n2);
        this.protocolInUse = protocol;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    public String getHost() {
        return this.hostName;
    }

    public void setHost(String string) throws IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("host parameter is null");
        }
        this.assertNotOpen();
        this.hostName = string;
    }

    public String getVirtualHost() {
        return this.hostName;
    }

    public void setVirtualHost(String string) throws IllegalStateException {
        this.assertNotOpen();
    }

    public int getPort() {
        if (this.portNumber < 0) {
            return this.isSecure() ? 443 : 80;
        }
        return this.portNumber;
    }

    public void setPort(int n) throws IllegalStateException {
        this.assertNotOpen();
        this.portNumber = n;
    }

    public String getProxyHost() {
        return this.proxyHostName;
    }

    public void setProxyHost(String string) throws IllegalStateException {
        this.assertNotOpen();
        this.proxyHostName = string;
    }

    public int getProxyPort() {
        return this.proxyPortNumber;
    }

    public void setProxyPort(int n) throws IllegalStateException {
        this.assertNotOpen();
        this.proxyPortNumber = n;
    }

    public boolean isSecure() {
        return this.protocolInUse.isSecure();
    }

    public Protocol getProtocol() {
        return this.protocolInUse;
    }

    public void setProtocol(Protocol protocol) {
        this.assertNotOpen();
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        this.protocolInUse = protocol;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress inetAddress) {
        this.assertNotOpen();
        this.localAddress = inetAddress;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean closeIfStale() throws IOException {
        if (this.isOpen && this.isStale()) {
            LOG.debug("Connection is stale, closing...");
            this.close();
            return true;
        }
        return false;
    }

    public boolean isStaleCheckingEnabled() {
        return this.params.isStaleCheckingEnabled();
    }

    public void setStaleCheckingEnabled(boolean bl) {
        this.params.setStaleCheckingEnabled(bl);
    }

    protected boolean isStale() throws IOException {
        boolean bl;
        block10: {
            bl = true;
            if (this.isOpen) {
                bl = false;
                try {
                    if (this.inputStream.available() > 0) break block10;
                    try {
                        this.socket.setSoTimeout(1);
                        this.inputStream.mark(1);
                        int n = this.inputStream.read();
                        if (n == -1) {
                            bl = true;
                        } else {
                            this.inputStream.reset();
                        }
                    }
                    finally {
                        this.socket.setSoTimeout(this.params.getSoTimeout());
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (!ExceptionUtil.isSocketTimeoutException(interruptedIOException)) {
                        throw interruptedIOException;
                    }
                }
                catch (IOException iOException) {
                    LOG.debug("An error occurred while reading from the socket, is appears to be stale", iOException);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean isProxied() {
        return null != this.proxyHostName && 0 < this.proxyPortNumber;
    }

    public void setLastResponseInputStream(InputStream inputStream) {
        this.lastResponseInputStream = inputStream;
    }

    public InputStream getLastResponseInputStream() {
        return this.lastResponseInputStream;
    }

    public HttpConnectionParams getParams() {
        return this.params;
    }

    public void setParams(HttpConnectionParams httpConnectionParams) {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = httpConnectionParams;
    }

    public void setSoTimeout(int n) throws SocketException, IllegalStateException {
        this.params.setSoTimeout(n);
        if (this.socket != null) {
            this.socket.setSoTimeout(n);
        }
    }

    public void setSocketTimeout(int n) throws SocketException, IllegalStateException {
        this.assertOpen();
        if (this.socket != null) {
            this.socket.setSoTimeout(n);
        }
    }

    public int getSoTimeout() throws SocketException {
        return this.params.getSoTimeout();
    }

    public void setConnectionTimeout(int n) {
        this.params.setConnectionTimeout(n);
    }

    public void open() throws IOException {
        LOG.trace("enter HttpConnection.open()");
        String string = this.proxyHostName == null ? this.hostName : this.proxyHostName;
        int n = this.proxyHostName == null ? this.portNumber : this.proxyPortNumber;
        this.assertNotOpen();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Open connection to " + string + ":" + n);
        }
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            if (this.socket == null) {
                this.usingSecureSocket = this.isSecure() && !this.isProxied();
                ProtocolSocketFactory protocolSocketFactory = null;
                if (this.isSecure() && this.isProxied()) {
                    Protocol protocol = Protocol.getProtocol("http");
                    protocolSocketFactory = protocol.getSocketFactory();
                } else {
                    protocolSocketFactory = this.protocolInUse.getSocketFactory();
                }
                this.socket = protocolSocketFactory.createSocket(string, n, this.localAddress, 0, this.params);
            }
            this.socket.setTcpNoDelay(this.params.getTcpNoDelay());
            this.socket.setSoTimeout(this.params.getSoTimeout());
            int n6 = this.params.getLinger();
            if (n6 >= 0) {
                this.socket.setSoLinger(n6 > 0, n6);
            }
            if ((n5 = this.params.getSendBufferSize()) >= 0) {
                this.socket.setSendBufferSize(n5);
            }
            if ((n4 = this.params.getReceiveBufferSize()) >= 0) {
                this.socket.setReceiveBufferSize(n4);
            }
            if ((n3 = this.socket.getSendBufferSize()) > 2048 || n3 <= 0) {
                n3 = 2048;
            }
            if ((n2 = this.socket.getReceiveBufferSize()) > 2048 || n2 <= 0) {
                n2 = 2048;
            }
            this.inputStream = new BufferedInputStream(this.socket.getInputStream(), n2);
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream(), n3);
            this.isOpen = true;
        }
        catch (IOException iOException) {
            this.closeSocketAndStreams();
            throw iOException;
        }
    }

    public void tunnelCreated() throws IllegalStateException, IOException {
        int n;
        int n2;
        int n3;
        LOG.trace("enter HttpConnection.tunnelCreated()");
        if (!this.isSecure() || !this.isProxied()) {
            throw new IllegalStateException("Connection must be secure and proxied to use this feature");
        }
        if (this.usingSecureSocket) {
            throw new IllegalStateException("Already using a secure socket");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Secure tunnel to " + this.hostName + ":" + this.portNumber);
        }
        SecureProtocolSocketFactory secureProtocolSocketFactory = (SecureProtocolSocketFactory)this.protocolInUse.getSocketFactory();
        this.socket = secureProtocolSocketFactory.createSocket(this.socket, this.hostName, this.portNumber, true);
        int n4 = this.params.getSendBufferSize();
        if (n4 >= 0) {
            this.socket.setSendBufferSize(n4);
        }
        if ((n3 = this.params.getReceiveBufferSize()) >= 0) {
            this.socket.setReceiveBufferSize(n3);
        }
        if ((n2 = this.socket.getSendBufferSize()) > 2048) {
            n2 = 2048;
        }
        if ((n = this.socket.getReceiveBufferSize()) > 2048) {
            n = 2048;
        }
        this.inputStream = new BufferedInputStream(this.socket.getInputStream(), n);
        this.outputStream = new BufferedOutputStream(this.socket.getOutputStream(), n2);
        this.usingSecureSocket = true;
        this.tunnelEstablished = true;
    }

    public boolean isTransparent() {
        return !this.isProxied() || this.tunnelEstablished;
    }

    public void flushRequestOutputStream() throws IOException {
        LOG.trace("enter HttpConnection.flushRequestOutputStream()");
        this.assertOpen();
        this.outputStream.flush();
    }

    public OutputStream getRequestOutputStream() throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.getRequestOutputStream()");
        this.assertOpen();
        OutputStream outputStream = this.outputStream;
        if (Wire.CONTENT_WIRE.enabled()) {
            outputStream = new WireLogOutputStream(outputStream, Wire.CONTENT_WIRE);
        }
        return outputStream;
    }

    public InputStream getResponseInputStream() throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.getResponseInputStream()");
        this.assertOpen();
        return this.inputStream;
    }

    public boolean isResponseAvailable() throws IOException {
        LOG.trace("enter HttpConnection.isResponseAvailable()");
        if (this.isOpen) {
            return this.inputStream.available() > 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResponseAvailable(int n) throws IOException {
        LOG.trace("enter HttpConnection.isResponseAvailable(int)");
        this.assertOpen();
        boolean bl = false;
        if (this.inputStream.available() > 0) {
            bl = true;
        } else {
            try {
                this.socket.setSoTimeout(n);
                this.inputStream.mark(1);
                int n2 = this.inputStream.read();
                if (n2 != -1) {
                    this.inputStream.reset();
                    LOG.debug("Input data available");
                    bl = true;
                } else {
                    LOG.debug("Input data not available");
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!ExceptionUtil.isSocketTimeoutException(interruptedIOException)) {
                    throw interruptedIOException;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Input data not available after " + n + " ms");
                }
            }
            finally {
                try {
                    this.socket.setSoTimeout(this.params.getSoTimeout());
                }
                catch (IOException iOException) {
                    LOG.debug("An error ocurred while resetting soTimeout, we will assume that no response is available.", iOException);
                    bl = false;
                }
            }
        }
        return bl;
    }

    public void write(byte[] byArray) throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.write(byte[])");
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.write(byte[], int, int)");
        if (n < 0) {
            throw new IllegalArgumentException("Array offset may not be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Array length may not be negative");
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("Given offset and length exceed the array length");
        }
        this.assertOpen();
        this.outputStream.write(byArray, n, n2);
    }

    public void writeLine(byte[] byArray) throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.writeLine(byte[])");
        this.write(byArray);
        this.writeLine();
    }

    public void writeLine() throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.writeLine()");
        this.write(CRLF);
    }

    public void print(String string) throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.print(String)");
        this.write(EncodingUtil.getBytes(string, "ISO-8859-1"));
    }

    public void print(String string, String string2) throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.print(String)");
        this.write(EncodingUtil.getBytes(string, string2));
    }

    public void printLine(String string) throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.printLine(String)");
        this.writeLine(EncodingUtil.getBytes(string, "ISO-8859-1"));
    }

    public void printLine(String string, String string2) throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.printLine(String)");
        this.writeLine(EncodingUtil.getBytes(string, string2));
    }

    public void printLine() throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.printLine()");
        this.writeLine();
    }

    public String readLine() throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.readLine()");
        this.assertOpen();
        return HttpParser.readLine(this.inputStream);
    }

    public String readLine(String string) throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.readLine()");
        this.assertOpen();
        return HttpParser.readLine(this.inputStream, string);
    }

    public void shutdownOutput() {
        LOG.trace("enter HttpConnection.shutdownOutput()");
        try {
            Class[] classArray = new Class[]{};
            Method method = this.socket.getClass().getMethod("shutdownOutput", classArray);
            Object[] objectArray = new Object[]{};
            method.invoke((Object)this.socket, objectArray);
        }
        catch (Exception exception) {
            LOG.debug("Unexpected Exception caught", exception);
        }
    }

    public void close() {
        LOG.trace("enter HttpConnection.close()");
        this.closeSocketAndStreams();
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    public void releaseConnection() {
        LOG.trace("enter HttpConnection.releaseConnection()");
        if (this.locked) {
            LOG.debug("Connection is locked.  Call to releaseConnection() ignored.");
        } else if (this.httpConnectionManager != null) {
            LOG.debug("Releasing connection back to connection manager.");
            this.httpConnectionManager.releaseConnection(this);
        } else {
            LOG.warn("HttpConnectionManager is null.  Connection cannot be released.");
        }
    }

    protected boolean isLocked() {
        return this.locked;
    }

    protected void setLocked(boolean bl) {
        this.locked = bl;
    }

    protected void closeSocketAndStreams() {
        Closeable closeable;
        LOG.trace("enter HttpConnection.closeSockedAndStreams()");
        this.isOpen = false;
        this.lastResponseInputStream = null;
        if (null != this.outputStream) {
            closeable = this.outputStream;
            this.outputStream = null;
            try {
                ((OutputStream)closeable).close();
            }
            catch (Exception exception) {
                LOG.debug("Exception caught when closing output", exception);
            }
        }
        if (null != this.inputStream) {
            closeable = this.inputStream;
            this.inputStream = null;
            try {
                ((InputStream)closeable).close();
            }
            catch (Exception exception) {
                LOG.debug("Exception caught when closing input", exception);
            }
        }
        if (null != this.socket) {
            closeable = this.socket;
            this.socket = null;
            try {
                ((Socket)closeable).close();
            }
            catch (Exception exception) {
                LOG.debug("Exception caught when closing socket", exception);
            }
        }
        this.tunnelEstablished = false;
        this.usingSecureSocket = false;
    }

    protected void assertNotOpen() throws IllegalStateException {
        if (this.isOpen) {
            throw new IllegalStateException("Connection is open");
        }
    }

    protected void assertOpen() throws IllegalStateException {
        if (!this.isOpen) {
            throw new IllegalStateException("Connection is not open");
        }
    }

    public int getSendBufferSize() throws SocketException {
        if (this.socket == null) {
            return -1;
        }
        return this.socket.getSendBufferSize();
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.params.setSendBufferSize(n);
    }
}

