/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;

public abstract class TransformService
implements Transform {
    private String algorithm;
    private String mechanism;
    private Provider provider;

    protected TransformService() {
    }

    public static TransformService getInstance(String string, String string2) throws NoSuchAlgorithmException {
        if (string2 == null || string == null) {
            throw new NullPointerException();
        }
        return TransformService.findInstance(string, string2, null);
    }

    public static TransformService getInstance(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        if (string2 == null || string == null || provider == null) {
            throw new NullPointerException();
        }
        return TransformService.findInstance(string, string2, provider);
    }

    public static TransformService getInstance(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string == null || string3 == null) {
            throw new NullPointerException();
        }
        Provider provider = Security.getProvider(string3);
        if (provider == null) {
            throw new NoSuchProviderException("cannot find provider named " + string3);
        }
        return TransformService.findInstance(string, string2, provider);
    }

    private static TransformService findInstance(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        Provider.Service service;
        if (provider == null) {
            provider = TransformService.getProvider("TransformService", string, string2);
        }
        if ((service = provider.getService("TransformService", string)) == null) {
            throw new NoSuchAlgorithmException("no such algorithm: " + string + " for provider " + provider.getName());
        }
        TransformService transformService = (TransformService)service.newInstance(null);
        transformService.algorithm = string;
        transformService.mechanism = string2;
        transformService.provider = provider;
        return transformService;
    }

    private static Provider getProvider(String string, String string2, String string3) throws NoSuchAlgorithmException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string + "." + string2, "");
        hashMap.put(string + "." + string2 + " MechanismType", string3);
        Provider[] providerArray = Security.getProviders(hashMap);
        if (providerArray == null) {
            if (string3.equals("DOM")) {
                hashMap.clear();
                hashMap.put(string + "." + string2, "");
                providerArray = Security.getProviders(hashMap);
                if (providerArray != null) {
                    return providerArray[0];
                }
            }
            throw new NoSuchAlgorithmException("Algorithm type " + string2 + " not available");
        }
        return providerArray[0];
    }

    public final String getMechanismType() {
        return this.mechanism;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public abstract void init(TransformParameterSpec var1) throws InvalidAlgorithmParameterException;

    public abstract void marshalParams(XMLStructure var1, XMLCryptoContext var2) throws MarshalException;

    public abstract void init(XMLStructure var1, XMLCryptoContext var2) throws InvalidAlgorithmParameterException;
}

