/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ICSVParser;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCSVParser
implements ICSVParser {
    protected final char separator;
    protected final char quotechar;
    protected final CSVReaderNullFieldIndicator nullFieldIndicator;
    protected String pending;

    public AbstractCSVParser(char separator, char quotechar, CSVReaderNullFieldIndicator nullFieldIndicator) {
        this.separator = separator;
        this.quotechar = quotechar;
        this.nullFieldIndicator = nullFieldIndicator;
    }

    @Override
    public char getSeparator() {
        return this.separator;
    }

    @Override
    public char getQuotechar() {
        return this.quotechar;
    }

    @Override
    public boolean isPending() {
        return this.pending != null;
    }

    @Override
    public String[] parseLineMulti(String nextLine) throws IOException {
        return this.parseLine(nextLine, true);
    }

    @Override
    public String[] parseLine(String nextLine) throws IOException {
        return this.parseLine(nextLine, false);
    }

    @Override
    public String parseToLine(String[] values, boolean applyQuotesToAll) {
        StringBuilder builder = new StringBuilder(1024);
        for (int i = 0; i < values.length; ++i) {
            builder.append(this.convertToCsvValue(values[i], applyQuotesToAll));
            if (i >= values.length - 1) continue;
            builder.append(this.getSeparator());
        }
        return builder.toString();
    }

    protected abstract String convertToCsvValue(String var1, boolean var2);

    protected boolean isSurroundWithQuotes(String value, boolean forceSurround) {
        if (value == null) {
            return this.nullFieldIndicator.equals((Object)CSVReaderNullFieldIndicator.EMPTY_QUOTES);
        }
        return forceSurround || value.contains(Character.toString(this.getSeparator())) || value.contains("\n");
    }

    protected abstract String[] parseLine(String var1, boolean var2) throws IOException;

    @Override
    public CSVReaderNullFieldIndicator nullFieldIndicator() {
        return this.nullFieldIndicator;
    }

    @Override
    public String getPendingText() {
        return StringUtils.defaultString(this.pending);
    }
}

