/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPane;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GlenixVBox
extends VBox
implements GlenixController,
GlenixPane {
    private String glenixElementDescription;
    private String glenixElementGuidance;
    private String glenixElementTRLabel;
    private String glenixElementName;
    private String glenixElementNamespace;
    private String glenixElementDefaultValue;
    private String glenixElementImmutableValue;
    HashMap gcs = null;

    @Override
    public GlenixController getGlenixController() {
        return this;
    }

    @Override
    public GlenixPane getGlenixPane() {
        return this;
    }

    public void initialize(URL url, ResourceBundle rb) {
    }

    @Override
    public Pane getPane() {
        return this;
    }

    @Override
    public int getMaxColumns(Number newStageWidth) {
        return 4;
    }

    private void buildGlenixXBRLSubComponent(Node component, Document resultDoc, Element resultElement) throws Exception {
        if (component instanceof GlenixController) {
            ((GlenixController)component).buildGlenixXBRL(resultDoc, resultElement);
        } else if (component instanceof GlenixPane) {
            GlenixController gc = ((GlenixPane)component).getGlenixController();
            gc.buildGlenixXBRL(resultDoc, resultElement);
        } else if (component instanceof ScrollPane) {
            this.buildGlenixXBRLSubScrollPane((ScrollPane)component, resultDoc, resultElement);
        } else if (component instanceof TitledPane) {
            this.buildGlenixXBRLSubTitledPane((TitledPane)component, resultDoc, resultElement);
        } else if (component instanceof Pane) {
            this.buildGlenixXBRLSub((Pane)component, resultDoc, resultElement);
        }
    }

    private void buildGlenixXBRLSubScrollPane(ScrollPane scrollPane, Document resultDoc, Element resultElement) throws Exception {
        Node component = scrollPane.getContent();
        this.buildGlenixXBRLSubComponent(component, resultDoc, resultElement);
    }

    protected void buildGlenixXBRLSubTitledPane(TitledPane titledPane, Document resultDoc, Element resultElement) throws Exception {
        Node component = titledPane.getContent();
        this.buildGlenixXBRLSubComponent(component, resultDoc, resultElement);
    }

    private void buildGlenixXBRLSub(Pane pane, Document resultDoc, Element resultElement) throws Exception {
        for (Node component : pane.getChildren()) {
            this.buildGlenixXBRLSubComponent(component, resultDoc, resultElement);
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        String namespace = this.getGlenixElementNamespace();
        String name = this.getGlenixElementName();
        if (name != null && namespace != null) {
            String nsp = GlenixController.getNSP(namespace);
            Element el = resultDoc.createElementNS(namespace, nsp + ":" + name);
            if (resultElement == null) {
                resultDoc.appendChild(el);
            } else {
                resultElement.appendChild(el);
            }
            this.buildGlenixXBRLSub(this.getPane(), resultDoc, el);
        } else {
            this.buildGlenixXBRLSub(this.getPane(), resultDoc, resultElement);
        }
    }

    @Override
    public String getGlenixElementDescription() {
        return this.glenixElementDescription;
    }

    @Override
    public void setGlenixElementDescription(String glenixElementDescription) {
        this.glenixElementDescription = glenixElementDescription;
    }

    @Override
    public String getGlenixElementGuidance() {
        return this.glenixElementGuidance;
    }

    @Override
    public void setGlenixElementGuidance(String glenixElementGuidance) {
        this.glenixElementGuidance = glenixElementGuidance;
    }

    @Override
    public String getGlenixElementTRLabel() {
        return this.glenixElementTRLabel;
    }

    @Override
    public void setGlenixElementTRLabel(String glenixElementTRLabel) {
        this.glenixElementTRLabel = glenixElementTRLabel;
    }

    @Override
    public String getGlenixElementValue() {
        return null;
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
    }

    @Override
    public String getGlenixElementName() {
        return this.glenixElementName;
    }

    @Override
    public void setGlenixElementName(String glenixElementName) {
        this.glenixElementName = glenixElementName;
    }

    @Override
    public String getGlenixElementNamespace() {
        return this.glenixElementNamespace;
    }

    @Override
    public void setGlenixElementNamespace(String glenixElementNamespace) {
        this.glenixElementNamespace = glenixElementNamespace;
    }

    @Override
    public String getGlenixElementDefaultValue() {
        return this.glenixElementDefaultValue;
    }

    @Override
    public void setGlenixElementDefaultValue(String glenixElementDefaultValue) {
        this.glenixElementDefaultValue = glenixElementDefaultValue;
    }

    @Override
    public String getGlenixElementImmutableValue() {
        return this.glenixElementImmutableValue;
    }

    @Override
    public void setGlenixElementImmutableValue(String glenixElementImmutableValue) {
        this.glenixElementImmutableValue = glenixElementImmutableValue;
    }

    protected void invalidateComponentsCache() {
        this.gcs = null;
    }

    private void buildGCHashComponent(Node component) {
        if (component instanceof GlenixController) {
            this.gcs.put(((GlenixController)component).getGlenixElementName() + "-" + ((GlenixController)component).getGlenixElementNamespace(), component);
        } else if (component instanceof GlenixPane) {
            GlenixController gc = ((GlenixPane)component).getGlenixController();
            if (gc != null) {
                this.gcs.put(gc.getGlenixElementName() + "-" + gc.getGlenixElementNamespace(), gc);
            }
        } else if (component instanceof ScrollPane) {
            this.buildGCHashScrollPane((ScrollPane)component);
        } else if (component instanceof TitledPane) {
            this.buildGCHashTitledPane((TitledPane)component);
        } else if (component instanceof Pane) {
            this.buildGCHash((Pane)component);
        }
    }

    private void buildGCHashScrollPane(ScrollPane scrollPane) {
        Node child = scrollPane.getContent();
        if (child != null) {
            this.buildGCHashComponent(child);
        }
    }

    private void buildGCHashTitledPane(TitledPane titledPane) {
        Node child = titledPane.getContent();
        if (child != null) {
            this.buildGCHashComponent(child);
        }
    }

    private void buildGCHash(Pane pane) {
        for (Node component : pane.getChildren()) {
            this.buildGCHashComponent(component);
        }
    }

    public GlenixController getGlenixControllerByNameNS(String namespace, String name) {
        if (this.gcs == null) {
            this.gcs = new HashMap();
            this.buildGCHash(this.getPane());
        }
        return (GlenixController)this.gcs.get(name + "-" + namespace);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                GlenixController gc;
                org.w3c.dom.Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (gc = this.getGlenixControllerByNameNS((el = (Element)node).getNamespaceURI(), el.getLocalName())) == null) continue;
                gc.loadGlenixXBRL(loadDoc, el);
            }
        }
    }

    private void clearGlenixXBRLSubComponent(Node component) {
        if (component instanceof GlenixController) {
            ((GlenixController)component).clearGlenixXBRL();
        } else if (component instanceof GlenixPane) {
            GlenixController gc = ((GlenixPane)component).getGlenixController();
            if (gc != null) {
                gc.clearGlenixXBRL();
            }
        } else if (component instanceof ScrollPane) {
            this.clearGlenixXBRLSubScrollPane((ScrollPane)component);
        } else if (component instanceof TitledPane) {
            this.clearGlenixXBRLSubTitledPane((TitledPane)component);
        } else if (component instanceof Pane) {
            this.clearGlenixXBRLSub((Pane)component);
        }
    }

    private void clearGlenixXBRLSubScrollPane(ScrollPane scrollPane) {
        Node component = scrollPane.getContent();
        this.clearGlenixXBRLSubComponent(component);
    }

    private void clearGlenixXBRLSubTitledPane(TitledPane titledPane) {
        Node component = titledPane.getContent();
        this.clearGlenixXBRLSubComponent(component);
    }

    private void clearGlenixXBRLSub(Pane pane) {
        for (Node component : pane.getChildren()) {
            this.clearGlenixXBRLSubComponent(component);
        }
    }

    @Override
    public void clearGlenixXBRL() {
        for (Node component : this.getChildren()) {
            this.clearGlenixXBRLSubComponent(component);
        }
    }

    private void disableGlenixXBRLSubComponent(Node component) {
        if (component instanceof GlenixController) {
            ((GlenixController)component).disableGlenixXBRL();
        } else if (component instanceof GlenixPane) {
            GlenixController gc = ((GlenixPane)component).getGlenixController();
            if (gc != null) {
                gc.disableGlenixXBRL();
            }
        } else if (component instanceof ScrollPane) {
            this.disableGlenixXBRLSubScrollPane((ScrollPane)component);
        } else if (component instanceof TitledPane) {
            this.disableGlenixXBRLSubTitledPane((TitledPane)component);
        } else if (component instanceof Pane) {
            this.disableGlenixXBRLSub((Pane)component);
        }
    }

    private void disableGlenixXBRLSubScrollPane(ScrollPane scrollPane) {
        Node component = scrollPane.getContent();
        this.disableGlenixXBRLSubComponent(component);
    }

    private void disableGlenixXBRLSubTitledPane(TitledPane titledPane) {
        Node component = titledPane.getContent();
        this.disableGlenixXBRLSubComponent(component);
    }

    private void disableGlenixXBRLSub(Pane pane) {
        for (Node component : pane.getChildren()) {
            this.disableGlenixXBRLSubComponent(component);
        }
    }

    @Override
    public void disableGlenixXBRL() {
        for (Node component : this.getChildren()) {
            this.disableGlenixXBRLSubComponent(component);
        }
    }

    private void enableGlenixXBRLSubComponent(Node component) {
        if (component instanceof GlenixController) {
            ((GlenixController)component).enableGlenixXBRL();
        } else if (component instanceof GlenixPane) {
            GlenixController gc = ((GlenixPane)component).getGlenixController();
            if (gc != null) {
                gc.enableGlenixXBRL();
            }
        } else if (component instanceof ScrollPane) {
            this.enableGlenixXBRLSubScrollPane((ScrollPane)component);
        } else if (component instanceof TitledPane) {
            this.enableGlenixXBRLSubTitledPane((TitledPane)component);
        } else if (component instanceof Pane) {
            this.enableGlenixXBRLSub((Pane)component);
        }
    }

    private void enableGlenixXBRLSubScrollPane(ScrollPane scrollPane) {
        Node component = scrollPane.getContent();
        this.enableGlenixXBRLSubComponent(component);
    }

    private void enableGlenixXBRLSubTitledPane(TitledPane titledPane) {
        Node component = titledPane.getContent();
        this.enableGlenixXBRLSubComponent(component);
    }

    private void enableGlenixXBRLSub(Pane pane) {
        for (Node component : pane.getChildren()) {
            this.enableGlenixXBRLSubComponent(component);
        }
    }

    @Override
    public void enableGlenixXBRL() {
        for (Node component : this.getChildren()) {
            this.enableGlenixXBRLSubComponent(component);
        }
    }

    private boolean buildPDFSectionHasValue(Node node) {
        block8: {
            block7: {
                if (!node.isVisible()) {
                    return false;
                }
                if (node instanceof GlenixPane) {
                    GlenixPane gp = (GlenixPane)node;
                    return gp.hasPDFValue();
                }
                if (node instanceof Label) {
                    return false;
                }
                if (node instanceof ScrollPane) {
                    ScrollPane gp = (ScrollPane)node;
                    Node contentNode = gp.getContent();
                    return this.buildPDFSectionHasValue(contentNode);
                }
                if (node instanceof TitledPane) {
                    TitledPane gp = (TitledPane)node;
                    Node contentNode = gp.getContent();
                    return this.buildPDFSectionHasValue(contentNode);
                }
                if (!(node instanceof FlowPane)) break block7;
                FlowPane fp = (FlowPane)node;
                for (Node childNode : fp.getChildren()) {
                    if (!this.buildPDFSectionHasValue(childNode)) continue;
                    return true;
                }
                break block8;
            }
            if (!(node instanceof Pane)) break block8;
            Pane p = (Pane)node;
            for (Node childNode : p.getChildren()) {
                if (!this.buildPDFSectionHasValue(childNode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasPDFValue() {
        String val = this.getGlenixElementValue();
        if (val == null) {
            for (Node childNode : this.getChildren()) {
                if (!this.buildPDFSectionHasValue(childNode)) continue;
                return true;
            }
        } else if (val != null && !val.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSearchText(String searchText) {
        String val = this.getGlenixElementValue();
        if (val != null && !val.isEmpty() && val.toLowerCase().contains(searchText)) {
            return true;
        }
        val = this.getGlenixElementDescription();
        return val != null && !val.isEmpty() && val.toLowerCase().contains(searchText);
    }

    @Override
    public boolean doPDFOutput(boolean printblanks) {
        if (printblanks) {
            return true;
        }
        return this.hasPDFValue();
    }

    @Override
    public String getPDFValueImageRight() {
        return null;
    }

    @Override
    public String getPDFValueImageLeft() {
        return null;
    }

    @Override
    public String getPDFLabelLetter() {
        return null;
    }

    @Override
    public String getPDFValueAlignment() {
        return null;
    }

    @Override
    public String getPDFValue() {
        return null;
    }

    @Override
    public String getPDFLabel() {
        return null;
    }

    @Override
    public List<Node> getPDFChildNodes() {
        return this.getChildren();
    }

    @Override
    public Double getPDFFontSize() {
        return 13.0;
    }

    @Override
    public Double getPDFValueWidthRatio() {
        return 0.25;
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        throw new Exception("Error, Glenix Label does not implement build pdf");
    }
}

