/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixPane;
import au.com.glenix.widget.GlenixTitledPaneController;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class GlenixTitledPane
extends TitledPane
implements GlenixPane {
    protected GlenixController controller = null;
    private String glenixElementDescription;
    private String glenixElementName;
    private String glenixElementNamespace;
    private String glenixElementDefaultValue;

    @Override
    public GlenixController getGlenixController() {
        if (this.controller != null) {
            return this.controller;
        }
        this.controller = new GlenixTitledPaneController();
        return this.controller;
    }

    @Override
    public String getGlenixElementDescription() {
        return this.glenixElementDescription;
    }

    @Override
    public void setGlenixElementDescription(String glenixElementDescription) {
        if (this.controller != null) {
            this.controller.setGlenixElementDescription(glenixElementDescription);
        }
        this.glenixElementDescription = glenixElementDescription;
    }

    @Override
    public String getGlenixElementName() {
        return this.glenixElementName;
    }

    @Override
    public void setGlenixElementName(String glenixElementName) {
        if (this.controller != null) {
            this.controller.setGlenixElementName(glenixElementName);
        }
        this.glenixElementName = glenixElementName;
    }

    @Override
    public String getGlenixElementNamespace() {
        return this.glenixElementNamespace;
    }

    @Override
    public void setGlenixElementNamespace(String glenixElementNamespace) {
        if (this.controller != null) {
            this.controller.setGlenixElementNamespace(glenixElementNamespace);
        }
        this.glenixElementNamespace = glenixElementNamespace;
    }

    @Override
    public String getGlenixElementDefaultValue() {
        return this.glenixElementDefaultValue;
    }

    @Override
    public void setGlenixElementDefaultValue(String glenixElementDefaultValue) {
        if (this.controller != null) {
            this.controller.setGlenixElementDefaultValue(glenixElementDefaultValue);
        }
        this.glenixElementDefaultValue = glenixElementDefaultValue;
    }

    @Override
    public String getGlenixElementImmutableValue() {
        return this.controller.getGlenixElementImmutableValue();
    }

    @Override
    public void setGlenixElementImmutableValue(String glenixElementImmutableValue) {
        if (this.controller != null) {
            this.controller.setGlenixElementImmutableValue(glenixElementImmutableValue);
        }
    }

    @Override
    public String getGlenixElementValue() {
        return null;
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
    }

    @Override
    public void clearGlenixXBRL() {
        GlenixController gc = this.getGlenixController();
        if (gc != null) {
            gc.clearGlenixXBRL();
        }
    }

    @Override
    public void loadGlenixXBRL(Document doc, Element root) throws Exception {
        GlenixController gc = this.getGlenixController();
        if (gc != null) {
            gc.loadGlenixXBRL(doc, root);
        }
    }

    private boolean buildPDFSectionHasValue(Node node) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        if (!node.isVisible()) {
                            return false;
                        }
                        if (node instanceof Label) {
                            return false;
                        }
                        if (node instanceof GlenixPane) {
                            GlenixPane gp = (GlenixPane)node;
                            return gp.hasPDFValue();
                        }
                        if (!(node instanceof TitledPane)) break block7;
                        Node childNode = ((TitledPane)node).getContent();
                        if (this.buildPDFSectionHasValue(childNode)) {
                            return true;
                        }
                        break block8;
                    }
                    if (!(node instanceof ScrollPane)) break block9;
                    Node childNode = ((ScrollPane)node).getContent();
                    if (this.buildPDFSectionHasValue(childNode)) {
                        return true;
                    }
                    break block8;
                }
                if (!(node instanceof FlowPane)) break block10;
                FlowPane fp = (FlowPane)node;
                for (Node childNode : fp.getChildren()) {
                    if (!this.buildPDFSectionHasValue(childNode)) continue;
                    return true;
                }
                break block8;
            }
            if (!(node instanceof Pane)) break block8;
            Pane p = (Pane)node;
            for (Node childNode : p.getChildren()) {
                if (!this.buildPDFSectionHasValue(childNode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasPDFValue() {
        Node childNode = this.getContent();
        return this.buildPDFSectionHasValue(childNode);
    }

    @Override
    public boolean hasSearchText(String searchText) {
        String val = this.getText();
        if (val != null && !val.isEmpty() && val.toLowerCase().contains(searchText)) {
            return true;
        }
        val = this.getGlenixElementValue();
        if (val != null && !val.isEmpty() && val.toLowerCase().contains(searchText)) {
            return true;
        }
        val = this.getGlenixElementDescription();
        return val != null && !val.isEmpty() && val.toLowerCase().contains(searchText);
    }

    @Override
    public boolean doPDFOutput(boolean printblanks) {
        if (printblanks) {
            return true;
        }
        return this.hasPDFValue();
    }

    @Override
    public String getPDFValueImageRight() {
        return null;
    }

    @Override
    public String getPDFValueImageLeft() {
        return null;
    }

    @Override
    public String getPDFLabelLetter() {
        return null;
    }

    @Override
    public String getPDFValueAlignment() {
        return null;
    }

    @Override
    public String getPDFValue() {
        return this.getGlenixElementValue();
    }

    @Override
    public String getPDFLabel() {
        return this.getGlenixElementDescription();
    }

    @Override
    public List<Node> getPDFChildNodes() {
        Node content = this.getContent();
        if (content == null) {
            return null;
        }
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(content);
        return result;
    }

    @Override
    public Double getPDFFontSize() {
        return this.getFont().getSize();
    }

    @Override
    public Double getPDFValueWidthRatio() {
        return 0.25;
    }
}

