/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.encoding.WinAnsiEncoding;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class GlenixPDFWrapper {
    static float UNITS_TO_MM = 0.35277778f;
    static float MM_TO_UNITS = 2.8346457f;
    private Double ruleOffSpacing = 2.0;
    private Double marginBottom = 20.0;
    private Double footerPosY = 10.0;
    private PDDocument document;
    public PDFont muliLightFont;
    public PDFont muliRegularFont;
    public PDFont muliBoldFont;
    private ArrayList<ColumnInfo> columnInfoList = null;
    private int[] tpHeadingColumns = null;
    private int currentTPHeadingColumnIndex = 0;
    private GlenixPDFWrapperNewPageCallback glenixPDFWrapperNewPageCallback;
    private ArrayList<PDFWrapperImage> images = new ArrayList();
    private PDPage page;
    int currentPageIndex = -1;
    private ArrayList<Double> pageTops = new ArrayList();
    private ArrayList<Double> pageWidths = new ArrayList();
    private String orientation = null;

    public GlenixPDFWrapper() {
        this.document = new PDDocument();
        try {
            this.muliLightFont = PDTrueTypeFont.loadTTF(this.document, this.getClass().getResourceAsStream("/muli/Muli-Light.ttf"));
            this.muliRegularFont = PDTrueTypeFont.loadTTF(this.document, this.getClass().getResourceAsStream("/muli/Muli-Regular.ttf"));
            this.muliBoldFont = PDTrueTypeFont.loadTTF(this.document, this.getClass().getResourceAsStream("/muli/Muli-Bold.ttf"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAddPageCallback(GlenixPDFWrapperNewPageCallback cb) {
        this.glenixPDFWrapperNewPageCallback = cb;
    }

    public void addImage(byte[] byteArray, String fileName, String imageLocation, Double width, Double height) throws IOException {
        PDImageXObject pdImage = PDImageXObject.createFromByteArray(this.document, byteArray, fileName);
        PDFWrapperImage pwi = new PDFWrapperImage(pdImage);
        this.images.add(pwi);
        pwi.setImageLocation(imageLocation);
        pwi.setWidth(width);
        pwi.setHeight(height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFooter() throws Exception {
        int pageCount = this.document.getNumberOfPages();
        for (int i = 0; i < pageCount; ++i) {
            PDPage aPage = this.document.getPage(i);
            try (PDPageContentStream contentStream = new PDPageContentStream(this.document, aPage, true, true);){
                contentStream.beginText();
                contentStream.moveTextPositionByAmount(new Float(20.0 * (double)MM_TO_UNITS).floatValue(), new Float(this.footerPosY * (double)MM_TO_UNITS).floatValue());
                PDFont footerfont = null;
                if (this.columnInfoList.size() >= 3) {
                    footerfont = this.getColumnFont(2);
                } else if (this.columnInfoList.size() >= 2) {
                    footerfont = this.getColumnFont(1);
                } else if (this.columnInfoList.size() >= 1) {
                    footerfont = this.getColumnFont(0);
                }
                if (footerfont == null) {
                    footerfont = PDType1Font.HELVETICA;
                }
                contentStream.setFont(footerfont, 9.0f);
                contentStream.setNonStrokingColor(Color.GRAY);
                contentStream.drawString("printed by www.freeaccountingsoftware.com.au - desktop");
                contentStream.endText();
                contentStream.beginText();
                String pagenumberingtext = "Page " + (i + 1) + " of " + pageCount;
                Float strWidth = Float.valueOf(footerfont.getStringWidth(pagenumberingtext) * 9.0f / 1000.0f);
                contentStream.setNonStrokingColor(Color.BLACK);
                contentStream.moveTextPositionByAmount(new Float(this.getCurrentPageWidth() - (double)strWidth.floatValue()).floatValue(), new Float(this.footerPosY * (double)MM_TO_UNITS).floatValue());
                contentStream.drawString(pagenumberingtext);
                contentStream.endText();
                continue;
            }
        }
    }

    public void writeToFile(File file) throws Exception {
        this.document.save(file);
    }

    public void close() throws Exception {
        this.document.close();
    }

    public void setColumns(int columns) throws Exception {
        this.columnInfoList = new ArrayList();
        for (int i = 0; i < columns; ++i) {
            ColumnInfo ci = new ColumnInfo();
            ci.resetCurrentTop();
            this.columnInfoList.add(ci);
        }
    }

    public void setColumnLeftPosAndWidth(int index, Double left, Double width) throws Exception {
        ColumnInfo columnInfo = this.columnInfoList.get(index);
        columnInfo.setLeftPosAndWidth(left, width);
    }

    public void setColumnLeftPosAndWidthMM(int index, Double left, Double width) throws Exception {
        ColumnInfo columnInfo = this.columnInfoList.get(index);
        columnInfo.setLeftPosAndWidthMM(left, width);
    }

    public void setTPColumnLeftPosAndWidthMM(Double labelLeft, Double labelWidth, Double letterLeft, Double letterWidth, Double valueLeft, Double valueWidth) throws Exception {
        if (this.tpHeadingColumns == null) {
            throw new Exception("Error, trying to set titled pane column widths but no titled pane columns set");
        }
        if (this.currentTPHeadingColumnIndex >= this.tpHeadingColumns.length) {
            throw new Exception("Error, trying to set titled pane column widths but titled pane index out of bounds");
        }
        ColumnInfo columnInfo = this.columnInfoList.get(this.tpHeadingColumns[0]);
        Double baseLeft = columnInfo.getLeftPosMM();
        columnInfo = this.columnInfoList.get(this.tpHeadingColumns[this.currentTPHeadingColumnIndex]);
        Double currentLeft = columnInfo.getLeftPosMM();
        Double incLeft = currentLeft - baseLeft;
        columnInfo = this.columnInfoList.get(this.tpHeadingColumns[this.currentTPHeadingColumnIndex] + 2);
        columnInfo.setLeftPosAndWidthMM(labelLeft + incLeft, labelWidth);
        columnInfo = this.columnInfoList.get(this.tpHeadingColumns[this.currentTPHeadingColumnIndex] + 3);
        columnInfo.setLeftPosAndWidthMM(letterLeft + incLeft, letterWidth);
        columnInfo = this.columnInfoList.get(this.tpHeadingColumns[this.currentTPHeadingColumnIndex] + 4);
        columnInfo.setLeftPosAndWidthMM(valueLeft + incLeft, valueWidth);
    }

    public Double getPageTop(int index) {
        return this.pageTops.get(index);
    }

    public Double getCurrentPageTop() {
        return this.getPageTop(this.currentPageIndex);
    }

    public Double getPageWidth(int index) {
        return this.pageWidths.get(index);
    }

    public Double getCurrentPageWidth() {
        return this.getPageWidth(this.currentPageIndex);
    }

    public void addPDPageLandscape() throws Exception {
        this.orientation = "landscape";
        this.addPDPage(new Double(PDRectangle.A4.getHeight()), new Double(PDRectangle.A4.getWidth()), 286.0 * (double)MM_TO_UNITS, 200.0 * (double)MM_TO_UNITS);
    }

    public void addPDPage() throws Exception {
        this.orientation = "portrait";
        this.addPDPage(new Double(PDRectangle.A4.getWidth()), new Double(PDRectangle.A4.getHeight()), 200.0 * (double)MM_TO_UNITS, 286.0 * (double)MM_TO_UNITS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPDPage(Double pageWidth, Double pageHeight, Double horizontalEnd, Double topEnd) throws Exception {
        this.page = new PDPage(new PDRectangle(pageWidth.floatValue(), pageHeight.floatValue()));
        this.document.addPage(this.page);
        ++this.currentPageIndex;
        this.pageTops.add(this.currentPageIndex, topEnd);
        this.pageWidths.add(this.currentPageIndex, horizontalEnd);
        try (PDPageContentStream contentStream = new PDPageContentStream(this.document, this.page);){
            for (PDFWrapperImage pwi : this.images) {
                Double y;
                Double x;
                Double height;
                Double width;
                PDImageXObject pdImage = pwi.getPDImage();
                String imageLocation = pwi.getImageLocation();
                if (imageLocation == null) continue;
                if (imageLocation.equals("all_top_right")) {
                    width = pwi.getWidth();
                    if (width == null) {
                        width = 100.0;
                    }
                    width = width * (double)MM_TO_UNITS;
                    height = pwi.getHeight();
                    if (height == null) {
                        height = 40.0;
                    }
                    height = height * (double)MM_TO_UNITS;
                    x = horizontalEnd - width;
                    y = topEnd - height;
                    contentStream.drawImage(pdImage, x.floatValue(), y.floatValue(), width.floatValue(), height.floatValue());
                    continue;
                }
                if (imageLocation.equals("all_top_left")) {
                    width = pwi.getWidth();
                    if (width == null) {
                        width = 100.0;
                    }
                    width = width * (double)MM_TO_UNITS;
                    height = pwi.getHeight();
                    if (height == null) {
                        height = 40.0;
                    }
                    height = height * (double)MM_TO_UNITS;
                    x = 20.0 * (double)MM_TO_UNITS;
                    y = topEnd - height;
                    contentStream.drawImage(pdImage, x.floatValue(), y.floatValue(), width.floatValue(), height.floatValue());
                    continue;
                }
                if (imageLocation.equals("all_bottom_right")) {
                    width = pwi.getWidth();
                    if (width == null) {
                        width = 100.0;
                    }
                    width = width * (double)MM_TO_UNITS;
                    height = pwi.getHeight();
                    if (height == null) {
                        height = 40.0;
                    }
                    height = height * (double)MM_TO_UNITS;
                    x = horizontalEnd - width;
                    y = this.marginBottom * (double)MM_TO_UNITS;
                    contentStream.drawImage(pdImage, x.floatValue(), y.floatValue(), width.floatValue(), height.floatValue());
                    continue;
                }
                if (imageLocation.equals("all_bottom_left")) {
                    width = pwi.getWidth();
                    if (width == null) {
                        width = 100.0;
                    }
                    width = width * (double)MM_TO_UNITS;
                    height = pwi.getHeight();
                    if (height == null) {
                        height = 40.0;
                    }
                    height = height * (double)MM_TO_UNITS;
                    x = 20.0 * (double)MM_TO_UNITS;
                    y = this.marginBottom * (double)MM_TO_UNITS;
                    contentStream.drawImage(pdImage, x.floatValue(), y.floatValue(), width.floatValue(), height.floatValue());
                    continue;
                }
                if (imageLocation.equals("all_mid_right")) {
                    width = pwi.getWidth();
                    if (width == null) {
                        width = 100.0;
                    }
                    width = width * (double)MM_TO_UNITS;
                    height = pwi.getHeight();
                    if (height == null) {
                        height = 40.0;
                    }
                    height = height * (double)MM_TO_UNITS;
                    x = horizontalEnd - width;
                    y = this.marginBottom * (double)MM_TO_UNITS + (topEnd - this.marginBottom * (double)MM_TO_UNITS - height) / 2.0;
                    contentStream.drawImage(pdImage, x.floatValue(), y.floatValue(), width.floatValue(), height.floatValue());
                    continue;
                }
                if (imageLocation.equals("all_mid_left")) {
                    width = pwi.getWidth();
                    if (width == null) {
                        width = 100.0;
                    }
                    width = width * (double)MM_TO_UNITS;
                    height = pwi.getHeight();
                    if (height == null) {
                        height = 40.0;
                    }
                    height = height * (double)MM_TO_UNITS;
                    x = 20.0 * (double)MM_TO_UNITS;
                    y = this.marginBottom * (double)MM_TO_UNITS + (topEnd - this.marginBottom * (double)MM_TO_UNITS - height) / 2.0;
                    contentStream.drawImage(pdImage, x.floatValue(), y.floatValue(), width.floatValue(), height.floatValue());
                    continue;
                }
                if (imageLocation.equals("all_top_centre")) {
                    width = pwi.getWidth();
                    if (width == null) {
                        width = 100.0;
                    }
                    width = width * (double)MM_TO_UNITS;
                    height = pwi.getHeight();
                    if (height == null) {
                        height = 40.0;
                    }
                    height = height * (double)MM_TO_UNITS;
                    x = 20.0 + (horizontalEnd - 20.0 - width) / 2.0;
                    y = topEnd - height;
                    contentStream.drawImage(pdImage, x.floatValue(), y.floatValue(), width.floatValue(), height.floatValue());
                    continue;
                }
                if (imageLocation.equals("all_bottom_centre")) {
                    width = pwi.getWidth();
                    if (width == null) {
                        width = 100.0;
                    }
                    width = width * (double)MM_TO_UNITS;
                    height = pwi.getHeight();
                    if (height == null) {
                        height = 40.0;
                    }
                    height = height * (double)MM_TO_UNITS;
                    x = 20.0 + (horizontalEnd - 20.0 - width) / 2.0;
                    y = this.marginBottom * (double)MM_TO_UNITS;
                    contentStream.drawImage(pdImage, x.floatValue(), y.floatValue(), width.floatValue(), height.floatValue());
                    continue;
                }
                if (!imageLocation.equals("all_mid_centre")) continue;
                width = pwi.getWidth();
                if (width == null) {
                    width = 100.0;
                }
                width = width * (double)MM_TO_UNITS;
                height = pwi.getHeight();
                if (height == null) {
                    height = 40.0;
                }
                height = height * (double)MM_TO_UNITS;
                x = 20.0 + (horizontalEnd - 20.0 - width) / 2.0;
                y = this.marginBottom * (double)MM_TO_UNITS + (topEnd - this.marginBottom * (double)MM_TO_UNITS - height) / 2.0;
                contentStream.drawImage(pdImage, x.floatValue(), y.floatValue(), width.floatValue(), height.floatValue());
            }
            if (this.columnInfoList != null) {
                for (ColumnInfo ci : this.columnInfoList) {
                    ci.resetCurrentTop();
                }
            }
            if (this.glenixPDFWrapperNewPageCallback != null) {
                for (ColumnInfo ci : this.columnInfoList) {
                    ci.parkPreparedStrings();
                }
                this.glenixPDFWrapperNewPageCallback.newPDFPageAdded(this);
                for (ColumnInfo ci : this.columnInfoList) {
                    ci.unparkPreparedStrings();
                }
            }
        }
    }

    public void nextPDPage() throws Exception {
        if (this.currentPageIndex + 1 < this.getNumberOfPages()) {
            ++this.currentPageIndex;
            this.gotoPage(this.currentPageIndex);
            for (ColumnInfo ci : this.columnInfoList) {
                ci.resetCurrentTop();
            }
            return;
        }
        if (this.orientation != null && this.orientation.equals("landscape")) {
            this.addPDPageLandscape();
        } else {
            this.addPDPage();
        }
    }

    public int getNumberOfPages() {
        return this.document.getNumberOfPages();
    }

    public void gotoPage(int pageIndex) throws Exception {
        this.page = this.document.getPage(pageIndex);
    }

    public void gotoPageLocation(int pageIndex, Double top) throws Exception {
        if (pageIndex >= 0 && pageIndex < this.getNumberOfPages()) {
            this.page = this.document.getPage(pageIndex);
            for (ColumnInfo ci : this.columnInfoList) {
                ci.setTop(top);
            }
        }
    }

    public Double getCurrentTop(int comunIndex) {
        ColumnInfo ci = this.columnInfoList.get(comunIndex);
        return ci.getCurrentTop();
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public void savePdfReport(File file) throws Exception {
        this.document.save(file);
        this.document.close();
    }

    public void prepareString(int columnIndex, String text, boolean newLine, boolean joinToLast, Double fontSize, String align) throws Exception {
        ColumnInfo columnInfo = this.columnInfoList.get(columnIndex);
        columnInfo.prepareString(text, newLine, joinToLast, fontSize, align);
    }

    public void prepareString(int columnIndex, String text, boolean newLine, boolean joinToLast, Double fontSize) throws Exception {
        this.prepareString(columnIndex, text, newLine, false, null, "left");
    }

    public void prepareString(int columnIndex, String text, boolean newLine, String align) throws Exception {
        this.prepareString(columnIndex, text, newLine, false, null, align);
    }

    public void prepareString(int columnIndex, String text, boolean newLine) throws Exception {
        this.prepareString(columnIndex, text, newLine, false, null, "left");
    }

    public void prepareString(int columnIndex, String text, boolean newLine, Double fontSize, String align) throws Exception {
        this.prepareString(columnIndex, text, newLine, false, fontSize, align);
    }

    public void prepareString(int columnIndex, String text, boolean newLine, Double fontSize) throws Exception {
        this.prepareString(columnIndex, text, newLine, false, fontSize, "left");
    }

    public void setColumnFont(int columnIndex, PDFont font) {
        ColumnInfo columnInfo = this.columnInfoList.get(columnIndex);
        if (font == null) {
            columnInfo.setColumnFont(PDType1Font.HELVETICA);
        } else {
            columnInfo.setColumnFont(font);
        }
    }

    public PDFont getColumnFont(int columnIndex) {
        ColumnInfo columnInfo = this.columnInfoList.get(columnIndex);
        return columnInfo.getColumnFont();
    }

    public void setColumnSpacingAbove(int columnIndex, Double spacing) {
        ColumnInfo columnInfo = this.columnInfoList.get(columnIndex);
        columnInfo.setSpacingAbove(spacing);
    }

    public void setColumnType(int columnIndex, String columnType) {
        ColumnInfo columnInfo = this.columnInfoList.get(columnIndex);
        columnInfo.setColumnType(columnType);
    }

    public void setTPHeadingColumns(int[] tpHeadingColumns) {
        this.tpHeadingColumns = tpHeadingColumns;
    }

    public void prepareTPStringHeading(String text, boolean newLine, boolean joinToLast, Double fontSize, String align) throws Exception {
        if (this.tpHeadingColumns == null) {
            throw new Exception("Error, trying to write titled pane heading to pdf but no titled pane columns set");
        }
        if (this.currentTPHeadingColumnIndex >= this.tpHeadingColumns.length) {
            throw new Exception("Error, trying to write titled pane heading to pdf but no titled pane index out of bounds");
        }
        this.prepareString(this.tpHeadingColumns[this.currentTPHeadingColumnIndex], text, newLine, joinToLast, fontSize, align);
    }

    public void prepareTPStringHeading(String text, boolean newLine, boolean joinToLast, Double fontSize) throws Exception {
        this.prepareTPStringHeading(text, newLine, false, null, "left");
    }

    public void prepareTPStringHeading(String text, boolean newLine, String align) throws Exception {
        this.prepareTPStringHeading(text, newLine, false, null, align);
    }

    public void prepareTPStringHeading(String text, boolean newLine) throws Exception {
        this.prepareTPStringHeading(text, newLine, false, null, "left");
    }

    public void prepareTPStringHeading(String text, boolean newLine, Double fontSize, String align) throws Exception {
        this.prepareTPStringHeading(text, newLine, false, fontSize, align);
    }

    public void prepareTPStringHeading(String text, boolean newLine, Double fontSize) throws Exception {
        this.prepareTPStringHeading(text, newLine, false, fontSize, "left");
    }

    public void prepareTPStringFullWidthText(String text, boolean newLine, boolean joinToLast, Double fontSize, String align) throws Exception {
        if (this.tpHeadingColumns == null) {
            throw new Exception("Error, trying to write titled pane full width text to pdf but no titled pane columns set");
        }
        if (this.currentTPHeadingColumnIndex >= this.tpHeadingColumns.length) {
            throw new Exception("Error, trying to write titled pane full width text to pdf but no titled pane index out of bounds");
        }
        this.prepareString(this.tpHeadingColumns[this.currentTPHeadingColumnIndex] + 1, text, newLine, joinToLast, fontSize, align);
    }

    public void prepareTPStringFullWidthText(String text, boolean newLine, boolean joinToLast, Double fontSize) throws Exception {
        this.prepareTPStringFullWidthText(text, newLine, false, null, "left");
    }

    public void prepareTPStringFullWidthText(String text, boolean newLine, String align) throws Exception {
        this.prepareTPStringFullWidthText(text, newLine, false, null, align);
    }

    public void prepareTPStringFullWidthText(String text, boolean newLine) throws Exception {
        this.prepareTPStringFullWidthText(text, newLine, false, null, "left");
    }

    public void prepareTPStringFullWidthText(String text, boolean newLine, Double fontSize, String align) throws Exception {
        this.prepareTPStringFullWidthText(text, newLine, false, fontSize, align);
    }

    public void prepareTPStringFullWidthText(String text, boolean newLine, Double fontSize) throws Exception {
        this.prepareTPStringFullWidthText(text, newLine, false, fontSize, "left");
    }

    public void prepareTPStringLabel(String text, boolean newLine, boolean joinToLast, Double fontSize, String align) throws Exception {
        if (this.tpHeadingColumns == null) {
            throw new Exception("Error, trying to write titled pane label to pdf but no titled pane columns set");
        }
        if (this.currentTPHeadingColumnIndex >= this.tpHeadingColumns.length) {
            throw new Exception("Error, trying to write titled pane label to pdf but no titled pane index out of bounds");
        }
        this.prepareString(this.tpHeadingColumns[this.currentTPHeadingColumnIndex] + 2, text, newLine, joinToLast, fontSize, align);
    }

    public void prepareTPStringLabel(String text, boolean newLine, boolean joinToLast, Double fontSize) throws Exception {
        this.prepareTPStringLabel(text, newLine, false, null, "left");
    }

    public void prepareTPStringLabel(String text, boolean newLine, String align) throws Exception {
        this.prepareTPStringLabel(text, newLine, false, null, align);
    }

    public void prepareTPStringLabel(String text, boolean newLine) throws Exception {
        this.prepareTPStringLabel(text, newLine, false, null, "left");
    }

    public void prepareTPStringLabel(String text, boolean newLine, Double fontSize, String align) throws Exception {
        this.prepareTPStringLabel(text, newLine, false, fontSize, align);
    }

    public void prepareTPStringLabel(String text, boolean newLine, Double fontSize) throws Exception {
        this.prepareTPStringLabel(text, newLine, false, fontSize, "left");
    }

    public void prepareTPStringLetter(String text, boolean newLine, boolean joinToLast, Double fontSize, String align) throws Exception {
        if (this.tpHeadingColumns == null) {
            throw new Exception("Error, trying to write titled pane label to pdf but no titled pane columns set");
        }
        if (this.currentTPHeadingColumnIndex >= this.tpHeadingColumns.length) {
            throw new Exception("Error, trying to write titled pane label to pdf but no titled pane index out of bounds");
        }
        this.prepareString(this.tpHeadingColumns[this.currentTPHeadingColumnIndex] + 3, text, newLine, joinToLast, fontSize, align);
    }

    public void prepareTPStringLetter(String text, boolean newLine, boolean joinToLast, Double fontSize) throws Exception {
        this.prepareTPStringLetter(text, newLine, false, null, "left");
    }

    public void prepareTPStringLetter(String text, boolean newLine, String align) throws Exception {
        this.prepareTPStringLetter(text, newLine, false, null, align);
    }

    public void prepareTPStringLetter(String text, boolean newLine) throws Exception {
        this.prepareTPStringLetter(text, newLine, false, null, "left");
    }

    public void prepareTPStringLetter(String text, boolean newLine, Double fontSize, String align) throws Exception {
        this.prepareTPStringLetter(text, newLine, false, fontSize, align);
    }

    public void prepareTPStringLetter(String text, boolean newLine, Double fontSize) throws Exception {
        this.prepareTPStringLetter(text, newLine, false, fontSize, "left");
    }

    public void prepareTPStringValue(String text, boolean newLine, boolean joinToLast, Double fontSize, String align) throws Exception {
        if (this.tpHeadingColumns == null) {
            throw new Exception("Error, trying to write titled pane value to pdf but no titled pane columns set");
        }
        if (this.currentTPHeadingColumnIndex >= this.tpHeadingColumns.length) {
            throw new Exception("Error, trying to write titled pane value to pdf but no titled pane index out of bounds");
        }
        this.prepareString(this.tpHeadingColumns[this.currentTPHeadingColumnIndex] + 4, text, newLine, joinToLast, fontSize, align);
    }

    public void prepareTPStringValue(String text, boolean newLine, boolean joinToLast, Double fontSize) throws Exception {
        this.prepareTPStringValue(text, newLine, false, null, "left");
    }

    public void prepareTPStringValue(String text, boolean newLine, String align) throws Exception {
        this.prepareTPStringValue(text, newLine, false, null, align);
    }

    public void prepareTPStringValue(String text, boolean newLine) throws Exception {
        this.prepareTPStringValue(text, newLine, false, null, "left");
    }

    public void prepareTPStringValue(String text, boolean newLine, Double fontSize, String align) throws Exception {
        this.prepareTPStringValue(text, newLine, false, fontSize, align);
    }

    public void prepareTPStringValue(String text, boolean newLine, Double fontSize) throws Exception {
        this.prepareTPStringValue(text, newLine, false, fontSize, "left");
    }

    public boolean nextTP(boolean drawOnWrap, Double additionalSpace) throws Exception {
        if (this.tpHeadingColumns == null) {
            throw new Exception("Error, nextTP not possible no titled pane columns set");
        }
        if (this.currentTPHeadingColumnIndex >= this.tpHeadingColumns.length) {
            throw new Exception("Error, nextTP not possible no titled pane index out of bounds");
        }
        ++this.currentTPHeadingColumnIndex;
        if (this.currentTPHeadingColumnIndex >= this.tpHeadingColumns.length) {
            this.currentTPHeadingColumnIndex = 0;
            if (drawOnWrap) {
                this.drawStrings(additionalSpace);
                this.drawHorizontalRule(0);
                return true;
            }
        }
        return false;
    }

    public void nextTP() throws Exception {
        this.nextTP(true, 0.0);
    }

    public void ruleOffTP(Double additionalSpace) throws Exception {
        int[] cols;
        if (this.tpHeadingColumns == null) {
            throw new Exception("Error, ruleOffTP not possible no titled pane columns set");
        }
        if (this.currentTPHeadingColumnIndex >= this.tpHeadingColumns.length) {
            throw new Exception("Error, ruleOffTP not possible no titled pane index out of bounds");
        }
        cols = new int[]{this.tpHeadingColumns[this.currentTPHeadingColumnIndex], cols[0] + 1, cols[0] + 2, cols[0] + 3, cols[0] + 4};
        this.ruleOff(cols, additionalSpace);
    }

    public void ruleOffTP() throws Exception {
        this.ruleOffTP(0.0);
    }

    public void drawStrings(Double additionalSpace) throws Exception {
        Double maxHeight = 0.0;
        int cindex = 0;
        for (ColumnInfo ci : this.columnInfoList) {
            Double thisHeight = ci.getHeightOfPreparedStrings();
            if (thisHeight > maxHeight) {
                maxHeight = thisHeight;
            }
            ++cindex;
        }
        Double currentTop = this.columnInfoList.get(0).getCurrentTop();
        if (maxHeight > currentTop - this.marginBottom * (double)MM_TO_UNITS) {
            this.nextPDPage();
        }
        for (ColumnInfo ci : this.columnInfoList) {
            ci.drawStrings();
        }
        for (ColumnInfo ci : this.columnInfoList) {
            ci.moveCurrentTop(-(maxHeight + additionalSpace));
        }
    }

    public void drawStrings() throws Exception {
        this.drawStrings(0.0);
    }

    public void ruleOff(int[] columns, Double additionalSpace) throws Exception {
        Double thisHeight;
        ColumnInfo ci;
        int i;
        Double maxHeight = 0.0;
        for (i = 0; i < columns.length; ++i) {
            ci = this.columnInfoList.get(columns[i]);
            thisHeight = ci.getHeightOfPreparedStrings();
            if (!(thisHeight > maxHeight)) continue;
            maxHeight = thisHeight;
        }
        if ((maxHeight = Double.valueOf(maxHeight + additionalSpace)) > 0.0) {
            for (i = 0; i < columns.length; ++i) {
                ci = this.columnInfoList.get(columns[i]);
                thisHeight = ci.getHeightOfPreparedStrings();
                if (!(maxHeight > thisHeight)) continue;
                ci.addNullStringWithHeight(maxHeight - thisHeight);
            }
        }
    }

    public void ruleOff(int[] columns) throws Exception {
        this.ruleOff(columns, this.ruleOffSpacing);
    }

    public void ruleOff(Double additionalSpacing) throws Exception {
        int[] cols = new int[this.columnInfoList.size()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = i;
        }
        this.ruleOff(cols, additionalSpacing);
    }

    public void drawHorizontalRule(int column) throws Exception {
        this.columnInfoList.get(column).drawHorizontalRule();
    }

    private class ColumnInfo {
        Double leftPos = 10.0 * (double)MM_TO_UNITS;
        Double width = 190.0 * (double)MM_TO_UNITS;
        Double usedWidth = 0.0;
        Double currentTop = 286.0 * (double)MM_TO_UNITS;
        Double totalHeight = -1.0;
        private PDPageContentStream contentStream = null;
        boolean hasBegun = false;
        ArrayList<PreparedString> preparedStrings = new ArrayList();
        boolean isOnNewLine = true;
        PDFont defaultFont = null;
        Double spacingAbove = null;
        String columnType = null;
        Stack<ArrayList<PreparedString>> parkedPreparedStrings = new Stack();

        public void setColumnType(String columnType) {
            this.columnType = columnType;
        }

        public void setLeftPosAndWidth(Double leftPos, Double width) throws Exception {
            this.leftPos = leftPos;
            this.width = width;
        }

        public void parkPreparedStrings() {
            this.parkedPreparedStrings.push(this.preparedStrings);
            this.preparedStrings = new ArrayList();
        }

        public void unparkPreparedStrings() {
            this.preparedStrings = this.parkedPreparedStrings.pop();
        }

        public Double getLeftPos() {
            return this.leftPos;
        }

        public Double getWidth() {
            return this.width;
        }

        public Double getLeftPosMM() {
            return this.leftPos / (double)MM_TO_UNITS;
        }

        public Double getWidthMM() {
            return this.width / (double)MM_TO_UNITS;
        }

        public void setLeftPosAndWidthMM(Double leftMM, Double widthMM) throws Exception {
            this.leftPos = leftMM * (double)MM_TO_UNITS;
            this.width = widthMM * (double)MM_TO_UNITS;
        }

        public void setTop(Double top) throws Exception {
            this.currentTop = top;
        }

        public void setTopMM(Double topMM) throws Exception {
            this.currentTop = topMM * (double)MM_TO_UNITS;
        }

        public Double getCurrentTop() {
            return this.currentTop;
        }

        public void setSpacingAbove(Double spacingAbove) {
            this.spacingAbove = spacingAbove;
        }

        public void setColumnFont(PDFont font) {
            this.defaultFont = font;
        }

        public PDFont getColumnFont() {
            return this.defaultFont;
        }

        public void prepareString(String theString, boolean startOnNewLine, boolean joinToLast, Double fontSize, String align) throws Exception {
            this.totalHeight = -1.0;
            PreparedString aNewPreparedString = new PreparedString(theString, startOnNewLine, align);
            if (this.defaultFont != null) {
                aNewPreparedString.setFont(this.defaultFont);
            }
            if (fontSize != null && fontSize != 12.0) {
                aNewPreparedString.setFontSize(fontSize);
            }
            this.preparedStrings.add(aNewPreparedString);
            if (startOnNewLine) {
                this.usedWidth = 0.0;
            }
            String popString = null;
            Double ifNoBreakWidth = this.width;
            if (joinToLast) {
                ifNoBreakWidth = 0.0;
            }
            while ((popString = aNewPreparedString.popNextLine(this.width - this.usedWidth, ifNoBreakWidth)) != null) {
                this.usedWidth = 0.0;
                aNewPreparedString = new PreparedString(popString, true, align);
                if (this.defaultFont != null) {
                    aNewPreparedString.setFont(this.defaultFont);
                }
                if (fontSize != null && fontSize != 12.0) {
                    aNewPreparedString.setFontSize(fontSize);
                }
                this.preparedStrings.add(aNewPreparedString);
            }
            this.usedWidth = this.usedWidth + aNewPreparedString.getTheStringWidth();
        }

        public Double lineMaxHeight(int index) throws Exception {
            Double maxHeight = 0.0;
            boolean first = true;
            while (index < this.preparedStrings.size()) {
                PreparedString ps = this.preparedStrings.get(index);
                if (!first && ps.startOnNewLine) break;
                Double height = ps.getHeight();
                if (height > maxHeight) {
                    maxHeight = height;
                }
                ++index;
                first = false;
            }
            if (this.spacingAbove != null && this.spacingAbove != 0.0) {
                return maxHeight + this.spacingAbove;
            }
            return maxHeight;
        }

        public Double lineWidth(int index) throws Exception {
            Double width = 0.0;
            boolean first = true;
            while (index < this.preparedStrings.size()) {
                PreparedString ps = this.preparedStrings.get(index);
                if (!first && ps.startOnNewLine) break;
                width = width + ps.getTheStringWidth();
                ++index;
                first = false;
            }
            return width;
        }

        public Double getHeightOfPreparedStrings() throws Exception {
            if (this.totalHeight < 0.0) {
                this.totalHeight = 0.0;
                for (int i = 0; i < this.preparedStrings.size(); ++i) {
                    PreparedString ps = this.preparedStrings.get(i);
                    if (i != 0 && !ps.startOnNewLine) continue;
                    this.totalHeight = this.totalHeight + this.lineMaxHeight(i);
                }
            }
            return this.totalHeight;
        }

        public void drawStrings() throws Exception {
            if (this.preparedStrings.size() == 0) {
                return;
            }
            this.contentStream = new PDPageContentStream(GlenixPDFWrapper.this.document, GlenixPDFWrapper.this.page, true, true);
            PDPageContentStream letterCS = null;
            this.isOnNewLine = true;
            this.contentStream.beginText();
            this.contentStream.moveTextPositionByAmount(this.leftPos.floatValue(), this.currentTop.floatValue());
            Double thisCurrentTop = this.currentTop;
            Double lastThisCurrentTop = this.currentTop;
            Double lastLeft = null;
            Double lastWidth = null;
            Double lastHeight = null;
            boolean lastIsNotNull = false;
            float lastIndent = 0.0f;
            for (int i = 0; i < this.preparedStrings.size(); ++i) {
                PreparedString ps = this.preparedStrings.get(i);
                if (ps.startOnNewLine) {
                    float thisIndent;
                    Double lineWidth;
                    String align;
                    Double height = this.lineMaxHeight(i);
                    if (this.columnType != null && this.columnType.equals("TRLABEL")) {
                        if (lastIsNotNull && lastWidth != null && lastWidth > 0.0 && lastHeight != null && lastHeight > 0.0 && lastLeft != null) {
                            if (letterCS == null) {
                                letterCS = new PDPageContentStream(GlenixPDFWrapper.this.document, GlenixPDFWrapper.this.page, true, true);
                            }
                            letterCS.setStrokingColor(Color.LIGHT_GRAY);
                            letterCS.setLineWidth(1.0f);
                            Double boxWidth = Math.floor((lastWidth + 7.0) / 6.0) * 6.0;
                            Double leftPos = lastLeft - (boxWidth - lastWidth) / 2.0;
                            letterCS.addRect(leftPos.floatValue(), lastThisCurrentTop.floatValue() - lastHeight.floatValue() * 1.1f, boxWidth.floatValue(), lastHeight.floatValue() * 0.9f);
                            lastIsNotNull = false;
                        }
                        lastThisCurrentTop = thisCurrentTop;
                        thisCurrentTop = thisCurrentTop - height;
                        lastWidth = this.lineWidth(i);
                        lastHeight = height;
                    }
                    if ((align = ps.getAlign()) != null && align.equals("right")) {
                        lineWidth = this.lineWidth(i);
                        thisIndent = (float)(this.width - lineWidth);
                        lastLeft = this.leftPos + (double)thisIndent;
                        this.contentStream.moveTextPositionByAmount(thisIndent - lastIndent, -height.floatValue());
                        lastIndent = thisIndent;
                    } else if (align != null && align.equals("centre")) {
                        lineWidth = this.lineWidth(i);
                        thisIndent = (float)((this.width - lineWidth) / 2.0);
                        lastLeft = this.leftPos + (double)thisIndent;
                        this.contentStream.moveTextPositionByAmount(thisIndent - lastIndent, -height.floatValue());
                        lastIndent = thisIndent;
                    } else {
                        lastLeft = this.leftPos;
                        this.contentStream.moveTextPositionByAmount(-lastIndent, -height.floatValue());
                        lastIndent = 0.0f;
                    }
                }
                this.contentStream.setFont(ps.getFont(), ps.getFontSize().floatValue());
                if (ps.theString == null) continue;
                this.contentStream.drawString(ps.theString);
                lastIsNotNull = true;
            }
            if (this.columnType != null && this.columnType.equals("TRLABEL") && lastIsNotNull && lastWidth != null && lastWidth > 0.0 && lastHeight != null && lastHeight > 0.0 && lastLeft != null) {
                if (letterCS == null) {
                    letterCS = new PDPageContentStream(GlenixPDFWrapper.this.document, GlenixPDFWrapper.this.page, true, true);
                }
                letterCS.setStrokingColor(Color.LIGHT_GRAY);
                letterCS.setLineWidth(1.0f);
                Double boxWidth = Math.floor((lastWidth + 7.0) / 6.0) * 6.0;
                Double leftPos = lastLeft - (boxWidth - lastWidth) / 2.0;
                letterCS.addRect(leftPos.floatValue(), lastThisCurrentTop.floatValue() - lastHeight.floatValue() * 1.1f, boxWidth.floatValue(), lastHeight.floatValue() * 0.9f);
            }
            if (letterCS != null) {
                letterCS.close();
            }
            this.contentStream.endText();
            this.contentStream.close();
            this.preparedStrings = new ArrayList();
            this.totalHeight = -1.0;
        }

        public void moveCurrentTop(Double moveQuantity) {
            ColumnInfo columnInfo = this;
            columnInfo.currentTop = columnInfo.currentTop + moveQuantity;
        }

        public void resetCurrentTop() {
            if (GlenixPDFWrapper.this.currentPageIndex < 0 || GlenixPDFWrapper.this.currentPageIndex >= GlenixPDFWrapper.this.pageTops.size()) {
                return;
            }
            Double currentPageTop = (Double)GlenixPDFWrapper.this.pageTops.get(GlenixPDFWrapper.this.currentPageIndex);
            this.currentTop = currentPageTop != null ? currentPageTop : Double.valueOf(286.0 * (double)MM_TO_UNITS);
        }

        public void addNullStringWithHeight(Double height) throws Exception {
            PreparedString aNewPreparedString = new PreparedString(null, true);
            aNewPreparedString.setHeight(height);
            this.preparedStrings.add(aNewPreparedString);
            if (this.totalHeight >= 0.0) {
                this.totalHeight = this.totalHeight + height;
            }
        }

        public void drawHorizontalRule() throws Exception {
            this.contentStream = new PDPageContentStream(GlenixPDFWrapper.this.document, GlenixPDFWrapper.this.page, true, true);
            this.contentStream.setStrokingColor(Color.LIGHT_GRAY);
            this.contentStream.setLineWidth(1.0f);
            this.contentStream.drawLine(this.leftPos.floatValue(), this.currentTop.floatValue(), this.leftPos.floatValue() + this.width.floatValue(), this.currentTop.floatValue());
            this.contentStream.close();
        }
    }

    private class PreparedString {
        String theString = null;
        Double theStringWidth = 0.0;
        boolean startOnNewLine = false;
        Double fontSize = 10.0;
        Double setHeight = -1.0;
        PDFont font;
        String align;

        public PreparedString(String theString, boolean startOnNewLine) throws Exception {
            this.font = GlenixPDFWrapper.this.muliLightFont;
            this.align = "left";
            this.theString = theString;
            this.startOnNewLine = startOnNewLine;
            if (this.font == null) {
                this.font = PDType1Font.HELVETICA;
            }
            this.theStringWidth = theString == null ? Double.valueOf(0.0) : this.calculateWidth();
        }

        public PreparedString(String theString, boolean startOnNewLine, String align) throws Exception {
            this(theString, startOnNewLine);
            this.align = align;
        }

        public void setAlign(String align) {
            this.align = align;
        }

        public String getAlign() {
            return this.align;
        }

        public void setFont(PDFont font) throws Exception {
            if (font == null) {
                font = PDType1Font.HELVETICA;
            }
            this.font = font;
            this.theStringWidth = 0.0;
            this.theStringWidth = this.theString == null ? Double.valueOf(0.0) : this.calculateWidth();
        }

        public PDFont getFont() {
            if (this.font == null) {
                this.font = PDType1Font.HELVETICA;
            }
            return this.font;
        }

        public void setFontSize(Double fontSize) throws Exception {
            this.theStringWidth = this.theString == null ? Double.valueOf(0.0) : Double.valueOf(this.theStringWidth * fontSize / this.fontSize);
            this.fontSize = fontSize;
        }

        public Double getFontSize() {
            return this.fontSize;
        }

        public void setHeight(Double height) {
            this.setHeight = height;
        }

        public Double getHeight() throws Exception {
            if (this.setHeight > 0.0) {
                return this.setHeight;
            }
            if (this.font == null) {
                this.font = PDType1Font.HELVETICA;
            }
            if (this.font == GlenixPDFWrapper.this.muliLightFont || this.font == GlenixPDFWrapper.this.muliRegularFont || this.font == GlenixPDFWrapper.this.muliBoldFont) {
                return ((double)this.font.getBoundingBox().getHeight() * this.fontSize - 2000.0) / 1000.0;
            }
            return (double)this.font.getBoundingBox().getHeight() * this.fontSize / 1000.0;
        }

        private Double calculateWidth() {
            byte[] theBytes = this.theString.getBytes();
            Double totalWidth = 0.0;
            for (int pos = 0; pos < theBytes.length; ++pos) {
                if (!WinAnsiEncoding.INSTANCE.contains(theBytes[pos])) continue;
                try {
                    totalWidth = totalWidth + (double)this.font.getWidth(theBytes[pos]) * this.fontSize / 1000.0;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return totalWidth;
        }

        private boolean contains(int[] ints, int theint) {
            for (int i = 0; i < ints.length; ++i) {
                if (ints[i] != theint) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String popNextLine(Double width, Double ifNoBreakWidth) throws Exception {
            if (this.theString == null) {
                return null;
            }
            byte[] theBytes = this.theString.getBytes();
            Double totalWidth = 0.0;
            if (this.font == null) {
                this.font = PDType1Font.HELVETICA;
            }
            if (this.theStringWidth <= width) {
                int pos = 0;
                while (true) {
                    if (pos >= theBytes.length) {
                        return null;
                    }
                    if (WinAnsiEncoding.INSTANCE.contains(theBytes[pos])) {
                        totalWidth = totalWidth + (double)this.font.getWidth(theBytes[pos]) * this.fontSize / 1000.0;
                    }
                    if (theBytes[pos] == 10) {
                        if (pos + 1 == theBytes.length) {
                            this.theString = new String(theBytes, 0, pos);
                            return null;
                        }
                        String result = new String(theBytes, pos + 1, theBytes.length - pos - 1);
                        this.theString = new String(theBytes, 0, pos);
                        this.theStringWidth = totalWidth;
                        return result;
                    }
                    ++pos;
                }
            }
            int lastBreakable = 0;
            Double lastTotalWidth = 0.0;
            Double lastBreakableWidth = 0.0;
            int[] lineBreakable = new int[]{32, 33, 63, 47};
            int pos = 0;
            while (true) {
                block22: {
                    if (pos >= theBytes.length) {
                        return null;
                    }
                    lastTotalWidth = totalWidth;
                    if (WinAnsiEncoding.INSTANCE.contains(theBytes[pos])) {
                        totalWidth = totalWidth + (double)this.font.getWidth(theBytes[pos]) * this.fontSize / 1000.0;
                    }
                    if (totalWidth > width) {
                        if (theBytes[pos] == 32 || theBytes[pos] == 10) {
                            if (pos + 1 == theBytes.length) {
                                if (theBytes[pos] == 10) {
                                    this.theString = new String(theBytes, 0, pos);
                                }
                                return null;
                            }
                            String result = new String(theBytes, pos + 1, theBytes.length - pos - 1);
                            this.theString = theBytes[pos] == 10 ? new String(theBytes, 0, pos) : new String(theBytes, 0, pos + 1);
                            this.theStringWidth = totalWidth;
                            return result;
                        }
                        if (lastBreakable > 0) {
                            String result = new String(theBytes, lastBreakable + 1, theBytes.length - lastBreakable - 1);
                            this.theString = new String(theBytes, 0, lastBreakable + 1);
                            this.theStringWidth = lastBreakableWidth;
                            return result;
                        }
                        if (ifNoBreakWidth > width) {
                            width = ifNoBreakWidth;
                            this.startOnNewLine = true;
                            break block22;
                        } else {
                            if (pos == 0) {
                                String result = new String(theBytes, 1, theBytes.length - 1);
                                this.theString = new String(theBytes, 0, 1);
                                this.theStringWidth = totalWidth;
                                return result;
                            }
                            String result = new String(theBytes, pos, theBytes.length - pos);
                            this.theString = new String(theBytes, 0, pos);
                            this.theStringWidth = lastTotalWidth;
                            return result;
                        }
                    }
                    if (theBytes[pos] == 10) {
                        if (pos + 1 == theBytes.length) {
                            this.theString = new String(theBytes, 0, pos);
                            return null;
                        }
                        String result = new String(theBytes, pos + 1, theBytes.length - pos - 1);
                        this.theString = new String(theBytes, 0, pos);
                        this.theStringWidth = totalWidth;
                        return result;
                    }
                }
                if (this.contains(lineBreakable, theBytes[pos])) {
                    lastBreakable = pos;
                    lastBreakableWidth = totalWidth;
                }
                ++pos;
            }
        }

        public Double getTheStringWidth() {
            return this.theStringWidth;
        }
    }

    private class PDFWrapperImage {
        Double x;
        Double y;
        Double width;
        Double height;
        PDImageXObject pdImage;
        String imageLocation;

        public PDFWrapperImage(PDImageXObject pdImage) {
            this.pdImage = pdImage;
        }

        public void setX(Double x) {
            this.x = x;
        }

        public void setY(Double y) {
            this.y = y;
        }

        public Double getX() {
            return this.x;
        }

        public Double getY() {
            return this.y;
        }

        public void setWidth(Double width) {
            this.width = width;
        }

        public void setHeight(Double height) {
            this.height = height;
        }

        public Double getWidth() {
            if (this.height != null && this.width == null) {
                int pixelWidth = this.pdImage.getWidth();
                int pixelHeight = this.pdImage.getHeight();
                return this.height * (double)pixelWidth / (double)pixelHeight;
            }
            if (this.height == null && this.width == null) {
                return (double)this.pdImage.getWidth() * 25.4 / 300.0;
            }
            return this.width;
        }

        public Double getHeight() {
            if (this.height == null && this.width != null) {
                int pixelWidth = this.pdImage.getWidth();
                int pixelHeight = this.pdImage.getHeight();
                return this.width * (double)pixelHeight / (double)pixelWidth;
            }
            if (this.height == null && this.width == null) {
                return (double)this.pdImage.getHeight() * 25.4 / 300.0;
            }
            return this.height;
        }

        public PDImageXObject getPDImage() {
            return this.pdImage;
        }

        public void setImageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
        }

        public String getImageLocation() {
            return this.imageLocation;
        }
    }
}

