/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelTextController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixLabelWPNController
extends GlenixLabelTextController {
    private String lastValidatedValue = null;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
    }

    @Override
    protected void validateEdit(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        if (newValue != null && !newValue.matches("^[0-9]{0,9}$")) {
            this.setText(oldValue);
        } else if (this.lastValidatedValue == null && newValue != null || this.lastValidatedValue != null && !this.lastValidatedValue.equals(newValue)) {
            this.lastValidatedValue = newValue;
            if (this.changeListener != null) {
                this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
            }
        }
    }

    @Override
    protected void validateFinal(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (newValue == null || !newValue.booleanValue()) {
            String textValue = this.getText();
            if (textValue != null && !textValue.isEmpty()) {
                if (!textValue.matches("^[0-9]{8,9}$")) {
                    this.setText("");
                    this.setErrorDisplay(null);
                } else if (!this.checkWPN9(textValue)) {
                    this.setErrorDisplay("error");
                } else {
                    this.setErrorDisplay(null);
                }
            } else {
                this.setErrorDisplay(null);
            }
        }
    }

    protected void validateFriendly(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (newValue == null || !newValue.booleanValue()) {
            String textValue = this.getText();
            if (textValue != null && !textValue.isEmpty()) {
                if (!textValue.matches("^[0-9]{8,9}$") || !this.checkWPN9(textValue)) {
                    this.setErrorDisplay("error");
                } else {
                    this.setErrorDisplay(null);
                }
            } else {
                this.setErrorDisplay(null);
            }
        }
    }

    private boolean checkWPN(String value) {
        if (value.length() == 11) {
            int[] weights = new int[]{0, 0, 10, 7, 8, 4, 6, 3, 5, 2, 1};
            int total = 0;
            char c = value.charAt(0);
            if (c != '0') {
                return false;
            }
            c = value.charAt(1);
            if (c != '0') {
                return false;
            }
            for (int i = 2; i < 11; ++i) {
                c = value.charAt(i);
                int ci = Character.getNumericValue(c);
                if (ci < 0) {
                    return false;
                }
                total += weights[i] * ci;
            }
            if (total % 11 == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean checkWPN9(String value) {
        if (value.length() == 9) {
            int[] weights = new int[]{10, 7, 8, 4, 6, 3, 5, 2, 1};
            int total = 0;
            for (int i = 0; i < 9; ++i) {
                char c = value.charAt(i);
                int ci = Character.getNumericValue(c);
                if (ci < 0) {
                    return false;
                }
                total += weights[i] * ci;
            }
            if (total % 11 == 0) {
                return true;
            }
        } else if (value.length() == 8) {
            int[] weights = new int[]{10, 7, 8, 4, 6, 3, 5, 1};
            int total = 0;
            for (int i = 0; i < 8; ++i) {
                char c = value.charAt(i);
                int ci = Character.getNumericValue(c);
                if (ci < 0) {
                    return false;
                }
                total += weights[i] * ci;
            }
            if (total % 11 == 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) {
        super.loadGlenixXBRL(loadDoc, loadElement);
        this.validateFriendly(null, null, null);
    }
}

