/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelText;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;

public class GlenixLabelTwoDecimalNumber
extends GlenixLabelText {
    protected String lastValidatedValue = null;
    private NumberFormat format2dp = new DecimalFormat("#0.00");
    DecimalFormat numberFormat;

    public GlenixLabelTwoDecimalNumber(String decfmt) throws Exception {
        this.numberFormat = new DecimalFormat(decfmt);
        this.glenixText.setAlignment(Pos.CENTER_RIGHT);
    }

    public GlenixLabelTwoDecimalNumber() throws Exception {
        this("#0.00");
    }

    @Override
    public String getPDFLabelLetter() {
        return this.getGlenixElementTRLabel();
    }

    @Override
    public String getPDFValueAlignment() {
        return "right";
    }

    @Override
    public String getPDFValue() {
        Double d = this.getDouble();
        if (d == null) {
            return null;
        }
        return this.numberFormat.format(d);
    }

    @Override
    public String getPDFLabel() {
        return this.getGlenixElementDescription();
    }

    @Override
    public String getEditRegexPattern() {
        return "^-?[0-9]*(\\.[0-9]{0,2})?$";
    }

    @Override
    public String getFinalRegexPattern() {
        return "^-?[0-9]*(\\.[0-9]{1,2})?$";
    }

    @Override
    protected void validateFinal(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (!newValue.booleanValue()) {
            String pattern = this.getFinalRegexPattern();
            if (pattern == null || pattern.isEmpty()) {
                return;
            }
            String textValue = this.glenixText.getText();
            if (textValue != null && !textValue.matches("^-?[0-9]*(\\.[0-9]{1,2})?$")) {
                textValue = textValue.replace(".", "");
            }
            this.glenixText.setText(this.formatTwoDp(textValue));
        }
    }

    protected String formatTwoDp(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try {
            Number number = this.format2dp.parse(text);
            return this.format2dp.format(number);
        }
        catch (Exception e) {
            return null;
        }
    }
}

