/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelTextController;
import java.net.URL;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.util.converter.LocalTimeStringConverter;

public class GlenixLabelTimeController
extends GlenixLabelTextController {
    private ChangeListener<String> changeListener = null;
    private String lastValidatedValue = null;
    private LocalTimeStringConverter localTimeStringConverter = new LocalTimeStringConverter();
    private DateTimeFormatter inputTimeFormatter;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.inputTimeFormatter = DateTimeFormatter.ISO_LOCAL_TIME;
        this.glenixText.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null && !newValue.matches("^[0-9]{0,2}(:[0-9]{0,2}(:[0-9]{0,2})?)?$")) {
                    GlenixLabelTimeController.this.glenixText.setText(oldValue);
                } else if (GlenixLabelTimeController.this.lastValidatedValue == null && newValue != null || GlenixLabelTimeController.this.lastValidatedValue != null && !GlenixLabelTimeController.this.lastValidatedValue.equals(newValue)) {
                    GlenixLabelTimeController.this.lastValidatedValue = newValue;
                    if (GlenixLabelTimeController.this.changeListener != null) {
                        GlenixLabelTimeController.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                    }
                }
            }
        });
        this.glenixText.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    String textValue = GlenixLabelTimeController.this.glenixText.getText();
                    if (textValue != null && textValue.matches("^[0-9]{1}:[0-9]{2}(:[0-9]{2})?$")) {
                        textValue = "0" + textValue;
                        GlenixLabelTimeController.this.glenixText.setText(textValue);
                        return;
                    }
                    if (textValue != null && !textValue.matches("^[0-9]{1,2}(:[0-9]{1,2}(:[0-9]{1,2})?)?$")) {
                        GlenixLabelTimeController.this.glenixText.getStyleClass().add((Object)"textFieldError");
                    } else {
                        try {
                            LocalTime lt = LocalTime.parse(textValue, GlenixLabelTimeController.this.inputTimeFormatter);
                            if (lt != null) {
                                GlenixLabelTimeController.this.glenixText.setText(lt.format(GlenixLabelTimeController.this.inputTimeFormatter));
                                GlenixLabelTimeController.this.glenixText.getStyleClass().removeAll((Object[])new String[]{"textFieldError"});
                            } else {
                                GlenixLabelTimeController.this.glenixText.getStyleClass().add((Object)"textFieldError");
                            }
                        }
                        catch (Exception e) {
                            GlenixLabelTimeController.this.glenixText.getStyleClass().add((Object)"textFieldError");
                        }
                    }
                }
            }
        });
    }

    public boolean glenixTextIsEmpty() {
        String textValue = this.glenixText.getText();
        return textValue == null || textValue.equals("");
    }

    public LocalTime getLocalTime() {
        String textValue = this.glenixText.getText();
        if (textValue == null || textValue.equals("")) {
            return null;
        }
        LocalTime lt = null;
        try {
            lt = LocalTime.parse(textValue, this.inputTimeFormatter);
        }
        catch (Exception e) {
            lt = null;
        }
        return lt;
    }

    @Override
    public String getGlenixElementValue() {
        LocalTime lt = this.getLocalTime();
        if (lt == null) {
            return null;
        }
        return lt.format(this.inputTimeFormatter);
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        if (glenixElementValue == null || glenixElementValue.equals("")) {
            this.glenixText.setText(null);
            return;
        }
        LocalTime lt = null;
        try {
            lt = LocalTime.parse(glenixElementValue, this.inputTimeFormatter);
        }
        catch (Exception e) {
            lt = null;
        }
        if (lt == null) {
            this.glenixText.setText(null);
        }
        LocalTime uset = lt.truncatedTo(ChronoUnit.MINUTES);
        this.glenixText.setText(uset.format(this.inputTimeFormatter));
    }

    public void setLocalTime(LocalTime lt) {
        LocalTime uset = lt.truncatedTo(ChronoUnit.MINUTES);
        this.glenixText.setText(uset.format(this.inputTimeFormatter));
    }

    public void setTimeBySeconds(Integer seconds) {
        LocalTime lt = null;
        try {
            lt = LocalTime.parse("00:00:00", this.inputTimeFormatter);
        }
        catch (Exception e) {
            lt = null;
        }
        if (lt == null) {
            this.glenixText.setText(null);
        }
        lt = lt.plusSeconds(seconds.intValue());
        this.glenixText.setText(lt.format(this.inputTimeFormatter));
    }

    @Override
    public void setSingleChangeListener(ChangeListener<String> changeListener) {
        this.changeListener = changeListener;
    }
}

